<?php
/**
 * Class to handle notifications related to GSC.
 *
 * @package SurferSEO
 */

namespace SurferSEO\Surfer\GSC;

/**
 * Class to handle notifications in wp-admin related to GSC.
 */
class Surfer_GSC_Notifications {

	use Surfer_GSC_Common;

	/**
	 * Object construct.
	 */
	public function __construct() {
		add_action( 'init', array( $this, 'init' ) );
	}

	/**
	 * Init function.
	 */
	public function init() {

		add_action( 'admin_notices', array( $this, 'notify_enable_gsc' ) );
		add_action( 'admin_notices', array( $this, 'notify_new_gsc_data_collected' ) );
		add_action( 'admin_init', array( $this, 'save_enable_email_performance_report' ) );
	}

	/**
	 * Displays notification asking for tracking permission.
	 *
	 * @return void
	 */
	public function notify_enable_gsc() {
		$connected = Surfer()->get_surfer()->is_surfer_connected();

		if ( ! $connected || Surfer()->get_surfer()->get_gsc()->check_if_gsc_connected() ) {
			return;
		}

		$dismissals = (array) get_option( 'surfer_notification_dismissals' );

		?>
		<?php if ( ! in_array( 'gsc_question', $dismissals, true ) ) : ?>
		<div class="notice notice-surfer is-dismissible">
			<h3><?php esc_html_e( 'Data-driven SEO optimization with Surfer and Google Search Console', 'surferseo' ); ?></h3>
			<p><?php esc_html_e( 'Would you like to add Google Search Console (GSC) data to this plugin and see how your website performs?', 'surferseo' ); ?></p>
			<p>
				<a href="<?php echo esc_url( admin_url( 'index.php?page=surfer#surfer_gsc_connection' ) ); ?>" class="notice-surfer__button-surfer-primary surfer-analytics" data-event-name="banner_enable_gsc" data-event-data="notification_click">
					<span class="dashicons dashicons-saved"></span>
					<?php esc_html_e( 'Yes, I want to measure my website performance', 'surferseo' ); ?>
				</a>
				<a href="<?php echo esc_url( admin_url( sprintf( 'index.php?%s', http_build_query( array_merge( $_GET, array( 'surfer-dismiss-and-save' => 'gsc_question' ) ) ) ) ) ); ?>" class="notice-surfer__button-surfer">
					<span class="dashicons dashicons-no-alt"></span>
					<?php esc_html_e( 'No, thanks', 'surferseo' ); ?>
				</a>
			</p>
		</div>
		<?php endif; ?>
		<?php
	}

	/**
	 * Displays wp-admin notification about new data collected from GSC.
	 */
	public function notify_new_gsc_data_collected() {

		$report_is_ready = get_transient( 'surfer_gsc_weekly_report_ready' );

		?>
		<?php if ( true === $report_is_ready ) : ?>
		<div class="notice notice-surfer is-dismissible">
			<h3><?php esc_html_e( 'New site performance data is ready!', 'surferseo' ); ?></h3>
			<p><?php esc_html_e( 'We\'ve gathered new performance data from your Google Search Console and you can now check your posts\' performance. Want to get this info delivered directly to your inbox? Go to the configuration page and select “Send me a weekly report on my site\'s performance."', 'surferseo' ); ?></p>
			<p>
				<a href="<?php echo esc_url( admin_url( 'admin.php?page=surfer-performance-report' ) ); ?>" class="notice-surfer__button-surfer-primary surfer-analytics" data-event-name="banner_gsc_emails" data-event-data="enable_email_notifications">
					<span class="dashicons dashicons-saved"></span>
					<?php esc_html_e( 'I want to check my site\'s performance', 'surferseo' ); ?>
				</a>
				<?php if ( ! $this->performance_report_email_notification_endabled() ) : ?>
				<a href="<?php echo esc_url( admin_url( 'index.php?page=surfer&surfer_enable_email_notification=1' ) ); ?>" class="notice-surfer__button-surfer-primary surfer-analytics" data-event-name="banner_gsc_emails" data-event-data="show_results">
					<span class="dashicons dashicons-email"></span>
					<?php esc_html_e( 'I want to enable email reports in the settings', 'surferseo' ); ?>
				</a>
				<?php endif; ?>
			</p>
		</div>
			<?php
		endif;
		?>
		<?php
	}

	/**
	 * Enable tracking from GET param and redirect to Surfer config.
	 *
	 * @return void
	 */
	public function save_enable_email_performance_report() {
		if ( isset( $_GET['surfer_enable_email_notification'] ) && 1 === (int) $_GET['surfer_enable_email_notification'] ) {
			Surfer()->get_surfer_settings()->save_option( 'content-importer', 'surfer_position_monitor_summary', true );
			wp_safe_redirect( admin_url( 'admin.php?page=surfer#header_position_monitor' ) );
			exit;
		}
	}
}
