<?php
/**
 * Template used on WordPress post list as part of Surfer column with GSC data.
 *
 * @package SurferSEO
 */

?>

<div class="surfer-post-list-traffic">
	<div class="surfer-tooltip">
		<div class="surfer-post-list-traffic__row surfer-post-list-traffic__row--<?php echo esc_html( $position_direction ); ?>">

			<span>
				<?php if ( 0 !== intval( $position ) ) : ?>

					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
						<path d="M18.375 2.25c-1.035 0-1.875.84-1.875 1.875v15.75c0 1.035.84 1.875 1.875 1.875h.75c1.035 0 1.875-.84 1.875-1.875V4.125c0-1.036-.84-1.875-1.875-1.875h-.75zM9.75 8.625c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v11.25c0 1.035-.84 1.875-1.875 1.875h-.75a1.875 1.875 0 01-1.875-1.875V8.625zM3 13.125c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v6.75c0 1.035-.84 1.875-1.875 1.875h-.75A1.875 1.875 0 013 19.875v-6.75z" />
					</svg>
					<?php /* translators: %s - position number in format */ ?>
					<?php printf( esc_html__( '%s position', 'surferseo' ), esc_html( surfer_add_numerical_suffix( $position ) ) ); ?>
				<?php else : ?>
					<?php esc_html_e( 'Not ranked yet.', 'surferseo' ); ?>
				<?php endif; ?>
			</span>

			<?php if ( 'down' === $position_direction ) : ?>
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
				<path fill-rule="evenodd" d="M12 3.75a.75.75 0 01.75.75v13.19l5.47-5.47a.75.75 0 111.06 1.06l-6.75 6.75a.75.75 0 01-1.06 0l-6.75-6.75a.75.75 0 111.06-1.06l5.47 5.47V4.5a.75.75 0 01.75-.75z" clip-rule="evenodd" />
			</svg>
			<?php endif; ?>

			<?php if ( 'up' === $position_direction ) : ?>
			<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" className="w-6 h-6">
				<path fillRule="evenodd" d="M12 20.25a.75.75 0 01-.75-.75V6.31l-5.47 5.47a.75.75 0 01-1.06-1.06l6.75-6.75a.75.75 0 011.06 0l6.75 6.75a.75.75 0 11-1.06 1.06l-5.47-5.47V19.5a.75.75 0 01-.75.75z" clipRule="evenodd" />
			</svg>
			<?php endif; ?>

			<?php if ( 0 !== intval( $position ) && '' === $position_direction ) : ?>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
					<path fill-rule="evenodd" d="M5.25 12a.75.75 0 01.75-.75h12a.75.75 0 010 1.5H6a.75.75 0 01-.75-.75z" clip-rule="evenodd" />
				</svg>
			<?php endif; ?>
		</div>
		<div class="surfer-post-list-traffic__row">

			<?php if ( false !== intval( $clicks ) ) : ?>
			<span>
				<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
					<path fill-rule="evenodd" d="M12 1.5a.75.75 0 01.75.75V4.5a.75.75 0 01-1.5 0V2.25A.75.75 0 0112 1.5zM5.636 4.136a.75.75 0 011.06 0l1.592 1.591a.75.75 0 01-1.061 1.06l-1.591-1.59a.75.75 0 010-1.061zm12.728 0a.75.75 0 010 1.06l-1.591 1.592a.75.75 0 01-1.06-1.061l1.59-1.591a.75.75 0 011.061 0zm-6.816 4.496a.75.75 0 01.82.311l5.228 7.917a.75.75 0 01-.777 1.148l-2.097-.43 1.045 3.9a.75.75 0 01-1.45.388l-1.044-3.899-1.601 1.42a.75.75 0 01-1.247-.606l.569-9.47a.75.75 0 01.554-.68zM3 10.5a.75.75 0 01.75-.75H6a.75.75 0 010 1.5H3.75A.75.75 0 013 10.5zm14.25 0a.75.75 0 01.75-.75h2.25a.75.75 0 010 1.5H18a.75.75 0 01-.75-.75zm-8.962 3.712a.75.75 0 010 1.061l-1.591 1.591a.75.75 0 11-1.061-1.06l1.591-1.592a.75.75 0 011.06 0z" clip-rule="evenodd" />
				</svg>

				<?php echo intval( $clicks ); ?>
			</span>
			<?php endif; ?>

			<?php if ( false !== intval( $impressions ) ) : ?>
			<span>
				<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
					<path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
					<path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
				</svg>

				<?php echo intval( $impressions ); ?>
			</span>
			<?php endif; ?>
		</div>

		<span class="surfer-tooltip__tooltiptext">
			<?php if ( false === $previous_update_date ) : ?>
				<?php esc_html_e( 'We collected data only from one period.', 'surferseo' ); ?>

				<span style="margin-top: 16px;">
					<?php esc_html_e( 'Current period:', 'surferseo' ); ?>
				</span>
				<?php /* translators: %1$s - Date ; %2$s - Date */ ?>
				<?php printf( esc_html__( '%1$s - %2$s', 'surferseo' ), esc_html( gmdate( 'd-m-Y', strtotime( $last_update_date . ' -7 days' ) ) ), esc_html( gmdate( 'd-m-Y', strtotime( $last_update_date ) ) ) ); ?>

			<?php else : ?>
				<?php /* translators: %s - Date of the last update */ ?>
				<?php esc_html_e( '7 days ago:', 'surferseo' ); ?>

				<span>
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
							<path d="M18.375 2.25c-1.035 0-1.875.84-1.875 1.875v15.75c0 1.035.84 1.875 1.875 1.875h.75c1.035 0 1.875-.84 1.875-1.875V4.125c0-1.036-.84-1.875-1.875-1.875h-.75zM9.75 8.625c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v11.25c0 1.035-.84 1.875-1.875 1.875h-.75a1.875 1.875 0 01-1.875-1.875V8.625zM3 13.125c0-1.036.84-1.875 1.875-1.875h.75c1.036 0 1.875.84 1.875 1.875v6.75c0 1.035-.84 1.875-1.875 1.875h-.75A1.875 1.875 0 013 19.875v-6.75z" />
						</svg>
					<?php /* translators: %d - position */ ?>
					<?php printf( esc_html__( '%d position', 'surferseo' ), esc_html( surfer_add_numerical_suffix( $prev_position ) ) ); ?>
				</span>


				<span>
					<svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="currentColor" class="w-6 h-6">
						<path fill-rule="evenodd" d="M12 1.5a.75.75 0 01.75.75V4.5a.75.75 0 01-1.5 0V2.25A.75.75 0 0112 1.5zM5.636 4.136a.75.75 0 011.06 0l1.592 1.591a.75.75 0 01-1.061 1.06l-1.591-1.59a.75.75 0 010-1.061zm12.728 0a.75.75 0 010 1.06l-1.591 1.592a.75.75 0 01-1.06-1.061l1.59-1.591a.75.75 0 011.061 0zm-6.816 4.496a.75.75 0 01.82.311l5.228 7.917a.75.75 0 01-.777 1.148l-2.097-.43 1.045 3.9a.75.75 0 01-1.45.388l-1.044-3.899-1.601 1.42a.75.75 0 01-1.247-.606l.569-9.47a.75.75 0 01.554-.68zM3 10.5a.75.75 0 01.75-.75H6a.75.75 0 010 1.5H3.75A.75.75 0 013 10.5zm14.25 0a.75.75 0 01.75-.75h2.25a.75.75 0 010 1.5H18a.75.75 0 01-.75-.75zm-8.962 3.712a.75.75 0 010 1.061l-1.591 1.591a.75.75 0 11-1.061-1.06l1.591-1.592a.75.75 0 011.06 0z" clip-rule="evenodd" />
					</svg>
					<?php /* translators: %d - Number of clicks */ ?>
					<?php printf( esc_html__( '%d clicks', 'surferseo' ), intval( $prev_clicks ) ); ?>
				</span>


				<span>
					<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
						<path stroke-linecap="round" stroke-linejoin="round" d="M2.036 12.322a1.012 1.012 0 010-.639C3.423 7.51 7.36 4.5 12 4.5c4.638 0 8.573 3.007 9.963 7.178.07.207.07.431 0 .639C20.577 16.49 16.64 19.5 12 19.5c-4.638 0-8.573-3.007-9.963-7.178z" />
						<path stroke-linecap="round" stroke-linejoin="round" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z" />
					</svg>
					<?php /* translators: %d - Number of impressions*/ ?>
					<?php printf( esc_html__( '%d impressions', 'surferseo' ), intval( $prev_impressions ) ); ?> 
				</span>

				<span style="margin-top: 16px;">
					<?php esc_html_e( 'Current period:', 'surferseo' ); ?>
				</span>
				<?php /* translators: %1$s - Date ; %2$s - Date */ ?>
				<?php printf( esc_html__( '%1$s - %2$s', 'surferseo' ), esc_html( gmdate( 'd-m-Y', strtotime( $last_update_date . ' -7 days' ) ) ), esc_html( gmdate( 'd-m-Y', strtotime( $last_update_date ) ) ) ); ?>

				<span style="margin-top: 16px;">
					<?php esc_html_e( 'Previous period:', 'surferseo' ); ?>
				</span>
				<?php /* translators: %1$s - Date ; %2$s - Date */ ?>
				<?php printf( esc_html__( '%1$s - %2$s', 'surferseo' ), esc_html( gmdate( 'd-m-Y', strtotime( $previous_update_date . ' -7 days' ) ) ), esc_html( gmdate( 'd-m-Y', strtotime( $previous_update_date ) ) ) ); ?>
			<?php endif; ?>
		</span>
	</div>

	<div class="surfer-post-list-traffic__row">

		<?php if ( 'down' === $position_direction ) : ?>

			<?php if ( $draft_id > 0 ) : ?>
				<a href="<?php echo esc_attr( Surfer()->get_surfer()->get_surfer_url() . '/drafts/' . intval( $draft_id ) ); ?>" target="_blank"  class="surfer-button surfer-analytics" data-event-name="drop_monitor" data-event-data="edit_in_surfer: DRAFT ID: <?php echo intval( $draft_id ); ?>">
					<?php esc_html_e( 'Edit in Surfer', 'surferseo' ); ?>
					<svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="w-6 h-6">
						<path stroke-linecap="round" stroke-linejoin="round" d="M13.5 6H5.25A2.25 2.25 0 003 8.25v10.5A2.25 2.25 0 005.25 21h10.5A2.25 2.25 0 0018 18.75V10.5m-10.5 6L21 3m0 0h-5.25M21 3v5.25" />
					</svg>
				</a>
			<?php else : ?>
				<div class="surfer-content-export-modal-box" data-post-id="<?php echo intval( $post_id ); ?>"></div>
			<?php endif; ?>

		<?php endif; ?>
	</div>
</div>

