<?php
/*
Plugin Name: OpenAI Blog Generator
Description: Generate blog titles and content using OpenAI.
Version: 1.3
Author: Your Name
*/

// Define the default API key
$default_api_key = 'your_default_api_key';

// Initialize the API key option
add_option('openai_api_key', $default_api_key);

// Define a function to generate blog content
function generate_blog_content($keywords) {
    $api_key = get_option('openai_api_key'); // Get the API key from options

    return $api_key;

    /* // Prepare the data to send to the OpenAI API
    $data = array(
        'prompt' => "Generate a blog title and content for keywords: " . implode(', ', $keywords),
        'max_tokens' => 200, // Adjust as needed
    );

    // Create the API request
    $request = curl_init('https://api.openai.com/v1/engines/gpt-3.5-turbo/completions');
    curl_setopt($request, CURLOPT_POST, 1);
    curl_setopt($request, CURLOPT_POSTFIELDS, json_encode($data));
    curl_setopt($request, CURLOPT_HTTPHEADER, array(
        'Content-Type: application/json',
        'Authorization: Bearer ' . $api_key,
    ));
    curl_setopt($request, CURLOPT_RETURNTRANSFER, true);

    // Execute the API request
    $response = curl_exec($request);

    // Check for errors
    if (curl_errno($request)) {
        return 'Error: ' . curl_error($request);
    }

    // Decode the JSON response
    $result = json_decode($response, true);

    // Extract and return the generated content
    return $result['choices'][0]['text']; */
}

// Add a settings page to input and save the API key
function openai_settings_menu() {
    add_menu_page('OpenAI Settings', 'OpenAI Settings', 'manage_options', 'openai-settings', 'openai_settings_page');
}

// Define the settings page content
function openai_settings_page() {
    if (isset($_POST['openai_api_key'])) {
        update_option('openai_api_key', $_POST['openai_api_key']);
        echo '<div class="updated"><p>API key saved.</p></div>';
    }

    $current_api_key = get_option('openai_api_key');
    ?>
    <div class="wrap">
        <h2>OpenAI Settings</h2>
        <form method="post" action="">
            <label for="openai_api_key">API Key:</label>
            <input type="text" id="openai_api_key" name="openai_api_key" value="<?php echo esc_attr($current_api_key); ?>" size="60">
            <p>Enter your OpenAI API key.</p>
            <input type="submit" class="button-primary" value="Save Key">
        </form>
    </div>
    <?php
}

// Hook the settings menu into the admin menu
add_action('admin_menu', 'openai_settings_menu');

// Create an admin page for content generation
function openai_content_generation_page() {
    ?>
    <div class="wrap">
        <h2>OpenAI Content Generation</h2>
        <form method="post" action="">
            <label for="keywords">Keywords:</label>
            <input type="text" id="keywords" name="keywords" size="60">
            <p>Enter keywords for content generation.</p>
            <input type="submit" name="generate_content" class="button-primary" value="Generate Content">
        </form>
    </div>
    <?php

    if (isset($_POST['generate_content'])) {
        $keywords = sanitize_text_field($_POST['keywords']);
        $content = generate_blog_content(explode(',', $keywords));

        var_dump($content);
        ?>
        <div class="wrap">
            <h2>Generated Content</h2>
            <div class="openai-blog-content"><?php echo $content; ?></div>
            <form method="post" action="">
                <input type="hidden" name="generated_content" value="<?php echo esc_textarea($content); ?>">
                <input type="submit" name="generate_post" class="button-primary" value="Generate Post">
            </form>
        </div>
        <?php
    }

    if (isset($_POST['generate_post'])) {
        $content = wp_kses_post($_POST['generated_content']);
        $post_data = array(
            'post_title' => 'Generated Post',
            'post_content' => $content,
            'post_status' => 'publish',
            'post_type' => 'post',
        );

        $post_id = wp_insert_post($post_data);

        if ($post_id) {
            echo '<div class="updated"><p>New post created!</p></div>';
        } else {
            echo '<div class="error"><p>Error creating post.</p></div>';
        }
    }
}

// Hook the content generation page into the admin menu
add_action('admin_menu', 'openai_content_generation_menu');

function openai_content_generation_menu() {
    add_menu_page('Content Generation', 'Content Generation', 'manage_options', 'openai-content-generation', 'openai_content_generation_page');
}
