(function( $ ){
    // new custom header and custom mobile menu
    $("#custom-header .menu-main-menu-container").prepend("<div class='close-menu-wrap'><div class='close-menu'>&times;</div></div>");
    $("#menu-main-menu li.menu-item-has-children").append("<div class='arrow'></div>");
    $("#menu-main-menu").on("click", ".arrow", function(){
        $(this).toggleClass("active");
        $(this).siblings(".sub-menu").slideToggle();
    })
    $("#custom-header .menu-bar, .close-menu-wrap .close-menu").on("click", function(){
        $("#custom-header .menu-main-menu-container").toggleClass("active");
        $("#custom-header .menu-bar").toggleClass("active");
    })

    // sanitize input data
    function sanitize(string) {
        const map = {
            '&': '&amp;',
            '<': '&lt;',
            '>': '&gt;',
            '"': '&quot;',
            "'": '&#x27;',
            "/": '&#x2F;',
            "`": '&grave;',
        };
        const reg = /[&<>"'/]/ig;
        return string.replace(reg, (match)=>(map[match]));
    }

    // seo manager dashboard download multiple files
    $(".multiple-file-download").on("click", function(e){
        e.preventDefault();
        var files = $(this).data("files");
        
        var link = document.createElement('a');

        link.style.display = 'none';

        document.body.appendChild(link);

        for (var i = 0; i < files.length; i++) {
            var filename = files[i].split('/').pop();
            link.setAttribute('download', filename);
            link.setAttribute('href', files[i]);
            link.click();
        }

        document.body.removeChild(link);
    })

    // frontpage banner
    // $("body").find(".frontpageBanner").append("<div class='frontpageBannerImage'></div>");
    // ==========================
    // ==========================

    // login page 
    // customer_login
    // $("#customer_login").prepend("<div class='login-page-logo'><a href='https://seoi.co.uk/'><img src='https://seoi.co.uk/wp-content/uploads/2020/07/796-seoi-logo-v4-140720-02.png' alt='SEOi' /></a></div>");

    // check if if logged in
    if ( $("body").hasClass("logged-in") && !$("body").hasClass("tve_editor_page") ) {
        // change all banner button text to "order now" when logged in
        $("body").find(".banner-btn .tcb-button-link .tcb-button-text").html("ORDER NOW");
        
        // top header hide seo-learning link when logged in and logged out
        // $("body").find("#thrive-header .button-logged-out").closest(".tcb-clear").remove();
    } else {
        // $("body").find("#thrive-header .button-logged-in").closest(".tcb-clear").remove();
    }

    // contact us landing page footer not now
    $("body").on("click", "#gform_6 .gform_footer p > a", function(e){
        e.preventDefault();

        $("body").find(".not-interested-btn-wrap a").trigger("click");
    });

    // ranktracker page modal button
    $("#rank-tracker-packages-order-scroll a").on("click", function(e){
        e.preventDefault();

        $('html, body').animate({
           scrollTop: $("#rank-tracker-packages").offset().top - $("#thrive-header").outerHeight() + 50
        }, 1000);
    });

    //  enable bootstrap tooltip
    $("body").tooltip({ selector: '[data-toggle=tooltip]' });

    // active campaign trigger for learning hub article complete
    $("#seo-learning-progress-button").on("click", function(e){
   		e.preventDefault();
   		var pageTitle  = $("#cstm-page-data").data("page-title");
        var pageId     = $("#cstm-page-data").data("page-id");
   		var pageUrl    = window.location.href;
   		var buttonLink = $(this).attr("href");
        var $this      = $(this);

        if ( !$this.hasClass("loading") && !$this.hasClass("done") ) {
       		// ajax
       		$.ajax({
       			type: "post",
       			url: wp_ajax.ajax_url,
       			data:{
       				action: "_activeCampaignEventTrigger",
       				pageTitle: pageTitle,
       				pageUrl: pageUrl,
                    pageId: pageId
       			},
       			beforeSend: function(){
                    $this.addClass("loading");
                },
       			success: function( response ){
       				// redirect to seo-manager
       				// window.location.href = buttonLink;
                    if ( response == "error" ) {
                        alert("There has been an error with the process. Please refresh the page and try again.");
                    } else {
                        $this.removeClass("loading").addClass("done");
                        $this.find(".text").html("You have completed this article");
                    }
       			}
       		})
        }
    });
    // ==========================
    // ==========================

    // seo manager report history download pdf button
    $("body").on("click", ".reportHistoryPDF", function(e){
        e.preventDefault();

        var projectId = $(this).data("project-id");
        var orderId   = $(this).data("order-id");
        var pageUrl   = window.location.href;
        var $this     = $(this);

        if ( !$this.hasClass("generating-pdf") ) {
            // ajax
            $.ajax({
                type: "POST",
                dataType: "json",
                url: wp_ajax.ajax_url,
                data:{
                    action: "_downloadReportHistory",
                    projectId: projectId,
                    orderId: orderId,
                    pageUrl: pageUrl
                },
                beforeSend: function(){
                    // 
                    $(".account-order-data-wrap").addClass("loading");
                    // $this.addClass("generating-pdf");

                    // $this.text("Please wait while we generate your report.");
                    // 
                    alert("Please wait while we generate your report.");
                },
                success: function( response ){
                    // console.log(response);
                    setTimeout(function(){
                        $.get( "https://seoi.io/api/file.txt", function( data ) {
                            // $( ".result" ).html( data );
                            var obj = JSON.parse(data);
                            // console.log(data);
                            // console.log(obj);
                            // console.log(obj.json);
                            // console.log(obj.json["pdf_url"]);
                            // console.log(obj.json.pdf_url);
                            // parsed = $.parseJSON(data);
                            // console.log($.parseJSON(obj.json).pdf_url);
                            // console.log("=========================");
                            // alert( "Load was performed." );

                            // insert the pdf url into the trigger href
                            $("#pdfDownloadTrigger").attr("href", $.parseJSON(obj.json).pdf_url);

                            // delay the trigger
                            setTimeout(function(){
                                $('#pdfDownloadTrigger')[0].click();
                            }, 500);

                            // 
                            $(".account-order-data-wrap").removeClass("loading");

                            // 
                            $this.closest("tr").find(".date").html(response.date);

                            // 
                            alert("Report has been successfully generated.");
                        });
                    }, 10000);
                    /*if ( response.pdf.length > 0 ) {
                        // $this.text("Report has been successfully generated.");

                        // insert the pdf url into the trigger href
                        $("#pdfDownloadTrigger").attr("href", response.pdf);

                        // delay the trigger
                        setTimeout(function(){
                            $('#pdfDownloadTrigger')[0].click();
                        }, 500);
                    } else {
                        $this.text("There has been an error generating your report. Please refresh the page to generate another.");
                    }*/
                },
            })
        }
    });

    // save pdf data
    /*function _savePDF( user_id, project_id ){
        $.ajax({
            type: "POST",
            dataType: "json",
            url: wp_ajax.ajax_url,
            data:{
                action: "_savePDF",
                user_id: user_id,
                project_id: project_id,
            },
            beforeSend: function(){},
            success: function( response ){
                console.log(response);
            },
        })
    }*/

    // add rank tracker package to cart -- found on seo-manager
    /*$("body").on("click", ".addRankTrackerPackage", function(e){
        e.preventDefault();
        var packageType = $(this).data("package-type");
        var productId   = $(this).data("product-id");
        var projectUrl  = $(this).closest(".rt-package").data("project-url");
        var projectId   = $(".reportHistoryPDF").data("project-id"); // webceo project id
        var userWebsite = $(this).closest("ul").find(".rankTrackerUserWebsite:selected").val(); // webceo project id

        alert(userWebsite);

        // ajax
        $.ajax({
            type: "post",
            url: wp_ajax.ajax_url,
            data:{
                action: "_addRankTrackerPackage",
                packageType: packageType,
                projectUrl: projectUrl,
                projectId: projectId,
                productId: productId
            },
            beforeSend: function(){},
            success: function( response ){
                window.location.href = "https://seoi.co.uk/checkout/";
            },
        })
    });*/
    // ==========================
    // ==========================

    // add order item data -- found on seo-manager of an account manager
    /*$("#addOrderItemData").on("click", function(e){
        e.preventDefault();

        var formContent = $('<div></div>');
        $('#orderItemDataForm').append(formContent);

        var orderData = $("#orderItemDataForm").serializeArray();

        console.log(orderData);
    })*/

    // account manager dashboard change order item status
    $("#order-item-status-select").change(function(){
        $(this).siblings(".save-order-item-status").addClass("active");
    })
    $(".dashboard-order-item-status").on("click", ".save-order-item-status", function(e){
        e.preventDefault();

        // variables
        var orderId = $(this).data("order-id");
        var orderItemStatus = $(this).siblings("#order-item-status-select").val();
        var orderItemStatusMetaKey = $(this).data("item-status-meta-key");

        // ajax
        $.ajax({
            type: "post",
            url: wp_ajax.ajax_url,
            data:{
                action: "_accountManagerUpdateOrderItemStatus",
                orderId: orderId,
                orderItemStatus: orderItemStatus,
                orderItemStatusMetaKey: orderItemStatusMetaKey,
            },
            beforeSend: function(){},
            success: function( response ){
                // reload the page once the you have successfully change the order status
                location.reload();
            },
        })
    })

    // customer order item dashboard edit request main form entry
    // customer order item dashboard open edit request modal
    $("body").on("click", ".dashboard-edit-request", function(e){

        // 
        e.preventDefault();

        // insert process title into form
        var processTitle = $(this).data("process-title");
        $("#input_2_7").val(processTitle);

        // insert entry id into form
        var mainEntryId = $(this).data("main-entry-id");
        $("#input_2_8").val(mainEntryId);

        // 
        if ( !$(this).hasClass("request-approved") ) {
            $("#dashboardEditRequestModal").modal("show");
        } else {
            alert("This process has already been approved.");
        }
    })

    // customer order item dashboard downloadMultipleFiles
    $("body").on("click", ".downloadMultipleFiles", function(e){
        e.preventDefault();
        if ( $(this).siblings('.multipleFilesDownload').length > 0 ) {
            $(this).siblings('.multipleFilesDownload').find("a").each(function(index){
                $(this)[0].click();
            });
        }
    })

    // customer order item dashboard approve a process
    $("body").on("click", ".customer-approve-process", function(e){
        e.preventDefault();

        // 
        if ( !$(this).hasClass("request-approved") ) {
            // 
            var orderItemId  = $(this).data('item-id');
            var processTitle = $(this).data('process-title');

            // populate process title
            $("#input_3_5").val(processTitle);

            // form submit
            $("#gform_3").submit();
        } else {
            alert("This process has already been approved.");
        }
    })

    // gravityforms once the form has been successfully submitted
    $(document).on("gform_confirmation_loaded", function (e, form_id) {
        // code to run upon successful form submission
        // if ( form_id == 1 || form_id == 2 || form_id == 3 || form_id == 18 || form_id == 19 ) {
        if ( form_id == 1 || form_id == 2 || form_id == 3 || form_id == 19 || form_id == 20 ) {
        // if ( form_id == 2 || form_id == 3 ) {
            // location.reload();
            window.location.href=window.location.href;
        }
        /* if ( form_id == 1 || form_id == 18 ) {
            setTimeout(function(){
                location.reload();
            }, 1000);
        } */
        // open-contact-register-modal
        /*if (form_id == 11) {
            $("#open-contact-register-modal > a").trigger("click");
        }*/
    });

    // new contact page form needs a fake button before the real registration form submits
    // /contact-us/
    $("body").on("click", ".fake-button", function(e){
        e.preventDefault();

        // 
        $("body").addClass("form-loading");

        if ($(this).hasClass("modal-opened")) {
            $("#gform_11").submit();
            $("body").removeClass("form-loading");
        } else {
            // alert();
            // var formData     = $("#gform_13").serializeObject();
            var formData     = $("#gform_11").serializeObject();
            // var input_fields = ["input_11.3", "input_11.6", "input_2", "input_22", "input_18", "input_20", "input_19"];
            var input_fields = ["input_8.3", "input_8.6", "input_2", "input_3", "input_4", "input_5", "input_6"];
            var validate     = [];
            // console.log(item);
            // if ( $.inArray( false, validate ) === -1 ) {
            // if (formData.length > 0) {
            // console.log("---------------");
            $.each(formData, function(index, item){
                // check if the input field is in the array
                // console.log(index + " - " + item);
                if ($.inArray( index, input_fields ) != -1) {
                    if (item.length > 0) { // not empty
                        // console.log(index + " - " + item);
                        // $("input[name='"+index+"']").closest(".gfield").removeClass("gfield_error");
                        // console.log(index + " - " + "not empty");
                    } else {
                        validate.push("empty");
                        // $("input[name='"+index+"']").css("background-color", "red");
                        // $("input[name='"+index+"']").closest(".gfield").addClass("gfield_error");
                        // console.log(index + " - " + "empty");
                    }
                }
            })

            // check if theres no empty field
            if (validate.length === 0) {
                console.log("no-empty");
                $("#open-contact-register-modal  a").trigger("click");
            } else {
                console.log("empty");
                $("#gform_11").submit();
            }
            // 
            setTimeout(function(){
                $("body").removeClass("form-loading");
            }, 1000)
        }
        // }
    })
    $(".contact-field input, .contact-field select, .contact-field textarea").on("change keyup",function(){
        var val = $(this).val();
        var input_name = $(this).attr("name");
        // console.log(val);
        if (input_name == "input_8.3") { // first name
            $("#gform_13 #input_13_11_3").val(val);
        } else if(input_name == "input_8.6"){ // last name
            $("#gform_13 #input_13_11_6").val(val);
        } else if(input_name == "input_2"){ // email
            $("#gform_13 #input_13_2").val(val);
        } else if(input_name == "input_3"){ // phone
            $("#gform_13 #input_13_22").val(val);
        } else if(input_name == "input_4"){ // website
            $("#gform_13 #input_13_20").val(val);
        } else if(input_name == "input_7"){ // comments
            $("#gform_13 #input_13_23").val(val);
        } else if(input_name == "input_6"){ // customer type
            $("#gform_13 input[value='"+val+"']"). attr('checked', true);
        } else if(input_name == "input_10"){ // interested in
            $("#gform_13 #input_13_19").val(val).trigger("change");
        }
    })
    $("body").on("click", ".contact-not-now", function(e){
        e.preventDefault();
        $("body").addClass("form-loading");
        $("#tve_thrive_lightbox_3597 .tve_p_lb_close").trigger("click");
        $("#gform_11").submit();
        $("body").find(".fake-button").addClass("modal-opened"); // add class to fake button so it wont open the modal anymore after
    })
    $(document).on("gform_confirmation_loaded", function (e, form_id) {
        $("body").removeClass("form-loading");
        // code to run upon successful form submission
        /*$("body").on("click", ".fake-button", function(e){
            e.preventDefault();
            var formData = $("#gform_11").serializeObject();
            console.log(formData);
        })*/
    });

    // product page additional option item
    $("#product-order-form").on("click", ".item-choices a", function(e){
        e.preventDefault();
        var type = $(this).closest("li").data("type");

        // 
        var pages = parseInt( $('.calculations .calculation-page-count strong').text() );
        var words = parseInt( $('.calculations .calculation-word-count strong').text() );

        // 
        if ( $(this).closest("li").hasClass("active") ) {
            $(this).closest("li").removeClass("active");
            $(this).closest(".left").find('.item-hidden').addClass("hidden");
            $(".calculation-word-count").addClass("hidden");

            var totalPrice = ( 50 * pages );

            // update button url
            var linkHref   = $('.calculations .calculation-button a').attr("href");
            var buttonLink = linkHref.replace(/&?words=([^&]$|[^&]*)/i, "");
            var buttonLink = buttonLink.replace(/&?technical=([^&]$|[^&]*)/i, "");
            $('.calculations .calculation-button a').attr("href", buttonLink);

            $('.calculations li.calculation-total strong').html("£"+totalPrice);
        } else {
            $(".item-choices li").removeClass("active");
            $(this).closest("li").addClass("active");
            
            // display wordcount on the right side
            if ( type != "technical" ) {
                $(".calculation-word-count").removeClass("hidden");
            } else {
                $(".calculation-word-count").addClass("hidden");
            }

            if ( type == "content-technical" ) {
                $(this).closest(".left").find('.item-hidden').removeClass("hidden");

                var totalPrice = ( ( ( ( 12 * words ) * pages ) / 100 ) + ( 50 * pages ) ) + 100;

                // update button url
                var linkHref = $('.calculations .calculation-button a').attr("href");
                var buttonLink = addParam( linkHref, 'words', words );
                var buttonLink = addParam( buttonLink, 'technical', true );
                $('.calculations .calculation-button a').attr("href", buttonLink);
            } else if ( type == "content" ) {
                $(this).closest(".left").find('.item-hidden').addClass("hidden");
                $(this).closest(".left").find('.item-hidden[data-type="'+type+'"]').removeClass("hidden");

                var totalPrice = ( ( ( 12 * words ) * pages ) / 100 ) + ( 50 * pages );

                // update button url
                var linkHref   = $('.calculations .calculation-button a').attr("href");
                var buttonLink = addParam( linkHref, 'words', words );
                $('.calculations .calculation-button a').attr("href", buttonLink);

                // remove button url parameter
                var linkHref   = $('.calculations .calculation-button a').attr("href");
                var buttonLink = linkHref.replace(/&?technical=([^&]$|[^&]*)/i, "");
                $('.calculations .calculation-button a').attr("href", buttonLink);
            } else if ( type == "technical" ) {
                $(this).closest(".left").find('.item-hidden').addClass("hidden");
                $(this).closest(".left").find('.item-hidden[data-type="'+type+'"]').removeClass("hidden");

                var totalPrice = ( 50 * pages ) + 100;

                // update button url
                var linkHref   = $('.calculations .calculation-button a').attr("href");
                var buttonLink = addParam( linkHref, 'technical', true );
                $('.calculations .calculation-button a').attr("href", buttonLink);

                // remove button url parameter
                var linkHref   = $('.calculations .calculation-button a').attr("href");
                var buttonLink = linkHref.replace(/&?words=([^&]$|[^&]*)/i, "");
                $('.calculations .calculation-button a').attr("href", buttonLink);
            } else {
                $(this).closest(".left").find('.item-hidden').addClass("hidden");
                $(this).closest(".left").find('.item-hidden[data-type="'+type+'"]').removeClass("hidden");

                var totalPrice = ( 50 * pages );

                // update button url
                var linkHref   = $('.calculations .calculation-button a').attr("href");
                var buttonLink = linkHref.replace(/&?words=([^&]$|[^&]*)/i, "");
                var buttonLink = buttonLink.replace(/&?technical=([^&]$|[^&]*)/i, "");
                $('.calculations .calculation-button a').attr("href", buttonLink);
            }

            /*
            //  location.href=location.href.replace(/&?e=([^&]$|[^&]*)/i, "");
            if ( type == 'page-count' ) {
                buttonLink = addParam( buttonLink, 'pages', sliderValue );
            }
            if ( type == 'post-count' ) {
                buttonLink = addParam( buttonLink, 'posts', sliderValue );
            }
            if ( type == 'word-count' ) {
                buttonLink = addParam( buttonLink, 'words', sliderValue );
            }
            if ( type == 'budget' ) {
                buttonLink = addParam( buttonLink, 'budget', sliderValue );
            }

            // 
            $('.calculations .calculation-button a').attr("href", buttonLink);
            */

            // console.log(totalPrice);
            $('.calculations li.calculation-total strong').html("£"+totalPrice);
        }

    })

    // product page slider
    var sliders = document.getElementsByClassName('cstm-range');
    $(".cstm-range").each( function( index, el ) {
        var $this       = $(this);
        var formId      = $("#product-order-form").data("form-id"); // product id
        var formTitle   = $("#product-order-form").data("form-title"); // product title
        var type        = $(this).data("type");
        var sliderMax   = $(this).data("max") ? $(this).data("max") : 2000;
        var sliderMin   = $(this).data("min") ? $(this).data("min") : 1;
        var sliderStep  = $(this).data("step") ? $(this).data("step") : 1;
        var sliderPips  = $(this).data("pips") ? $(this).data("pips") : 3;
        var sliderStart = $(this).data("start") ? $(this).data("start") : 1;

        noUiSlider.create( sliders[index], {
            start: sliderStart,
            step: sliderStep,
            range: {
                'min': sliderMin,
                'max': sliderMax
            },
            pips: {
                mode: 'count',
                values: sliderPips
            }
        } );

        sliders[index].noUiSlider.on( 'slide', function(){

            // get slider value
            var sliderValue = parseInt( sliders[index].noUiSlider.get() );

            // insert slider value depending on the type
            $('.calculations li[data-type="'+type+'"] strong').html(sliderValue);

            // order link
            var buttonLink = $('.calculations .calculation-button a').attr("href");


            // if ( formTitle == "Content Writing Services" || formTitle == "Blog Writing Service" ) {
            if ( formId == 2129 || formId == 2134 ) {
                // vars
                var pages = parseInt( $('.calculations .calculation-page-count strong').text() );
                var words = parseInt( $('.calculations .calculation-word-count strong').text() );

                // calculate total price
                // 12p per word
                var totalPrice = ( ( 12 * words ) * pages ) / 100;

                $('.calculations li.calculation-total strong').html("£"+totalPrice);
            // } else if ( formTitle == "On-Page SEO Service" ) {
            } else if ( formId == 2117 ) {
                // vars
                var pages = parseInt( $('.calculations .calculation-page-count strong').text() );
                var words = parseInt( $('.calculations .calculation-word-count strong').text() );

                // console.log(pages);
                // console.log(words);

                // choices
                var choiceType = $("#product-order-form .item-choices li.active").data("type");
                // alert(test);
                // console.log(type);
                if ( choiceType == "content" ) {
                    var totalPrice = ( ( ( 12 * words ) * pages ) / 100 ) + ( 50 * pages );
                } else if ( choiceType == "technical" ) {
                    var totalPrice = ( 50 * pages ) + 100;
                } else if ( choiceType == "content-technical" ) {
                    var totalPrice = ( ( ( ( 12 * words ) * pages ) / 100 ) + ( 50 * pages ) ) + 100;
                } else {
                    // 50 per page
                    var totalPrice = ( 50 * pages );
                }

                // calculate total price
                
                // console.log(totalPrice);
                $('.calculations li.calculation-total strong').html("£"+totalPrice);
            // } else if ( formTitle == "Blog Management" ) {
            } else if ( formId == 2123 ) {
                // vars
                var posts = parseInt( $('.calculations .calculation-post-count strong').text() );
                var words = parseInt( $('.calculations .calculation-word-count strong').text() );

                // calculate total price
                // 10p per word
                var totalPrice = ( ( 10 * words ) * posts ) / 100;

                $('.calculations li.calculation-total strong').html("£"+totalPrice);
            // } else if ( formTitle == "Managed SEO" || formTitle == "SEO Management Service" || formTitle == "Local SEO Services" || formTitle == "National SEO Service" || formTitle == "International SEO Service" || formTitle == "eCommerce SEO Services" ) {
            } else if ( formId == 2027 || formId == 2081 || formId == 2055 || formId == 2066 || formId == 2076 ) {
              // 2081 - ecommerce seo services
              // 2055 - local seo services
              // 2066 - national seo services
              // 2076 - international seo services
                $('.calculations li.calculation-total strong').html("£"+sliderValue);
            }

            // 
            if ( type == 'page-count' ) {
                buttonLink = addParam( buttonLink, 'pages', sliderValue );
            }
            if ( type == 'post-count' ) {
                buttonLink = addParam( buttonLink, 'posts', sliderValue );
            }
            if ( type == 'word-count' ) {
                buttonLink = addParam( buttonLink, 'words', sliderValue );
            }
            if ( type == 'budget' ) {
                buttonLink = addParam( buttonLink, 'budget', sliderValue );
            }

            // 
            $('.calculations .calculation-button a').attr("href", buttonLink);
        } );
    });
    function addParam( currentUrl,key,val ) {
        var url = new URL(currentUrl);
        url.searchParams.set(key, val);
        return url.href; 
    }
    // ==========================
    // ==========================

    // 
    (function($,undefined){
      '$:nomunge'; // Used by YUI compressor.

        $.fn.serializeObject = function(){
            var obj = {};

            $.each( this.serializeArray(), function(i,o){
              var n = o.name,
                v = o.value;

                obj[n] = obj[n] === undefined ? v
                  : $.isArray( obj[n] ) ? obj[n].concat( v )
                  : [ obj[n], v ];
            });

            return obj;
        };

    })(jQuery);

    // cart order form
    $("#seoi-order-form").submit(function(e){
        e.preventDefault();

        var orderId   = $('#seoi-order-form input[name="_productId"]').val();
        var orderName = $('#seoi-order-form input[name="_productName"]').val();
        var formData  = $("#seoi-order-form").serializeObject();

        // 
        var fileFormData = new FormData();
        if ( $(this).find("input[type=file]").length > 0 ) {
            var fileData = $(this).find("input[type=file]").prop('files')[0];
            fileFormData.append('file', fileData);
        }
        fileFormData.append('action', '_addServiceToCart');
        fileFormData.append('formOriginalData', JSON.stringify(formData));

        // add loading class to form
        $(this).addClass("loading");

        // check if theres an empty required field
        var validate = [];
        $('[required]').each(function(i, field) {
            validate[i] = !$(this).val() ? false : true;
        })

        // check for https:// or http://
        var website = $('#seoi-order-form input[name="Website URL"]').val() ? $('#seoi-order-form input[name="Website URL"]').val() : "";
        if ( website.match(/^.+:\/\/.*/) ) {
            alert("Please remove the https:// or http:// on the website field.");
            $(this).removeClass("loading");
        } else {
            // if theres no empty required field proceed with the ajax
            if ( $.inArray( false, validate ) === -1 ) {
                $.ajax({
                    url: wp_ajax.ajax_url,
                    type: "post",
                    // cache: false,
                    contentType: false,
                    processData: false,
                    data: fileFormData,
                    /*data:{
                        action: "_addServiceToCart",
                        formData: formData,
                        // form_data: form_data
                        // newFileData: newFileData
                    },*/
                    // beforeSend: function(){},
                    success: function( response ){
                        // console.log(response);
                        window.location.href = 'https://seoi.io/checkout';
                    }
                })
            } else {
                // remove loading class
                $(this).removeClass("loading");
            }
        }
    } )

    $("#seoi-order-form input[type=text]").on("keyup", function(){
        // remove disabled on button
        $("#seoi-order-form button").removeAttr("disabled");
    })


    // cart order form select
    // cart oder form radio fields
    $("#seoi-order-form input[type=radio], #seoi-order-form select").on("change", function(){
        var orderId   = $('#seoi-order-form input[name="_productId"]').val();
        var orderName = $('#seoi-order-form input[name="_productName"]').val();
        var radioName = $(this).attr("name");
        var checked   = $('input[name="'+radioName+'"]:checked').val();

        // remove disabled on button
        $("#seoi-order-form button").removeAttr("disabled");


        // rank tracker business
        if ( orderId == 2203 ) {
            var packageType = $(this).val();
            var keywords    = "";

            if ( packageType == "Basic" ) {
                keywords = 50;
            } else if ( packageType == "Business" ) {
                keywords = 100;
            } else {
                keywords = 300;
            }

            $(".package-keywords").html("Keywords (Add up to "+keywords+")");
            $("#add-new-keyword").data("max-keyword", keywords).attr("data-max-keyword", keywords);
        }

        // if ( orderName == "On-Page SEO Service" ) {
        if ( orderId == 2117 ) {
            if ( radioName == "Do you offer your products/services Locally?" ) {

                var content = `<fieldset class="services-locally-areas">
                                    <label for="What areas?">What areas?</label>
                                    <input type="text" name="What areas?" value="" required>
                               <fieldset>`;

                if ( checked == 'Yes' ) {
                    // insert content
                    $( content ).insertAfter( $(this).closest('fieldset') );
                } else {
                    // delete content
                    if ( $(this).closest('fieldset').next().hasClass("services-locally-areas") ) {
                        $(this).closest('fieldset').next().remove();
                    }
                }
            } else if ( radioName == "Do you offer your services Internationally?" ) {

                var content = `<fieldset class="services-international-countries">
                                    <label for="What areas?">What countries?</label>
                                    <input type="text" name="What countries?" value="" required>
                               <fieldset>`;

                if ( checked == 'Yes' ) {
                    // insert content
                    $( content ).insertAfter( $(this).closest('fieldset') );
                } else {
                    // delete content
                    if ( $(this).closest('fieldset').next().hasClass("services-international-countries") ) {
                        $(this).closest('fieldset').next().remove();
                    }
                }
            }
        }
    })

    // cart order form checkbox
    $("#seoi-order-form input[type=checkbox]").on("change", function(){
        var productPrice = parseFloat( $('#seoi-order-form input[name="_productPrice"]').val() );
        var orderId      = $('#seoi-order-form input[name="_productId"]').val();
        var orderName    = $('#seoi-order-form input[name="_productName"]').val();
        var checkboxName = $(this).attr("name");
        var checked      = $(this).prop("checked");

        // remove disabled on button
        $("#seoi-order-form button").removeAttr("disabled");

        // onpage seo
        if ( orderId == 2117 ) {
            var content = `<fieldset class="word-count">
                                <label for="Word Count">How many words per page?</label>
                                <input type="number" name="Word Count" value="500" required min="500">
                           <fieldset>`;

            if ( checked ) {
                // insert content
                $( content ).insertAfter( $(this).closest('fieldset').siblings(".include-technical") );
            } else {
                // delete content
                $(this).closest('fieldset').siblings(".word-count").remove();
            }
        }

        // For page optimisation re-write content
        if ( orderName == "Page Optimisation" && checkboxName == "Rewrite Content" ) {
            if ( checked ) {
                // show word count field
                $('#seoi-order-form input[name="Word Count"]').closest("fieldset").removeClass("hidden");

                // change product price
                // re-write content adds an additional $60
                var newPrice = productPrice + 60;
                $('#seoi-order-form input[name="_productPrice"]').val(newPrice);
            } else {
                // hide word count field
                $('#seoi-order-form input[name="Word Count"]').closest("fieldset").addClass("hidden");

                // change product price
                // re-write content remove the additional $60 once the checkbox is unchecked
                var newPrice = productPrice - 60;
                $('#seoi-order-form input[name="_productPrice"]').val(newPrice);
            }
        }
    })

    // cart order form file input validation
    $("#seoi-order-form input[type=file]").change(function () {
        var fileExtension = ['jpeg', 'jpg', 'png', 'pdf', 'docx', 'doc'];
        if ($.inArray($(this).val().split('.').pop().toLowerCase(), fileExtension) == -1) {
            $("#seoi-order-form input[type=file]").val('');
            alert("The file format you've uploaded is not valid.");
        }
    });

    // cart order form input number
    var timer = '';
    // $("body").on("change", "#seoi-order-form input[type=number]", function(e){
    $("body").on("change keyup", "#seoi-order-form input[type=number]", function(e){
        var productPrice   = parseFloat( $('#seoi-order-form input[name="_productPrice"]').val() );
        var orderId        = $('#seoi-order-form input[name="_productId"]').val();
        var orderName      = $('#seoi-order-form input[name="_productName"]').val();
        var inputName      = $(this).attr("name");
        var inputLabel     = $(this).siblings("label").text();
        var inputValue     = $(this).val();
        var inputPrevValue = $(this).data("prev-value");
        var newPrice       = 0;

        // clear timer if user is not yet done typing or changing values
        clearTimeout(timer);

        // remove disabled on button
        $("#seoi-order-form button").removeAttr("disabled");

        // 
        timer = setTimeout(function(){
            // for Guest Post Backlinks DA+ Content
            // if ( orderName == "Guest Post Service" || orderName == "Blogger Outreach Service" ) {
            if ( orderId == 2105 || orderId == 2090 ) {

                // check if all of the DA+ items are empty
                var valda10 = $('#seoi-order-form input[name="DA10+"]').val();
                var valda20 = $('#seoi-order-form input[name="DA20+"]').val();
                var valda30 = $('#seoi-order-form input[name="DA30+"]').val();
                var valda40 = $('#seoi-order-form input[name="DA40+"]').val();
                var valda50 = $('#seoi-order-form input[name="DA50+"]').val();

                if ( valda10 == 0 && valda20 == 0 && valda30 == 0 && valda40 == 0 && valda50 == 0 ) {
                    // daValidate = false;
                    $("#seoi-order-form button").attr("disabled", true);
                    // alert();
                }

                // check if inputValue is > 1 and hide if 0
                if ( inputValue == 0 ) {
                    $('.da-item[data-da-type="'+inputName+'"]').addClass("hidden");
                } else {
                    $('.da-item[data-da-type="'+inputName+'"]').removeClass("hidden");
                }


                /*
                    calculate price
                    da10+ - 100
                    da20+ - 150
                    da30+ - 195
                    da40+ - 395
                    da50+ - 495
                */
                var da10 = 100 * valda10;
                var da20 = 150 * valda20;
                var da30 = 195 * valda30;
                var da40 = 395 * valda40;
                var da50 = 495 * valda50;

                // calculate new price
                newPrice = da10 + da20 + da30 + da40 + da50;

                // check if the value went up or down
                // if ( inputValue > inputPrevValue ) { 

                    for (i = 1; i <= inputValue; i++) {
                        // console.log(i);

                        // input up
                        if ( $('.da-item[data-da-type="'+inputName+'"] .da-item-row[data-row-count="'+i+'"]').length <= 0 ) {
                            // fields that needs to be inserted into the form
                            var content = `<div class="da-item-row" data-row-count="`+i+`">
                            <fieldset>
                                <label for="`+inputName+` Project `+i+` - Word Count">`+inputName+` Project `+i+` - Word Count</label>
                                <input type="number" name="`+inputName+` Project `+i+` - Word Count" value="500" min="0" required>
                            </fieldset>
                            <fieldset>
                                <label for="`+inputName+` Project `+i+` - Anchor Text">`+inputName+` Project `+i+` - Anchor Text</label>
                                <input type="text" name="`+inputName+` Project `+i+` - Anchor Text" value="" required>
                            </fieldset>
                            <fieldset>
                                <label for="`+inputName+` Project `+i+` - Target URL">`+inputName+` Project `+i+` - Target URL</label>
                                <input type="text" name="`+inputName+` Project `+i+` - Target URL" value="" required>
                            </fieldset>
                            </div>`;

                            // append the content
                            $('.da-item[data-da-type="'+inputName+'"]').append( content );
                        }
                    } // end for loop
                /*} else if ( inputValue < inputPrevValue ) {
                    // input down
                    $('.da-item[data-da-type="'+inputName+'"] .da-item-row[data-row-count="'+inputPrevValue+'"]').remove();
                    // $('.da-item[data-da-type="'+inputName+'"] .da-item-row').last().remove();
                }*/

                // get all row count
                var rowCount = $('.da-item[data-da-type="'+inputName+'"] .da-item-row').length;

                // remove excess rows
                if ( inputValue < rowCount ) {
                    for (y = rowCount; y > inputValue; y--) {
                        $('.da-item[data-da-type="'+inputName+'"] .da-item-row[data-row-count="'+y+'"]').remove();
                    }
                }
                // console.log(inputName);
                // console.log(inputValue);
                // console.log(inputPrevValue);
                // console.log("================");

                /*
                    calculate new price with words
                    12p per word
                */
                // var price = parseFloat( $('#seoi-order-form input[name="_productPrice"]').attr("value") );
                var priceArray = [];
                $('.da-item').each(function(i, el){
                    if ( !$(this).hasClass("hidden") ) {
                        $(this).find(".da-item-row").each(function(){
                            var itemWordCount = $(this).find('input[type="number"]').val();
                            if ( itemWordCount > 500 ) {
                                itemWordCount = itemWordCount - 500;
                                // newPrice = parseFloat( newPrice + ( ( 12 * itemWordCount ) / 100 ) ).toFixed(2);
                                priceArray.push( ( 12 * itemWordCount ) / 100 );
                            }
                        })
                    }
                });

                // calculate
                newPrice = newPrice + getArraySum(priceArray);

                // last step is to update prev data value
                // $(this).data("prev-value", inputValue).attr("data-prev-value", inputValue);
            // } else if ( orderName == "Blog Management" ) {
            } else if ( orderId == 2123 ) {
                var wordCount = parseFloat( $('#seoi-order-form input[name="Word Count"]').val() );
                var blogPosts = parseFloat( $('#seoi-order-form input[name="Blog Posts"]').val() );

                // calculate new price
                newPrice = blogPosts * wordCount;
            } else if ( orderName == "Managed SEO Services" ) {
                
                var budget = parseFloat( $('#seoi-order-form input[name="Budget"]').val() );

                // calculate new price
                newPrice = budget;
            }

            // update price field
            $('#seoi-order-form input[name="_productPrice"]').val(newPrice).attr("value", newPrice);
        }, 1000); // timer
    })

    // da item input number
    // $("body").on("change", ".da-item input[type=number]", function(e){
        // var price = parseFloat( $('#seoi-order-form input[name="_productPrice"]').attr("value") );

        /*$('.da-item').each(function(i, el){
            if ( !$(this).hasClass("hidden") ) {
                $(this).find(".da-item-row").each(function(){
                    var itemWordCount = $(this).find('input[type="number"]').val();
                    if ( itemWordCount > 500 ) {
                        itemWordCount = itemWordCount - 500;
                        price = parseFloat( price + ( ( 12 * itemWordCount ) / 100 ) ).toFixed(2);
                    }
                })
            }
        });*/
        // console.log(price);
        /*alert(price);

        var itemWordCount = $(this).val();
        if ( itemWordCount > 500 ) {
            itemWordCount = itemWordCount - 500;
            price = parseFloat( price + ( ( 12 * itemWordCount ) / 100 ) ).toFixed(2);
            // itemPriceArr.push( ( 12 * itemPrice ) / 100 );
        }
*/
        // update price field
        // $('#seoi-order-form input[name="_productPrice"]').val(price).attr("value", price);
    // })

    // add new keyword
    $("body").on("click", "#add-new-keyword", function(e){
        e.preventDefault();

        var maxKeyword = $(this).data("max-keyword");

        var currentCount = $(this).closest("fieldset").find("input").length;

        if ( currentCount != maxKeyword && currentCount < maxKeyword ) {
            // generate the new website url input field
            var content = `<div class="added-keyword"><input type="text" name="Keywords" value="" required><div class="remove-added-keyword">&times;</div></div>`;

            // insert the content
            $( content ).insertBefore( $(this) );
        } else {
            alert("You have reached the keyword limit.");
        }
    });
    // remove the added keyword
    $("body").on("click", ".remove-added-keyword", function(e){
        // remove the added website field
        $(this).closest(".added-keyword").remove();
    });
    // add new website fieldset if the customer has already existing website urls
    $("body").on("click", "#add-new-website-url", function(e){
        e.preventDefault();

        // add class added to hide
        $(this).addClass("added");

        // add disabled attribute to the sibling select field
        // also remove name attribute so it wont be included in the formData
        $(this).siblings("select").removeAttr("required").attr("disabled", true).attr("name", "");

        // generate the new website url input field
        var content = `<div class="added-website-url"><input type="text" name="Website URL" value="" placeholder="Website URL" required><div class="remove-added-website-url">&times;</div></div>`;

        // insert the content
        $( content ).insertAfter( $(this) );
    });
    // remove the new added website fieldset
    $("body").on("click", ".remove-added-website-url", function(e){

        // remove added class so it can be visible again
        $("#add-new-website-url").removeClass("added");

        // remove disabled attr for the select field
        // also add back the name attribute "Website URL"
        $(this).closest("fieldset").find("select").removeAttr("disabled").attr("required", true).attr("name", "Website URL");

        // remove the added website field
        $(this).closest(".added-website-url").remove();
    });

    // 
    $("body").on("click", "#add-new-website-url-w-keywords", function(e){
        e.preventDefault();

        var numItems = $('.website-item').length + 1;

        // generate the new website url input field
        var content = `<div class="website-item">
                            <input type="text" name="Website URL `+numItems+`" value="" placeholder="Website URL" required>
                            <input type="text" name="Website URL `+numItems+` Keywords" value="" placeholder="Keywords" required>
                            <div class="remove-added-website-url-w-keywords">&times;</div>
                        </div>`;

        // insert the content
        $( content ).insertBefore( $(this) );
    });
    $("body").on("click", ".remove-added-website-url-w-keywords", function(e){
        // remove website item
        $(this).closest(".website-item").remove();
    });

    function getArraySum(a){
        var total=0;
        for(var i in a) { 
            total += a[i];
        }
        return total;
    }

    // dashboard filter orders by date
    $("body").on("change", "#dashboard-filter-date, #dashboard-filter-website", function(){
        var date    = $("#dashboard-filter-date").val();
        var website = $("#dashboard-filter-website").val();
        
        $.ajax({
            type: "post",
            url: wp_ajax.ajax_url,
            data:{
                action: "dashboardFilterCustomerOrders",
                date: date,
                website: website,
            },
            beforeSend: function(){
                $(".account-order-data-wrap").addClass("loading");
            },
            success: function( response ){
                // console.log(response);
                $(".dashboard-table tbody").html(response);
                $(".account-order-data-wrap").removeClass("loading");
            },
        })
    });

    // free seo strategy
    $("#create-strategy-form").submit(function(e){
        e.preventDefault();
        var formData  = $("#create-strategy-form").serializeObject();

        // check if theres an empty required field
        var validate = [];
        $('[required]').each(function(i, field) {
            validate[i] = !$(this).val() ? false : true;
        })

        // if theres no empty required field proceed with the ajax
        if ( $.inArray( false, validate ) === -1 ) {
            $(this).addClass("loading");
            $.ajax({
                type: "post",
                url: wp_ajax.ajax_url,
                data:{
                    action: "_createStrategy",
                    formData: formData
                },
                beforeSend: function(){},
                success: function( response ){
                    // window.location.href = 'https://seoi.co.uk/checkout';
                    // console.log(response);
                    alert("Data has been saved!");
                    $("#create-strategy-form").removeClass("loading");
                }
            })
        } else {
            alert("Please input data on all required fields.");
        }
    })

    // 
    $("body").on("click", ".remove-strategy", function(e){
        e.preventDefault();

        var empty = true;

        $("#create-strategy-form").addClass("loading");

        $.ajax({
            type: "POST",
            // dataType: "json",
            url: wp_ajax.ajax_url,
            data:{
                action: "_createStrategy",
                empty: empty
            },
            beforeSend: function(){},
            success: function( response ){
                $("#create-strategy-form").removeClass("loading");
                alert("Data has been saved!");
                setTimeout(function(){
                    location.reload();
                }, 1000)
            }
        })
    })

   /* $("body").on("click", "#create-strategy", function(e){
        e.preventDefault();
        $(this).remove();
        $(".create-strategy-wrap").removeClass("hidden");
    })*/
    // add cs tab header and content
    $("body").on("click", "#add-cs-page", function(e){
        e.preventDefault();

        // 
        var pageName = $(this).siblings("input").val();
        var tabName  = pageName.toLowerCase().replace(" ", "_");
        // alert(pageName.toLowerCase().replace(" ", "_"));
        $(this).siblings("input").val(""); // reset after click

        // content tab count
        // var contentTabCount = $(".cs-content-tabs .cs-content-tab").length;
        var contentTabCount = $("body").find(".cs-content-tabs .cs-content-tab").length;
        // var newCount = contentTabCount > 0 ? contentTabCount : 1 ;
        var newCount = contentTabCount + 1;

        // alert( newCount );
        // console.log( newCount );

        // hidden class
        var hiddenClass = "";
        if ( newCount > 1 ) {
            hiddenClass = "hidden";
        }

        if ( pageName == "" ) {
            alert("Page Name is required.");
        } else {
            // 
            $("#create-strategy-form  .remove-strategy").removeClass("hidden");

            // page count
            $('#create-strategy-form input[name="Page Count"]').val(newCount);

            // enable submit button
            $("#create-strategy-form button[type=submit]").attr("disabled", false);

            // 
            $("#create-strategy-form").removeClass("hidden");

            // append page name
            var tabHeaderCount = $("#create-strategy-form .cs-header-tabs li").length;
            var tabHeaderClass = tabHeaderCount == 0 ? "active" : "";
            $("#create-strategy-form .cs-header-tabs").append('<li class="'+tabHeaderClass+'" data-tab="'+tabName+'"><a href="">'+pageName+'</a></li>');

            var removeClass = (newCount == 1) ? "hidden" : "";

            // append blank form fields
            var pageContent =   `<div class="cs-content-tab `+hiddenClass+`" data-tab-count="`+newCount+`" data-tab="`+tabName+`">
                                    <input type="hidden" name="Page `+newCount+` Page Name" value="`+pageName+`">
                                    <input type="hidden" name="Page `+newCount+` Keyword Count" value="0">
                                    <div class="remove-page-wrap `+removeClass+`">
                                        <a href="" class="remove-page"><div>&times;</div> Remove Page</a>
                                    </div>
                                    <div class="item">
                                        <label for="Page `+newCount+` Website URL">Website URL</label>
                                        <input type="text" name="Page `+newCount+` Website URL" value="" placeholder="Website URL" required>
                                    </div>
                                    <div class="item keywords">
                                        <a href="" class="remove-cs-keywords hidden">&times; remove</a>
                                        <a href="" class="small-btn add-cs-keywords">+ Add Keyword</a>
                                    </div>
                                    <div class="item select-item-products">
                                        <h4>Select Included Products</h4>
                                        <div class="item-child">
                                            <input type="checkbox" id="Page `+newCount+` On-page and Technical SEO"  name="Page `+newCount+` On-page and Technical SEO" value="on-page-technical" placeholder="On-page and Technical SEO">
                                            <label for="Page `+newCount+` On-page and Technical SEO">On-page and Technical SEO</label>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="Page `+newCount+` Content Writing" name="Page `+newCount+` Content Writing" value="content-writing" placeholder="Content Writing">
                                            <label for="Page `+newCount+` Content Writing">Content Writing</label>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="Page `+newCount+` Local SEO Citation" name="Page `+newCount+` Local SEO Citation" value="local-seo-citation" placeholder="Local SEO Citation">
                                            <label for="Page `+newCount+` Local SEO Citation">Local SEO Citation</label>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="Page `+newCount+` Backlinks" name="Page `+newCount+` Backlinks" value="backlinks" placeholder="Backlinks">
                                            <label for="Page `+newCount+` Backlinks">Backlinks</label>
                                        </div>
                                        <div class="item-child">
                                            <input type="checkbox" id="Page `+newCount+` Content Marketing" name="Page `+newCount+` Content Marketing" value="content-marketing" placeholder="Content Marketing">
                                            <label for="Page `+newCount+` Content Marketing">Content Marketing</label>
                                        </div>
                                    </div>
                                    <div class="item item-products"></div>
                                    <div class="item item-comments">
                                        <label for="Page `+newCount+` Comments">Comments</label>
                                        <textarea name="Page `+newCount+` Comments" id="Page `+newCount+` Comments"></textarea>
                                    </div>
                                </div>`;

            // append content
            $("#create-strategy-form .cs-content-tabs").append(pageContent);
        }
    })
    $("body").on("click", ".cs-header-tabs > li > a", function(e){
        e.preventDefault();

        var tabName = $(this).closest("li").data("tab");
        $(".cs-header-tabs li").removeClass("active");
        $(this).closest("li").addClass("active");
        $(".cs-content-tab").addClass("hidden");
        $(".cs-content-tab[data-tab='"+tabName+"']").removeClass("hidden");
        // alert(tabName);
    })
    // add a keyword
    $("body").on("click", ".add-cs-keywords", function(e){
        e.preventDefault();

        var tabCount = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName = $(this).closest(".cs-content-tab").data("tab");
        var keywordCount = $(this).closest(".keywords").find(".keyword").length;
        var newCount = keywordCount + 1;

        var keywordContent =    `<div class="item-child keyword" data-keyword-number="`+newCount+`">
                                    <fieldset>
                                        <label for="Page `+tabCount+` Keyword `+newCount+`">Keyword `+newCount+`</label>
                                        <input type="text" name="Page `+tabCount+` Keyword `+newCount+`" value="" placeholder="Keyword `+newCount+`" required>
                                    </fieldset>
                                    <fieldset>
                                        <label for="Page `+tabCount+` Keyword `+newCount+` MS">MS <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Monthly Searches">?</a></label>
                                        <input type="text" name="Page `+tabCount+` Keyword `+newCount+` MS" value="" placeholder="" required>
                                    </fieldset>
                                    <fieldset>
                                        <label for="Page `+tabCount+` Keyword `+newCount+` CPC">CPC <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Cost per Click">?</a></label>
                                        <input type="text" name="Page `+tabCount+` Keyword `+newCount+` CPC" value="" placeholder="" required>
                                    </fieldset>
                                    <fieldset>
                                        <label for="Page `+tabCount+` Keyword `+newCount+` EP1T">EP1T <a href="#0" data-toggle="tooltip" class="keyword-tooltip" title="Estimated Position 1 Traffic">?</a></label>
                                        <input type="text" name="Page `+tabCount+` Keyword `+newCount+` EP1T" value="" placeholder="" required>
                                    </fieldset>
                                    <div class="keyword-competitors">
                                        <a href="" class="remove-cs-competitors hidden">&times; remove</a>
                                        <a href="" class="small-btn add-cs-competitors">+ Add Competitor</a>
                                    </div>
                                </div>`;

        // insert the content
        $( keywordContent ).insertBefore( $(this) );

        //
        $(this).siblings(".remove-cs-keywords").removeClass("hidden");

        // update how many keywords
        $(this).closest(".cs-content-tab").find('input[name="Page '+tabCount+' Keyword Count"]').val(newCount);

        // 
        var itemChildTechnical     = [];
        var itemChildContentLength = [];
        var itemChildBacklinks     = [];

        $(this).closest(".cs-content-tab").find(".item.item-products .item-child").each(function(){
            if ( $(this).hasClass("item-child-technical") ) {
                itemChildTechnical.push(1);
            }
            if ( $(this).hasClass("item-child-content-writing") ) {
                itemChildContentLength.push(1);
            }
            if ( $(this).hasClass("item-child-backlinks") ) {
                itemChildBacklinks.push(1);
            }
        })

        var technicalSum     = itemChildTechnical.reduce(function(a, b) { return a + b; }, 0) + 1;
        var contentLengthSum = itemChildContentLength.reduce(function(a, b) { return a + b; }, 0) + 1;
        var backlinksSum     = itemChildBacklinks.reduce(function(a, b) { return a + b; }, 0) + 1;
        
        if ( technicalSum > 0 ) {
            var technicalContent =  `<div class="item-child item-child-technical" data-count="`+technicalSum+`">
                                        <fieldset>
                                            <label for="Page `+tabCount+` On-page and Technical Keyword `+technicalSum+`">Your On-Page And Technical Score</label>
                                            <input type="number" name="Page `+tabCount+` On-page and Technical Keyword `+technicalSum+`" value="" required>
                                        </fieldset>
                                        <a href="" class="remove-btn remove-technical-competitors hidden">&times; remove</a>
                                        <br><a href="" class="small-btn add-technical-competitors hidden" style="display: none;">+ Add Competitor</a>
                                    </div>`;

            // Page 1 On-page and Technical SEO
            var objChecked = $('.select-item-products input[name="Page '+tabCount+' On-page and Technical SEO"]').is(":checked");
            if ( objChecked ) {
                // check if item-child-technical exists
                if ( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-technical").length <= 0 ) {
                    $(this).closest(".cs-content-tab").find(".item.item-products").append(technicalContent);
                } else {
                    $( technicalContent ).insertAfter( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-technical").last() );
                }

            }
        }
        if ( contentLengthSum > 0 ) {
            var contentLengthContent =  `<div class="item-child item-child-content-writing" data-count="`+contentLengthSum+`">
                                            <fieldset>
                                                <label for="Page `+tabCount+` Content Writing Keyword `+contentLengthSum+`">Your Content Writing</label>
                                                <input type="number" name="Page `+tabCount+` Content Writing Keyword `+contentLengthSum+`" value="" required>
                                            </fieldset>
                                            <a href="" class="remove-btn remove-content-writing-competitors hidden">&times; remove</a>
                                            <br><a href="" class="small-btn add-content-writing-competitors hidden" style="display: none;">+ Add Competitor</a>
                                        </div>`;

            // Page 1 Content Length
            var objChecked = $('.select-item-products input[name="Page '+tabCount+' Content Writing"]').is(":checked");
            if ( objChecked ) {
                // check if item child content-lengt exists
                if ( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-content-writing").length <= 0 ) {
                    $(this).closest(".cs-content-tab").find(".item.item-products").append(contentLengthContent);
                } else {
                    $( contentLengthContent ).insertAfter( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-content-writing").last() );
                }
            }
        }

        if ( backlinksSum > 0 ) {
            var backlinksContent =  `<div class="item-child item-child-backlinks" data-count="`+backlinksSum+`">
                                        <fieldset>
                                            <label for="Page `+tabCount+` Backlinks Keyword `+backlinksSum+`">Your Backlinks</label>
                                            <input type="number" name="Page `+tabCount+` Backlinks Keyword `+backlinksSum+`" value="" required>
                                        </fieldset>
                                        <a href="" class="remove-btn remove-backlinks-competitors hidden">&times; remove</a>
                                        <br><a href="" class="small-btn add-backlinks-competitors hidden" style="display: none;">+ Add Competitor</a>
                                    </div>`;

            // Page 1 Backlinks
            var objChecked = $('.select-item-products input[name="Page '+tabCount+' Backlinks"]').is(":checked");
            if ( objChecked ) {
                if ( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-backlinks").length <= 0 ) {
                    $(this).closest(".cs-content-tab").find(".item.item-products").append(backlinksContent);
                } else {
                    $( backlinksContent ).insertAfter( $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-backlinks").last() );
                }
            }
        }
    })
    $("body").on("click", ".remove-cs-keywords", function(e){
        e.preventDefault();

        var tabCount = $(this).closest(".cs-content-tab").data("tab-count");
        var keywordCount = $(this).closest(".keywords").find(".keyword").length;

        if ( keywordCount > 0 ) {
            $(this).closest(".keywords").find(".item-child").last().remove();

            // re count
            var keywordCount = $(this).closest(".keywords").find(".keyword").length;

            // update how many keywords
            $(this).closest(".cs-content-tab").find('input[name="Page '+tabCount+' Keyword Count"]').val(keywordCount);

            // hide button on re count
            if ( keywordCount <= 0 ) {
                $(this).addClass("hidden");
            }
        } else {
            $(this).addClass("hidden");
        }

        // 
        var itemChildTechnical     = [];
        var itemChildContentLength = [];
        var itemChildBacklinks     = [];
        $(this).closest(".cs-content-tab").find(".item.item-products .item-child").each(function(){
            if ( $(this).hasClass("item-child-technical") ) {
                itemChildTechnical.push(1);
            }
            if ( $(this).hasClass("item-child-content-writing") ) {
                itemChildContentLength.push(1);
            }
            if ( $(this).hasClass("item-child-backlinks") ) {
                itemChildBacklinks.push(1);
            }
        })

        var technicalSum     = itemChildTechnical.reduce(function(a, b) { return a + b; }, 0) + 1;
        var contentLengthSum = itemChildContentLength.reduce(function(a, b) { return a + b; }, 0) + 1;
        var backlinksSum     = itemChildBacklinks.reduce(function(a, b) { return a + b; }, 0) + 1;


        if ( technicalSum > 0 ) {
            $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-technical").last().remove();
        }
        if ( contentLengthSum > 0 ) {
            $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-content-writing").last().remove();
        }
        if ( backlinksSum > 0 ) {
            $(this).closest(".cs-content-tab").find(".item.item-products .item-child.item-child-backlinks").last().remove();
        }
    })
    // add a competitor
    $("body").on("click", ".add-cs-competitors", function(e){
        e.preventDefault();

        var tabCount        = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName         = $(this).closest(".cs-content-tab").data("tab");
        var competitorCount = $(this).closest(".keyword-competitors").find(".competitor").length;
        var newCount        = competitorCount + 1;
        var keywordCount    = $(this).closest(".keyword").data("keyword-number");

        var competitorContent = `<div class="kc-child competitor">
                                    <label for="Page `+tabCount+` Keyword `+keywordCount+` Competitor `+newCount+`">Competitor</label>
                                    <input type="text" name="Page `+tabCount+` Keyword `+keywordCount+` Competitor `+newCount+`" value="" placeholder="" required>
                                </div>`;
        // insert the content
        $( competitorContent ).insertBefore( $(this) );

        // 
        $(this).siblings(".remove-cs-competitors").removeClass("hidden");

        // check item products
        var itemProducts = $("body").find(".item-products .item-child").length;
        if ( itemProducts > 0 ) {
            // $("body").find(".item-products .item-child").each(function(index, obj){
                // if ( $(this).hasClass("item-child-technical") ) {
                    // console.log(obj);
                    competitorCount++;

                    var technicalContentCompetitor =    `<fieldset class="technical-competitor">
                                                            <label for="Page `+tabCount+` On-page and Technical Keyword `+keywordCount+` Competitor `+competitorCount+`">Competitor</label>
                                                            <input type="number" name="Page `+tabCount+` On-page and Technical Keyword `+keywordCount+` Competitor `+competitorCount+`" value="" required>
                                                        </fieldset>`;

                    $( technicalContentCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-technical[data-count="'+keywordCount+'"] .remove-btn') );

                    var contentLengthCompetitor =    `<fieldset class="content-writing-competitor">
                                                        <label for="Page `+tabCount+` Content Writing Keyword `+keywordCount+` Competitor `+competitorCount+`">Competitor</label>
                                                        <input type="number" name="Page `+tabCount+` Content Writing Keyword `+keywordCount+` Competitor `+competitorCount+`" value="" required>
                                                    </fieldset>`;

                    $( contentLengthCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-content-writing[data-count="'+keywordCount+'"] .remove-btn') );

                    var backlinksCompetitor =   `<fieldset class="backlinks-competitor">
                                                    <label for="Page `+tabCount+` Backlinks Keyword `+keywordCount+` Competitor `+competitorCount+`">Competitor</label>
                                                    <input type="number" name="Page `+tabCount+` Backlinks Keyword `+keywordCount+` Competitor `+competitorCount+`" value="" required>
                                                </fieldset>`;

                    $( backlinksCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-backlinks[data-count="'+keywordCount+'"] .remove-btn') );
                // }
            // })
        }
        // ===================
    })
    $("body").on("click", ".remove-cs-competitors", function(e){
        e.preventDefault();

        var competitorCount = $(this).closest(".keyword-competitors").find(".competitor").length;
        var keywordCount    = $(this).closest(".keyword").data("keyword-number");

        // alert(competitorCount);

        if ( competitorCount >= 1 ) {
            $(this).closest(".keyword-competitors").find(".kc-child").last().remove();

            // re count
            var competitorCount = $(this).closest(".keyword-competitors").find(".competitor").length;

            // hide button on re count
            if ( competitorCount < 1 ) {
                $(this).addClass("hidden");
            }
        } else {
            $(this).addClass("hidden");
        }

        // check item products
        var itemProducts = $("body").find(".item-products .item-child").length;
        if ( itemProducts > 0 ) {
            $(this).closest(".cs-content-tab").find('.item-child-technical[data-count="'+keywordCount+'"] .technical-competitor').last().remove();
            $(this).closest(".cs-content-tab").find('.item-child-content-writing[data-count="'+keywordCount+'"] .content-writing-competitor').last().remove();
            $(this).closest(".cs-content-tab").find('.item-child-backlinks[data-count="'+keywordCount+'"] .backlinks-competitor').last().remove();
        }
    })
    // 
    $("body").on("change", ".select-item-products input[type=checkbox]", function(){
        // alert();

        // var competitorCount = $(this).closest(".cs-content-tab").find(".competitors .competitor").length;
        var tabCount  = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName   = $(this).closest(".cs-content-tab").data("tab");
        var val       = $(this).val();
        var isChecked = $(this).is(":checked");

        // check keyword count
        var keywordCount = $(this).closest(".cs-content-tab").find('input[name="Page '+tabCount+' Keyword Count"]').val();

        // if ( keywordCount != 0 ) {
            if ( val == "on-page-technical" ) {

                // add elements based on the keyword count
                if ( isChecked ) {
                    var commentObj = `<textarea id="Page `+tabCount+` On-page and Technical SEO Comment" name="Page `+tabCount+` On-page and Technical SEO Comment" placeholder="Comment here..."></textarea>`;

                    $(this).closest(".item-child").append(commentObj);

                    for ( i = 1; i <= keywordCount; i++ ) {
                        var technicalContent =  `<div class="item-child item-child-technical" data-count="`+i+`">
                                                    <fieldset>
                                                        <label for="Page `+tabCount+` On-page and Technical Keyword `+i+`">Your On-Page And Technical Score</label>
                                                        <input type="number" name="Page `+tabCount+` On-page and Technical Keyword `+i+`" value="" required>
                                                    </fieldset>
                                                    <a href="" class="remove-btn remove-technical-competitors hidden">&times; remove</a>
                                                    <br><a href="" class="small-btn add-technical-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                </div>`;

                    
                        $(this).closest(".cs-content-tab").find(".item-products").append(technicalContent);

                        //
                        var competitorCount = $(this).closest(".cs-content-tab").find('.item-child.keyword[data-keyword-number="'+i+'"] .kc-child').length;

                        for ( x = 1; x <= competitorCount; x++ ) {
                            var technicalContentCompetitor =    `<fieldset class="technical-competitor">
                                                                    <label for="Page `+tabCount+` On-page and Technical Keyword `+i+` Competitor `+x+`">Competitor</label>
                                                                    <input type="number" name="Page `+tabCount+` On-page and Technical Keyword `+i+` Competitor `+x+`" value="" required>
                                                                </fieldset>`;

                            $( technicalContentCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-technical[data-count="'+i+'"] .remove-btn') );
                        }
                    }
                } else {
                    $(this).closest(".item-child").find("textarea").remove();
                    $(this).closest(".cs-content-tab").find(".item-child-technical").remove();
                }

                /*if ( isChecked ) {
                    $(this).closest(".cs-content-tab").find(".item-products").append(technicalContent);
                } else {
                    $(this).closest(".cs-content-tab").find(".item-child-technical").remove();
                }*/
            } else if ( val == "content-writing" ) {
                /*var contentLengthContent =  `<div class="item-child item-child-content-length">
                                                <fieldset>
                                                    <label for="Page `+tabCount+` Content Length">Your Content-Length</label>
                                                    <input type="number" name="Page `+tabCount+` Content Length" value="" required>
                                                </fieldset>
                                                <a href="" class="remove-btn remove-content-length-competitors hidden">&times; remove</a>
                                                <br><a href="" class="small-btn add-content-length-competitors">+ Add Competitor</a>
                                            </div>`;*/

                if ( isChecked ) {
                    var commentObj = `<textarea id="Page `+tabCount+` Content Writing Comment" name="Page `+tabCount+` Content Writing Comment" placeholder="Comment here..."></textarea>`;

                    $(this).closest(".item-child").append(commentObj);

                    for ( i = 1; i <= keywordCount; i++ ) {
                        var contentLengthContent =  `<div class="item-child item-child-content-writing" data-count="`+i+`">
                                                        <fieldset>
                                                            <label for="Page `+tabCount+` Content Writing Keyword `+i+`">Your Content Writing</label>
                                                            <input type="number" name="Page `+tabCount+` Content Writing Keyword `+i+`" value="" required>
                                                        </fieldset>
                                                        <a href="" class="remove-btn remove-content-writing-competitors hidden">&times; remove</a>
                                                        <br><a href="" class="small-btn add-content-writing-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                    </div>`;

                    
                        $(this).closest(".cs-content-tab").find(".item-products").append(contentLengthContent);

                        //
                        var competitorCount = $(this).closest(".cs-content-tab").find('.item-child.keyword[data-keyword-number="'+i+'"] .kc-child').length;

                        for ( x = 1; x <= competitorCount; x++ ) {
                            /*
                              var technicalContentCompetitor =    `<fieldset class="content-length-competitor">
                                                <label for="Page `+tabCount+` Content Length Competitor `+competitorCount+`">Competitor</label>
                                                <input type="number" name="Page `+tabCount+` Content Length Competitor `+competitorCount+`" value="" required>
                                            </fieldset>`;*/
                            var contentLengthCompetitor =    `<fieldset class="content-writing-competitor">
                                                                    <label for="Page `+tabCount+` Content Writing Keyword `+i+` Competitor `+x+`">Competitor</label>
                                                                    <input type="number" name="Page `+tabCount+` Content Writing Keyword `+i+` Competitor `+x+`" value="" required>
                                                                </fieldset>`;

                            $( contentLengthCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-content-writing[data-count="'+i+'"] .remove-btn') );
                        }
                    }
                } else {
                    $(this).closest(".item-child").find("textarea").remove();
                    $(this).closest(".cs-content-tab").find(".item-child-content-writing").remove();
                }

                /*if ( isChecked ) {
                    $(this).closest(".cs-content-tab").find(".item-products").append(contentLengthContent);
                } else {
                    $(this).closest(".cs-content-tab").find(".item-child-content-length").remove();
                }*/
            } else if ( val == "backlinks" ) {
                /*var backlinksContent =  `<div class="item-child item-child-backlinks">
                                            <fieldset>
                                                <label for="Page `+tabCount+` Backlinks">Your Backlinks</label>
                                                <input type="number" name="Page `+tabCount+` Backlinks" value="" required>
                                            </fieldset>
                                            <a href="" class="remove-btn remove-backlinks-competitors hidden">&times; remove</a>
                                            <br><a href="" class="small-btn add-backlinks-competitors">+ Add Competitor</a>
                                        </div>`;*/

                if ( isChecked ) {
                    var commentObj = `<textarea id="Page `+tabCount+` Backlinks Comment" name="Page `+tabCount+` Backlinks Comment" placeholder="Comment here..."></textarea>`;

                    $(this).closest(".item-child").append(commentObj);

                    for ( i = 1; i <= keywordCount; i++ ) {
                        var backlinksContent =  `<div class="item-child item-child-backlinks" data-count="`+i+`">
                                                    <fieldset>
                                                        <label for="Page `+tabCount+` Backlinks Keyword `+i+`">Your Backlinks</label>
                                                        <input type="number" name="Page `+tabCount+` Backlinks Keyword `+i+`" value="" required>
                                                    </fieldset>
                                                    <a href="" class="remove-btn remove-backlinks-competitors hidden">&times; remove</a>
                                                    <br><a href="" class="small-btn add-backlinks-competitors hidden" style="display: none;">+ Add Competitor</a>
                                                </div>`;

                    
                        $(this).closest(".cs-content-tab").find(".item-products").append(backlinksContent);

                        //
                        var competitorCount = $(this).closest(".cs-content-tab").find('.item-child.keyword[data-keyword-number="'+i+'"] .kc-child').length;

                        for ( x = 1; x <= competitorCount; x++ ) {
                            var backlinksCompetitor =    `<fieldset class="backlinks-competitor">
                                                            <label for="Page `+tabCount+` Backlinks Keyword `+i+` Competitor `+x+`">Competitor</label>
                                                            <input type="number" name="Page `+tabCount+` Backlinks Keyword `+i+` Competitor `+x+`" value="" required>
                                                        </fieldset>`;

                            $( backlinksCompetitor ).insertBefore( $(this).closest(".cs-content-tab").find('.item-child-backlinks[data-count="'+i+'"] .remove-btn') );
                        }
                    }
                } else {
                    $(this).closest(".item-child").find("textarea").remove();
                    $(this).closest(".cs-content-tab").find(".item-child-backlinks").remove();
                }

                /*if ( isChecked ) {
                    $(this).closest(".cs-content-tab").find(".item-products").append(backlinksContent);
                } else {
                    $(this).closest(".cs-content-tab").find(".item-child-backlinks").remove();
                }*/
            } else if ( val == "local-seo-citation" ) {
                if ( isChecked ) {
                    var commentObj = `<textarea id="Page `+tabCount+` Local SEO Citation Comment" name="Page `+tabCount+` Local SEO Citation Comment" placeholder="Comment here..."></textarea>`;

                    $(this).closest(".item-child").append(commentObj);
                } else {
                    $(this).closest(".item-child").find("textarea").remove();
                }
            } else if ( val == "content-marketing" ) {
                if ( isChecked ) {
                    var commentObj = `<textarea id="Page `+tabCount+` Content Marketing Comment" name="Page `+tabCount+` Content Marketing Comment" placeholder="Comment here..."></textarea>`;

                    $(this).closest(".item-child").append(commentObj);
                } else {
                    $(this).closest(".item-child").find("textarea").remove();
                }
            }
        // }
    })
    // add
    $("body").on("click", ".add-technical-competitors", function(e){
        e.preventDefault();
        var tabCount = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName = $(this).closest(".cs-content-tab").data("tab");
        var competitorCount = $(this).closest(".item-child-technical").find(".technical-competitor").length;
        competitorCount += 1;

        var technicalContentCompetitor =    `<fieldset class="technical-competitor">
                                                <label for="Page `+tabCount+` On-page and Technical Competitor `+competitorCount+`">Competitor</label>
                                                <input type="number" name="Page `+tabCount+` On-page and Technical Competitor `+competitorCount+`" value="" required>
                                            </fieldset>`;

        $(technicalContentCompetitor).insertBefore( $(this).siblings(".remove-btn") );
        $(this).siblings(".remove-btn").removeClass("hidden");
    })
    $("body").on("click", ".add-content-writing-competitors", function(e){
        e.preventDefault();
        var tabCount = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName = $(this).closest(".cs-content-tab").data("tab");
        var competitorCount = $(this).closest(".item-child-content-writing").find(".content-writing-competitor").length;
        competitorCount += 1;

        var technicalContentCompetitor =    `<fieldset class="content-writing-competitor">
                                                <label for="Page `+tabCount+` Content Writing Competitor `+competitorCount+`">Competitor</label>
                                                <input type="number" name="Page `+tabCount+` Content Writing Competitor `+competitorCount+`" value="" required>
                                            </fieldset>`;

        $(technicalContentCompetitor).insertBefore( $(this).siblings(".remove-btn") );
        $(this).siblings(".remove-btn").removeClass("hidden");
    })
    $("body").on("click", ".add-backlinks-competitors", function(e){
        e.preventDefault();
        var tabCount = $(this).closest(".cs-content-tab").data("tab-count");
        var tabName = $(this).closest(".cs-content-tab").data("tab");
        var competitorCount = $(this).closest(".item-child-backlinks").find(".backlinks-competitor").length;
        competitorCount += 1;

        var technicalContentCompetitor =    `<fieldset class="backlinks-competitor">
                                                <label for="Page `+tabCount+` Backlinks Competitor `+competitorCount+`">Competitor</label>
                                                <input type="number" name="Page `+tabCount+` Backlinks Competitor `+competitorCount+`" value="" required>
                                            </fieldset>`;

        $(technicalContentCompetitor).insertBefore( $(this).siblings(".remove-btn") );
        $(this).siblings(".remove-btn").removeClass("hidden");
    })
    $("body").on("click", ".remove-btn", function(e){
        e.preventDefault();

        if ( $(this).hasClass("remove-technical-competitors") ) {
            $(this).closest(".item-child").find(".technical-competitor").last().remove();
            var competitorCount = $(this).closest(".item-child").find(".technical-competitor").length;
            // alert(competitorCount);
            if ( competitorCount == 0 ) {
                $(this).addClass("hidden");
            }
        } else if ( $(this).hasClass("remove-content-writing-competitors") ) {
            $(this).closest(".item-child").find(".content-writing-competitor").last().remove();
            var competitorCount = $(this).closest(".item-child").find(".content-writing-competitor").length;
            // alert(competitorCount);
            if ( competitorCount == 0 ) {
                $(this).addClass("hidden");
            }
        } else {
            $(this).closest(".item-child").find(".backlinks-competitor").last().remove();
            var competitorCount = $(this).closest(".item-child").find(".backlinks-competitor").length;
            // alert(competitorCount);
            if ( competitorCount == 0 ) {
                $(this).addClass("hidden");
            }
        }
    })
    // remove page
    $("body").on("click", ".remove-page", function(e){
        e.preventDefault();

        // remove the elements
        var tabName = $(this).closest(".cs-content-tab").data("tab");
        $("body").find('.cs-header-tabs li[data-tab="'+tabName+'"]').remove();
        $("body").find('.cs-content-tab[data-tab="'+tabName+'"]').remove();

        // make the first page the active tab
        $("body").find('.cs-header-tabs li').first().addClass("active");
        $("body").find('.cs-content-tabs .cs-content-tab').addClass("hidden");
        $("body").find('.cs-content-tabs .cs-content-tab').first().removeClass("hidden");

        // get current page count
        var pageCount = $("body").find(".cs-content-tabs .cs-content-tab").length;

        // update input page count
        $('#create-strategy-form input[name="Page Count"]').val(pageCount);

        // loop all remaining pages and change the numbers
        if ( pageCount > 1 ) {
            $("body").find('.cs-content-tabs .cs-content-tab').each(function(index, obj){
                var newTabCount       = index + 1;
                var originalTabCount  = $(this).data("tab-count");
                var originalPageCount = "Page " + originalTabCount;
                var newPageCount      = "Page " + newTabCount;

                // no need to include the first page
                if ( index != 0 && newTabCount != originalTabCount  ) {

                    // update all for attribute data
                    $(this).find("label").each(function(){
                        var labelFor = $(this).attr("for");

                        if( labelFor && labelFor.indexOf( originalPageCount ) != -1 ){
                            var newLabelFor = labelFor.replace( originalPageCount, newPageCount );
                            $(this).attr( "for", newLabelFor );
                        }
                    })

                    // update all id and name attribute data
                    $(this).find("input").each(function(){
                        var inputId   = $(this).attr("id");
                        var inputName = $(this).attr("name");

                        // console.log("====================");
                        // console.log(originalPageCount);
                        // console.log(newPageCount);
                        // console.log(inputId);
                        // console.log(inputName);
                        // console.log("====================");

                        if( inputId && inputId.indexOf( originalPageCount ) != -1 ){
                            var newInputId = inputId.replace( originalPageCount, newPageCount );
                            $(this).attr( "id", newInputId );
                        }

                        if( inputName && inputName.indexOf( originalPageCount ) != -1 ){
                            var newInputName = inputName.replace( originalPageCount, newPageCount );
                            $(this).attr( "name", newInputName );
                        }
                    })

                    // 
                    $(this).find("textarea").each(function(){
                        var textareaId   = $(this).attr("id");
                        var textareaName = $(this).attr("name");

                        if( textareaId && textareaId.indexOf( originalPageCount ) != -1 ){
                            var newTextareaId = textareaId.replace( originalPageCount, newPageCount );
                            $(this).attr( "id", newTextareaId );
                        }

                        if( textareaName && textareaName.indexOf( originalPageCount ) != -1 ){
                            var newTextareaName = textareaName.replace( originalPageCount, newPageCount );
                            $(this).attr( "name", newTextareaName );
                        }
                    })
                    // console.log(originalTabCount);
                    // console.log(newTabCount);
                    // console.log(index);
                    // console.log(obj);
                }

                // update tab count data
                $(this).data("tab-count", newTabCount).attr("data-tab-count", newTabCount);
            })
        }

        /*// page count
        var count = $('#create-strategy-form input[name="Page Count"]').val();
        */
    })


    // user free seo strategy
    $("body").on("click", ".fss-tab-header > li > a", function(e){
        e.preventDefault();
        var tabName = $(this).closest("li").data("tab");
        
        $("body").find('.fss-tab-header > li').removeClass("active");
        $("body").find('.fss-tab-header > li[data-tab="'+tabName+'"]').addClass("active");
        $("body").find('.fss-tab-content').removeClass("active").addClass("hidden");
        $("body").find('.fss-tab-content[data-tab="'+tabName+'"]').addClass("active").removeClass("hidden");
    })
})( jQuery );