<?php
// THRIVE VARIABLE
defined( 'TVE_EDITOR_URL' ) || define( 'TVE_EDITOR_URL', get_template_directory_uri() . '/architect/' );

define( "PACKAGED_SERVICES", array(2090, 2105, 2117, 2129, 2134, 2111) );
define( "MANAGED_SERVICES", array(2027, 2055, 2066, 2076, 2081, 2123) );
define( "RANKTRACKER_SERVICES", array(2203) );
define( "CONTENT_WRITING_SERVICES", 2129 );
define( "BLOG_WRITING_SERVICES", 2134 );

include_once( ABSPATH . "wp-content/themes/thrive-theme-child/includes/free-seo-tools.php");

// ENQUEUE THEME SCRIPTS AND STYLESHEETS
add_action( 'wp_enqueue_scripts', function () {
	$parent_style = 'parent-style';

    // STYLESHEETS
	wp_enqueue_style( $parent_style, get_template_directory_uri() . '/style.css' ); // parent theme stylesheet
    if ( is_account_page() ) {
    	wp_enqueue_style( 'fontawesome', '//cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.1/css/fontawesome.min.css' );
    	wp_enqueue_style( 'jquery-ui', get_stylesheet_directory_uri().'/public/css/plugins/jquery-ui.css' );
    }
    wp_enqueue_style( 'bootstrap', '//cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/css/bootstrap.min.css' );
    wp_enqueue_style( 'nouislider', '//cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.2/nouislider.min.css' );
    wp_enqueue_style( 'child-style', get_stylesheet_directory_uri() . '/style.css', [ $parent_style ], wp_get_theme()->get( 'Version' ) );
    // wp_enqueue_style( 'main-child-style', get_stylesheet_directory_uri() . '/assets/css/main.css?t='.time(), [ $parent_style ] );
    wp_enqueue_style( 'main-child-style', get_stylesheet_directory_uri() . '/public/css/main.css', [ $parent_style ] );

    // new here
    wp_register_style('seo-manager', get_stylesheet_directory_uri() . '/public/css/pages/seo-manager.css');
    wp_register_style('old-seo-manager', get_stylesheet_directory_uri() . '/public/css/pages/old-seo-manager.css');
    wp_register_style('woocommerce-styles', get_stylesheet_directory_uri() . '/public/css/pages/woocommerce.css');
    
    
    // ENQUEUE STYLESHEETS
    if (is_account_page()) {
        wp_enqueue_style('seo-manager');
    }
    
    // woocommerce stylesheet
    if(is_woocommerce() || is_cart() || is_checkout() || is_account_page()){
        wp_enqueue_style('woocommerce-styles');
    }

    // SCRIPTS
    wp_enqueue_script( 'bootstrap-js', '//cdnjs.cloudflare.com/ajax/libs/twitter-bootstrap/4.5.2/js/bootstrap.bundle.min.js', array(), '4.5.2', true );
    // wp_enqueue_script( 'match-height', '//cdnjs.cloudflare.com/ajax/libs/jquery.matchHeight/0.7.2/jquery.matchHeight-min.js', array(), '1', true );
    wp_enqueue_script( 'nouislider-js', '//cdnjs.cloudflare.com/ajax/libs/noUiSlider/14.6.2/nouislider.min.js', array(), '14.6.2', true );
    wp_enqueue_script( 'active-campaign-js', get_stylesheet_directory_uri().'/assets/js/active-campaign.js', array('jquery'), '1', true );

    if (is_account_page()) {
        // wp_enqueue_script( 'rgraph-svg-common', get_stylesheet_directory_uri().'/public/libraries/RGraph.svg.common.core.js', array(), '1.0.0', false );
        // wp_enqueue_script( 'rgraph-svg-hbar', get_stylesheet_directory_uri().'/public/libraries/RGraph.svg.hbar.js', array(), '1.0.0', false );
        // wp_enqueue_script( 'rgraph-common.context', get_stylesheet_directory_uri().'/public/libraries/RGraph.common.context.js', array(), '1.0.0', false );
        wp_enqueue_script( 'rgraph-common-core', get_stylesheet_directory_uri().'/public/libraries/RGraph.common.core.js', array(), '1.0.0', false );
        wp_enqueue_script( 'rgraph-common-dynamic', get_stylesheet_directory_uri().'/public/libraries/RGraph.common.dynamic.js', array(), '1.0.0', false );
        wp_enqueue_script( 'rgraph-common-tooltips', get_stylesheet_directory_uri().'/public/libraries/RGraph.common.tooltips.js', array(), '1.0.0', false );
        wp_enqueue_script( 'rgraph-pie', get_stylesheet_directory_uri().'/public/libraries/RGraph.pie.js', array(), '1.0.0', false );

        // wp_enqueue_script( 'chart-js', '//cdnjs.cloudflare.com/ajax/libs/Chart.js/2.9.4/Chart.js', array(), '2.9.4', false );
        // wp_enqueue_script( 'chart-js', '//cdnjs.cloudflare.com/ajax/libs/Chart.js/4.2.1/chart.min.js', array(), '4.2.1', false );
        // wp_enqueue_script( 'chart-js', '//cdn.jsdelivr.net/npm/chart.js@4.2.1/dist/chart.umd.min.js', array(), '4.2.1', false );
        // wp_enqueue_script( 'chart-helpers-js', '//cdnjs.cloudflare.com/ajax/libs/Chart.js/4.2.1/helpers.min.js', array(), '4.2.1', false );
        // wp_enqueue_script( 'chart-utils-js', get_stylesheet_directory_uri().'/assets/js/chart-utils.js', array(), '4.2.1', false );
        wp_enqueue_script( 'chart-js', '//cdn2.hubspot.net/hubfs/476360/Chart.js', array(), '4.2.1', false );
        wp_enqueue_script( 'chart-utils-js', '//cdn2.hubspot.net/hubfs/476360/utils.js', array(), '4.2.1', false );
        

        wp_enqueue_script( 'pdfobject-js', '//cdnjs.cloudflare.com/ajax/libs/pdfobject/2.2.5/pdfobject.min.js', array(), '2.2.5', true );
        wp_enqueue_script( 'jspdf', '//cdnjs.cloudflare.com/ajax/libs/jspdf/2.3.1/jspdf.umd.min.js', array(), '2.3.1', true );
        wp_enqueue_script( 'jspdf-autotable',  '//unpkg.com/jspdf-autotable@3.5.15/dist/jspdf.plugin.autotable.js', array(), '3.5.15', true );
        wp_enqueue_script( 'seo-manager-js', get_stylesheet_directory_uri().'/assets/js/seo-manager.js?t='.time(), array('jquery'), '1', true );
        wp_localize_script( 'seo-manager-js', 'wp_ajax', array(
            'ajax_url' => admin_url( 'admin-ajax.php' ),
        ));
    }

    // cart
    wp_enqueue_script( 'seo-cart', get_stylesheet_directory_uri().'/assets/js/seo-cart.js?t='.time(), array('jquery'), '1', true );
    wp_localize_script( 'seo-cart', 'wp_ajax', array(
        'ajax_url' => admin_url( 'admin-ajax.php' ),
    ));

    wp_enqueue_script( 'main-js', get_stylesheet_directory_uri().'/assets/js/main.js?t='.time(), array('jquery'), '1', true );

    // localize wordpress ajax
    wp_localize_script( 'active-campaign-js', 'wp_ajax', array(
        'ajax_url' => admin_url( 'admin-ajax.php' ),
    ));
    wp_localize_script( 'main-js', 'wp_ajax', array(
        'ajax_url' => admin_url( 'admin-ajax.php' ),
    ));

}, PHP_INT_MAX );

function remove_thrive_scripts_styles() {
    if ( is_page( 180 ) ) { // replace 'your-page-slug' with the slug of the page where you want to remove Thrive Themes scripts and stylesheets
    // if ( is_account_page() ) { // replace 'your-page-slug' with the slug of the page where you want to remove Thrive Themes scripts and stylesheets
        wp_dequeue_script( 'theme-woo' );
        wp_dequeue_script( 'tve_frontend_acf-dynamic-elements' );
        wp_dequeue_script( 'tve_frontend_audio' );
        wp_dequeue_script( 'carousel-libs' );
        wp_dequeue_script( 'tve_frontend_carousel' );
        wp_dequeue_script( 'tve_frontend_contact-form-compat' );
        wp_dequeue_script( 'tve_frontend_content-reveal' );
        wp_dequeue_script( 'tve_frontend_countdown' );
        wp_dequeue_script( 'tve_frontend_conditional-display' );
        wp_dequeue_script( 'tve_frontend_search-form' );
        wp_dequeue_script( 'tve_frontend_dropdown' );
        wp_dequeue_script( 'tve_frontend_divider' );
        wp_dequeue_script( 'tve_frontend_file-upload' );
        wp_dequeue_script( 'tve_frontend_avatar-picker' );
        wp_dequeue_script( 'tve_frontend_fill-counter' );
        wp_dequeue_script( 'tve_frontend_number-counter' );
        wp_dequeue_script( 'image-gallery-libs' );
        wp_dequeue_script( 'tve_frontend_image-gallery' );
        wp_dequeue_script( 'tve_frontend_lead-generation' );
        wp_dequeue_script( 'tve_frontend_login' );
        wp_dequeue_script( 'tve_frontend_menu' );
        wp_dequeue_script( 'tve_frontend_number-counter-compat' );
        wp_dequeue_script( 'tve_frontend_post-grid-compat' );
        wp_dequeue_script( 'tve_frontend_pagination' );
        wp_dequeue_script( 'tve_frontend_post-list' );
        wp_dequeue_script( 'tve_frontend_post-list-filter' );
        wp_dequeue_script( 'tve_frontend_pricing-table' );
        wp_dequeue_script( 'tve_frontend_progress-bar' );
        wp_dequeue_script( 'tve_frontend_social-share' );
        wp_dequeue_script( 'tve_frontend_table' );
        wp_dequeue_script( 'tve_frontend_tabs' );
        wp_dequeue_script( 'tve_frontend_timer' );
        wp_dequeue_script( 'tve_frontend_toc' );
        wp_dequeue_script( 'tve_frontend_toggle' );
        wp_dequeue_script( 'tve_frontend_twitter' );
        wp_dequeue_script( 'tve_frontend_user-profile' );
        wp_dequeue_script( 'tve_frontend_video' );
        wp_dequeue_script( 'tve_frontend_google-api' );
        wp_dequeue_script( 'tve_frontend_facebook-api' );
        wp_dequeue_script( 'tve_frontend_modal' );
    }
}
add_action( 'wp_enqueue_scripts', 'remove_thrive_scripts_styles', 100 );


// MOVE SEO YOAST TO BOTTOM
add_filter( 'wpseo_metabox_prio', function() { return 'low'; } );

// add excerpt support for pages 
add_post_type_support( 'page', 'excerpt' );


//
locate_template('includes/seo-manager/seo-rankings.php', TRUE, TRUE);
locate_template('includes/seo-learning.php', TRUE, TRUE);

// GRAVITY FORMS FUNCTIONS
locate_template('includes/gravityforms.php', TRUE, TRUE);

// CART ORDER PAGE
// locate_template('includes/cart-order.php', TRUE, TRUE);

// SINGLE PRODUCT FUNCTIONS
// locate_template('includes/single-product.php', TRUE, TRUE);

// ACTIVE CAMPAIGN TRIGGER
locate_template('includes/active-campaign.php', TRUE, TRUE);

// WOOCOMMERCE
locate_template('includes/woocommerce.php', TRUE, TRUE);

// SEO MANAGER NEW
locate_template('includes/seo-manager/dashboard.php', TRUE, TRUE);
locate_template('includes/seo-manager/report-generator.php', TRUE, TRUE); // reports generator
locate_template('includes/seo-manager/report-history.php', TRUE, TRUE); // report history
locate_template('includes/seo-manager/assigned-orders.php', TRUE, TRUE); // assigned orders
locate_template('includes/seo-manager/seo-strategy.php', TRUE, TRUE); // seo strategy
locate_template('includes/seo-manager/seo-strategy-todo.php', TRUE, TRUE); // todo
locate_template('includes/seo-manager/seo-learning.php', TRUE, TRUE); // seo learning
locate_template('includes/seo-manager/client-information.php', TRUE, TRUE); // client information
locate_template('includes/seo-manager/seo-managers-view.php', TRUE, TRUE); // managers

/* SEO TOOLS */
locate_template('includes/seo-manager/tools/backlink-checker.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/domain-authority-checker.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/wordcount.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/anchor-count.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/content-readability.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/ssl-certificate-checker.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/keyword-density.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/keyword-extraction.php', TRUE, TRUE); // backlink checker
locate_template('includes/seo-manager/tools/conversion-rate-calculator.php', TRUE, TRUE); // 

// new add to cart
locate_template('includes/seo-cart/add-to-cart.php', TRUE, TRUE); //
locate_template('includes/seo-cart/cart-view.php', TRUE, TRUE); //

// 
locate_template('includes/user-profile-dashboard.php', TRUE, TRUE);




// login / signup link
add_shortcode( 'signupLink', '_loginSignUpMyAccountLink' );
function _loginSignUpMyAccountLink() {
    ob_start();

    if(current_user_can("administrator")){

        // get wc cart link
        $cartLink = wc_get_cart_url();
        ?>
            <a href="<?php echo $cartLink; ?>" class="header-cart text-white mr-3 pr-3 text-decoration-none">
                <svg class="tcb-icon text-white" fill="currentColor" viewBox="0 0 24 24" data-id="icon-cart-outlined" data-name=""><path d="M17,18A2,2 0 0,1 19,20A2,2 0 0,1 17,22C15.89,22 15,21.1 15,20C15,18.89 15.89,18 17,18M1,2H4.27L5.21,4H20A1,1 0 0,1 21,5C21,5.17 20.95,5.34 20.88,5.5L17.3,11.97C16.96,12.58 16.3,13 15.55,13H8.1L7.2,14.63L7.17,14.75A0.25,0.25 0 0,0 7.42,15H19V17H7C5.89,17 5,16.1 5,15C5,14.65 5.09,14.32 5.24,14.04L6.6,11.59L3,4H1V2M7,18A2,2 0 0,1 9,20A2,2 0 0,1 7,22C5.89,22 5,21.1 5,20C5,18.89 5.89,18 7,18M16,11L18.78,6H6.14L8.5,11H16Z"></path></svg>
                <span>Cart</span>
            </a>
        <?php
    }
    
    echo "<div class='top-menu-signup-link'><a href='" . get_permalink( get_option('woocommerce_myaccount_page_id') ) . "'>";
    // echo is_user_logged_in() ? "<svg class='tcb-icon' viewBox='0 0 496 512' data-id='icon-user-circle-regular' data-name=''><path d='M248 104c-53 0-96 43-96 96s43 96 96 96 96-43 96-96-43-96-96-96zm0 144c-26.5 0-48-21.5-48-48s21.5-48 48-48 48 21.5 48 48-21.5 48-48 48zm0-240C111 8 0 119 0 256s111 248 248 248 248-111 248-248S385 8 248 8zm0 448c-49.7 0-95.1-18.3-130.1-48.4 14.9-23 40.4-38.6 69.6-39.5 20.8 6.4 40.6 9.6 60.5 9.6s39.7-3.1 60.5-9.6c29.2 1 54.7 16.5 69.6 39.5-35 30.1-80.4 48.4-130.1 48.4zm162.7-84.1c-24.4-31.4-62.1-51.9-105.1-51.9-10.2 0-26 9.6-57.6 9.6-31.5 0-47.4-9.6-57.6-9.6-42.9 0-80.6 20.5-105.1 51.9C61.9 339.2 48 299.2 48 256c0-110.3 89.7-200 200-200s200 89.7 200 200c0 43.2-13.9 83.2-37.3 115.9z'></path></svg> Your Dashboard" : "<svg class='tcb-icon' viewBox='0 0 512 512' data-id='icon-sign-in-alt-solid' data-name=''><path d='M416 448h-84c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h84c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32h-84c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12h84c53 0 96 43 96 96v192c0 53-43 96-96 96zm-47-201L201 79c-15-15-41-4.5-41 17v96H24c-13.3 0-24 10.7-24 24v96c0 13.3 10.7 24 24 24h136v96c0 21.5 26 32 41 17l168-168c9.3-9.4 9.3-24.6 0-34z'></path></svg> Login Or Sign Up" ;
    echo is_user_logged_in() ? '<svg class="tcb-icon" viewBox="0 0 640 512" data-id="icon-laptop-code-solid" data-name=""><path d="M255.03 261.65c6.25 6.25 16.38 6.25 22.63 0l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L253.25 192l35.71-35.72c6.25-6.25 6.25-16.38 0-22.63l-11.31-11.31c-6.25-6.25-16.38-6.25-22.63 0l-58.34 58.34c-6.25 6.25-6.25 16.38 0 22.63l58.35 58.34zm96.01-11.3l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0l58.34-58.34c6.25-6.25 6.25-16.38 0-22.63l-58.34-58.34c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63L386.75 192l-35.71 35.72c-6.25 6.25-6.25 16.38 0 22.63zM624 416H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33.02-17.47-32.77-32H16c-8.8 0-16 7.2-16 16v16c0 35.2 28.8 64 64 64h512c35.2 0 64-28.8 64-64v-16c0-8.8-7.2-16-16-16zM576 48c0-26.4-21.6-48-48-48H112C85.6 0 64 21.6 64 48v336h512V48zm-64 272H128V64h384v256z"></path></svg> Your Dashboard' : "<svg class='tcb-icon' viewBox='0 0 512 512' data-id='icon-sign-in-alt-solid' data-name=''><path d='M416 448h-84c-6.6 0-12-5.4-12-12v-40c0-6.6 5.4-12 12-12h84c17.7 0 32-14.3 32-32V160c0-17.7-14.3-32-32-32h-84c-6.6 0-12-5.4-12-12V76c0-6.6 5.4-12 12-12h84c53 0 96 43 96 96v192c0 53-43 96-96 96zm-47-201L201 79c-15-15-41-4.5-41 17v96H24c-13.3 0-24 10.7-24 24v96c0 13.3 10.7 24 24 24h136v96c0 21.5 26 32 41 17l168-168c9.3-9.4 9.3-24.6 0-34z'></path></svg> Login Or Sign Up" ;
    echo "</a></div>";

	return ob_get_clean();
}

// HOOK TO FOOTER
add_action( 'wp_footer', '_footerHooks' );
function _footerHooks() {
    // learning hub single page information
    global $post;
    if ( $post->post_type == 'learning_hub' && !is_admin() ) {
        echo '<div id="cstm-page-data" data-page-title="'.$post->post_title.'" data-page-id="'.$post->ID.'"></div>';
    }

    // free seo audit
    // 2693 - landing page
    // 2693 - contact page
    // if ( is_page( 2675 ) || is_account_page() || is_page( 2693 ) ) {
    if ( is_page( 2675 ) || is_page( 2693 ) ) {
?>
        <script type="text/javascript" src="https://seo-tools.seoi.co.uk/leadgen/520303/quick_report.js" async="true"></script>
<?php
    }

    // 
    if ( is_account_page() ) {
?>
        <!--  -->
        <div id="dashboardEditRequestModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="btn btn-default close" data-dismiss="modal">&times;</button>
                        <?php echo do_shortcode('[gravityform id=2 description=false title=false ajax=true]'); ?>
                    </div>
                </div>
            </div>
        </div>

        <!--  -->
        <div id="pdfModal" class="modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <button type="button" class="btn btn-default close" data-dismiss="modal">&times;</button>
                        <div id="pdf-container"></div>
                    </div>
                </div>
            </div>
        </div>
<?php
    }
}

// ADD CUSTOM USER ROLE
add_role( "account_manager", __( 'Account Manager' ), array(
    'read'       => true,
    'edit_posts' => true
) );
// ADD CUSTOM USER ROLE
add_role( "seo_account_manager", __( 'SEO Account Manager' ), array(
    'read'       => true,
    'edit_posts' => false
) );


// SECTION ANCHOR LINKS
add_shortcode( 'modalLoginRegister', '_modalLoginRegister' );
function _modalLoginRegister() {
    ob_start();

    /*
     * 
     * SEO Management Service    -- 2027
     * Local SEO Services        -- 2055
     * National SEO Service      -- 2066
     * International SEO Service -- 2076
     * eCommerce SEO Services    -- 2081
     * Blog Management           -- 2123
     * Local SEO Citations       -- 2111
     * 
     * Blogger Outreach Service  -- 2090
     * Guest Post Service        -- 2105
     * On-Page SEO Services      -- 2117
     * Content Writing Service   -- 2129
     * Blog Writing Service      -- 2134
     * 
     */

    // services list -- all are pages
    // $services = ["Blogger Outreach Service", "Guest Post Service", "On-Page SEO Service", "Content Writing Services", "Blog Writing Service", "Rank Tracker Basic", "Rank Tracker Business", "Rank Tracker Enterprise", "SEO Management Service", "Local SEO Services", "National SEO Service", "International SEO Service", "eCommerce SEO Services", "Blog Management", "Social Media Marketing Service"];
    $services = [2027, 2055, 2066, 2076, 2081, 2123, 2090, 2105, 2117, 2129, 2134, 2111];

    $refererUrl    = isset( $_SERVER['HTTP_REFERER'] ) ? $_SERVER['HTTP_REFERER'] : "";
    $refererPageId = isset($refererUrl) ? url_to_postid($refererUrl) : '';
    $pageId = isset( $_GET['pid'] ) ? $_GET['pid'] : "";

    global $wp_query;
    // QUERY PRODUCT BY META
    $args = array(
        'post_type' => 'product',
        'meta_query' => array(
            array(
                'key' => 'related_page',
                'value' => $wp_query->queried_object->ID,
                'compare' => '='
            )
        ),
        // id only
        'fields' => 'ids'
    );
    // get product
    $product = get_posts( $args );
    // $product = new WP_Query( $args );


    if ( is_user_logged_in() ) {

        /*
            1. if page is a service
            2. if page is not a service and if referer exists and if referer is a service
        */

    ?>
        <div id="gform_confirmation_wrapper_4">
            <div class="gform_confirmation_message">
                <div class="confirmation_content">
                    <p><strong>What next?</strong></p>
                    <ol>
                        <li>Go to your <a href="<?php echo get_site_url(); ?>/seo-manager/">dashboard</a></li>
                        <?php if($product){ ?>
                            <li>Order <a href="<?php echo get_the_permalink( $product[0] ); ?>"><?php echo get_the_title( $wp_query->queried_object->ID ); ?></a></li>
                        <?php } ?>
                            <?php if ( $refererUrl ): ?>
                                <li>Go back to <a href="<?php echo $refererUrl; ?>"><?php echo get_the_title( $refererPageId ); ?></a></li>
                            <?php endif; ?>
                    </ol>
                </div>
            </div>
        </div>
    <?php } else { ?>
        <!-- check if page is contact page -->
        <?php if ( is_page( 2675 ) ): ?>
            <div id="gform_confirmation_wrapper_4">
                <div class="gform_confirmation_message">
                    <div class="confirmation_content">
                        <p><strong>What next?</strong></p>
                        <ol>
                            <li>Go to your <a href="<?php echo get_site_url(); ?>/seo-manager/">dashboard</a></li>

                            <?php if($product){ ?>
                                <li>Order <a href="<?php echo get_the_permalink( $product[0] ); ?>"><?php echo get_the_title( $wp_query->queried_object->ID ); ?></a></li>
                            <?php } ?>

                            <?php if ( $refererUrl ): ?>
                                <li>Go back to <a href="<?php echo $refererUrl; ?>"><?php echo get_the_title( $pageId ); ?></a></li>
                            <?php endif; ?>
                        </ol>
                    </div>
                </div>
            </div>
        <?php else: ?>
            <div class='login-sign-up-form'>
                <div class='modal-login-form'>
                    <h3>Login</h3>
                    <p>Got an account? Welcome back. Login here</p>
                    <?php 
                    $redirectUrl = get_site_url()."/seo-manager/";
                        echo wp_login_form( array( "redirect" => $redirectUrl ) ); 
                    ?>
                </div>
                <?php echo do_shortcode( "[gravityform id=4 ajax=true description=false title=false]" ); ?>
            </div>
        <?php endif ?>
    <?php
    }
    
    return ob_get_clean();
}

// pre populate page id on form 4
add_filter('gform_field_value_page_id', '_gformPageId');
function _gformPageId( $value ){

    // get user data
    $pageId = get_queried_object_id();

    // 
    return $pageId;
}

// redirect non admin users
// prevent non admin users from accessing wp-admin
add_action('init','wpse23007_redirect');
function wpse23007_redirect(){
  if( is_admin() && !defined('DOING_AJAX') && !current_user_can('administrator') && is_user_logged_in() ){
  // if( is_admin() && !defined('DOING_AJAX') && !current_user_can('administrator') ){
    wp_redirect(get_site_url()."/seo-manager/");
    exit;
  }
}


// Hook the appropriate WordPress action
add_action('init', 'prevent_wp_login');
function prevent_wp_login() {
    // WP tracks the current page - global the variable to access it
    global $pagenow;
    // Check if a $_GET['action'] is set, and if so, load it into $action variable
    $action = (isset($_GET['action'])) ? $_GET['action'] : '';
    // Check if we're on the login page, and ensure the action is not 'logout'
    if( $pagenow == 'wp-login.php' && ( ! $action || ( $action && ! in_array($action, array('logout', 'lostpassword', 'rp', 'resetpass'))))) {
        // Load the home page url
        $page = get_bloginfo('url');
        // Redirect to the home page
        // wp_redirect($page);
        wp_redirect(get_site_url()."/seo-manager/");
        // Stop execution to prevent the page loading for any reason
        // exit();
    }
}

// add bottom text below button for contact page form
add_filter( 'gform_submit_button_6', '_add_text_below_form', 10, 2 );
function _add_text_below_form( $button, $form ) {
    return $button .= "<p><a href='' class='not-now'>Not Now →</a></p>";
}

add_action('after_setup_theme', 'remove_admin_bar');
function remove_admin_bar() {
    if (!current_user_can('administrator') && !is_admin()) {
        show_admin_bar(false);
    }
}

// disable json rest api
// add_filter('json_enabled', '__return_false');
// add_filter('json_jsonp_enabled', '__return_false');

// change user orders on users.php
add_filter( "users_list_table_query_args","_change_user_order" );
function _change_user_order($args){
    $args["orderby"] = "user_registered";
    $args["order"] = "DESC";
    return $args;
}

// 
// add_action( 'template_redirect', '_redirectSingleProductPage', 100 );
function _redirectSingleProductPage() {
    if ( !is_product() ) return; // Only for single product pages.
    
    if ( !current_user_can("administrator") ){

        wp_redirect( get_site_url().'/seo-services/' );
    }


    exit();
}

// Add MS Word .doc files mime type to WordPress.
add_filter( 'upload_mimes', function( $mime_types ) {
    $mime_types['doc'] = 'application/msword'; // Adding .doc extension
    $mime_types['docx'] = 'application/vnd.openxmlformats-officedocument.wordprocessingm'; // Adding .docx extension
 
    return $mime_types;
}, 1, 1 );


// exclude pages from yoast
add_filter( 'wpseo_exclude_from_sitemap_by_post_ids', function () {
    return array(180);
} );

// body class
add_filter( 'body_class', function( $classes ) {
    if (is_user_logged_in()) {
        return $classes;
    } else {
        return array_merge( $classes, array( 'logged-out' ) );
    }
} );

// SINGLE PAGE SEO LEARNING SIDEBAR
add_shortcode( 'seo-learning-sidebar', '_SidebarSinglePost' );
function _SidebarSinglePost($atts) {

    $post_type = "post";
     $taxonomy  = "category";

    if ( $atts && $atts['type'] == 'seo-learning') {
        $post_type = "learning_hub";
        $taxonomy  = "learning_hub_categories";
    }

    $postTerms = wp_get_post_terms( get_queried_object_id(), $taxonomy );

    // $postTerms = false;
    // var_dump($postTerms);

    ob_start();

    if ( $postTerms ) {
        $seoLearningQuery = new WP_Query( array(
            "post_type"      => $post_type,
            "post_status"    => "publish",
            "posts_per_page" => -1,
            "order"          => "DESC",
            "orderby"        => "menu_order",
            "tax_query"      => array(
                array(
                    "taxonomy" => $taxonomy,
                    "field"    => "id",
                    "terms"    => array( $postTerms[0]->term_id )
                )
            )
        ) );
?>
    <div class="sidebarSeoLearning">
        <div class="sidebar-seolearning-widget">
            <h4><?php echo $postTerms[0]->name; ?></h4>

            <?php
                if ( $seoLearningQuery->have_posts() ) {
                    echo "<ul class='post-items'>";
                    while ( $seoLearningQuery->have_posts() ) { $seoLearningQuery->the_post();
                        $activeClass = get_queried_object_id() == get_the_ID() ? "active" : "";
                        $image = get_the_post_thumbnail_url(get_the_ID(), "thumbnail");
                    ?>
                        <li class='<?php echo $activeClass; ?>'>
                            <a href='<?php echo get_the_permalink(); ?>'>
                                <div class="img" style="background-image: url(<?php echo $image; ?>);"></div>
                                <span class="title"><?php echo get_the_title(); ?></span>
                                <span class="excerpt"><?php echo wp_trim_words( get_the_excerpt(), 12, '...' ); ?></span>
                            </a>
                        </li>
                    <?php
                    } wp_reset_postdata();
                    echo "</ul>";
                }
            ?>
        </div>
        <div class="sidebar-seolearning-widget">
            <?php echo wp_nav_menu(array(
                "menu" => "Main Menu"
            )); ?>
        </div>
    </div>
<?php
    }

    return ob_get_clean();
}


// HEADER SHORTCODE
add_shortcode( 'cstm-header', '_header' );
function _header() {
    ob_start();
?>
        <header id="custom-header">
            <div class="top-header">
                <div class="container">
                    <div class="row">
                        <div class="header-column col-12">
                            <div class="top-header-wrap">
                                <?php echo wp_nav_menu(array(
                                    "menu"  => "Top Menu",
                                    "depth" => 1
                                )); ?>
                                <?php echo do_shortcode('[signupLink]'); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="bottom-header">
                <div class="container">
                    <div class="row align-items-center">
                        <div class="header-column col-3 col-lg-3">
                            <a href="<?php echo get_site_url(); ?>/" class="site-logo">
                                <img src="<?php echo get_site_url(); ?>/wp-content/uploads/2020/11/seoi-logo-white.png" alt="SEOi Agency" class="img-fluid no-lazy">
                            </a>
                        </div>
                        <div class="header-column col-9 col-lg-9">
                            <?php echo wp_nav_menu(array(
                                "menu"  => "Main Menu",
                                "depth" => 3
                            )); ?>
                            <div class="menu-bar-wrap">
                                <div class="menu-bar">
                                    <span class="bar"></span>
                                    <span class="bar"></span>
                                    <span class="bar"></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </header>
<?php
    return ob_get_clean();
}



// seo methods
class SEOI_SEO{

	public $page_link;
	public $page_keyword;

    // for getting the domain authority and backlinks
	public function moz_url_metrics($page_link){

		$curl = curl_init();
		
		curl_setopt_array($curl, array(
			CURLOPT_URL => 'https://lsapi.seomoz.com/v2/url_metrics',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			CURLOPT_POSTFIELDS =>'{
				"targets": ["'.$page_link.'"]
			}',
			CURLOPT_HTTPHEADER => array(
				'Authorization: Basic bW96c2NhcGUtZGZiOTljNDQwNjo3ZDEyNzYzMTg2ZGFiM2QwYmUxNzQ1M2M3ODljYWY4Nw==',
				'Content-Type: text/plain',
				'Cookie: __cf_bm=uSBqf0e5AqpGFGTTU0D6gOJ2Bb3Q5Cugq3hlcF2y_zY-1650457357-0-AR/0flauTeezbLfqcI7C6UAjgc0VKLhR1k18oXFQmf+dJn+eCUHUxzTEZqpB/FhIZ3oj4D04jINYvBQDqxg5qqQ='
			),
		));
		
		$response = curl_exec($curl);
	    $json_result = json_decode($response, true);
		
		curl_close($curl);
		return $json_result;
	}

    /*
     * MOZ LINK API
     * https://moz.com/help/links-api/making-calls/links
     * - refurbished with different parameters  
     *  
     */
    public function anchor_text($page_link){

        $curl = curl_init();
		
		curl_setopt_array($curl, array(
			// CURLOPT_URL => 'https://lsapi.seomoz.com/v2/links',
			CURLOPT_URL => 'https://lsapi.seomoz.com/v2/anchor_text',
			CURLOPT_RETURNTRANSFER => true,
			CURLOPT_ENCODING => '',
			CURLOPT_MAXREDIRS => 10,
			CURLOPT_TIMEOUT => 0,
			CURLOPT_FOLLOWLOCATION => true,
			CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
			CURLOPT_CUSTOMREQUEST => 'POST',
			/* CURLOPT_POSTFIELDS =>'{
				"target": "'.$page_link.'",
                // "target_scope": "page",
                "scope": "page",
                // "filter": "external+nofollow"    
			}', */
            CURLOPT_POSTFIELDS =>'{
				"target": "'.$page_link.'",
                "scope": "page"  
			}',
			CURLOPT_HTTPHEADER => array(
				'Authorization: Basic bW96c2NhcGUtZGZiOTljNDQwNjo3ZDEyNzYzMTg2ZGFiM2QwYmUxNzQ1M2M3ODljYWY4Nw==',
				'Content-Type: text/plain',
				'Cookie: __cf_bm=uSBqf0e5AqpGFGTTU0D6gOJ2Bb3Q5Cugq3hlcF2y_zY-1650457357-0-AR/0flauTeezbLfqcI7C6UAjgc0VKLhR1k18oXFQmf+dJn+eCUHUxzTEZqpB/FhIZ3oj4D04jINYvBQDqxg5qqQ='
			),
		));
		
		$response = curl_exec($curl);
	    $json_result = json_decode($response, true);
		
		curl_close($curl);
		return $json_result;
    }

    /*
     * Get the google search results by keywords using serpapi
     * -- https://serpapi.com/search-api
     * 
     */
    public function get_top_sites_by_keywords($page_keyword = NULL, $page = NULL){

        $curl = curl_init();

        // page offset -- 0 is page 1, 10 is page 2, 20 is page 3, etc
        // if page is not set
        if($page == NULL){
            $page = 0;
        }
    
        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://serpapi.com/search?api_key=a0c288c1871c52314428241b43c02d0ec6a55df9e90ccdf02c294d877b96968b&engine=google&location=london&gl=uk&q='.urlencode($page_keyword).'&start='.$page,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            // CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
        ));
    
        $response = curl_exec($curl);
        $result   = json_decode($response, true);
    
        curl_close($curl);

        return $result;
    }

    /*
     * CHECK YOUR URL'S GOOGLE SEARCH ENGINE POSITION BY KEYWORD
     * -- https://serpapi.com/search-api
     *
     * @param string $page_keyword
     * @param string $url
     * @param int $offset
     * 
     * @return array
     * 
     */
    public function get_position_by_keyword($keyword, $url){

        // get the results by using serpapi
        $result = $this->get_top_sites_by_keywords($keyword);

        /* echo "<pre>";
        var_dump($keyword);
        var_dump($url);
        var_dump($result);
        echo "</pre>";
        die(); */

        // page offset -- 0 is page 1, 10 is page 2, 20 is page 3, etc
        $page_offset = 0;

        // 
        $data = array();
        
        // check if no results
        if(!$result["error"]){

            // regex remove http or https from the url
            $url = preg_replace('#^https?://#', '', $url);
            // remove trailing slash
            $url = rtrim($url, '/');
            // remove www
            $url = preg_replace('/^www\./', '', $url);
            
            // check if there are results
            $position_found = $this->find_position($result, $url);

            
            // adjust page offset
            if($position_found == false){

                // 100 is equal to 10 pages
                while($page_offset < 100){

                    // add 10 to the page offset
                    $page_offset += 10;

                    // get the results by using serpapi
                    $result = $this->get_top_sites_by_keywords($keyword, $page_offset);

                    // check if there are results
                    $position_found = $this->find_position($result, $url);

                    // if position found
                    if($position_found != false){

                        // return the position
                        return $position_found;

                        break;
                    }
                }

                /* echo "<pre>";
                var_dump($position_found);
                var_dump($url);
                var_dump($page_offset);
                echo "</pre>";
                die();  */

            } else {
                return $position_found;
            }
        } else {

            // return the error
            return array("error" => "Data can't be found.");
        }
    }

    /*
     * FIND THE POSITION OF YOUR URL IN GOOGLE SEARCH ENGINE
     * 
     * @param array $data
     * @param string $url
     * 
     * @return array || boolean 
     * 
     */
    function find_position($data, $url){

        // check if there are results
        $validation = [];

        // loop through the organic results
        foreach($data['organic_results'] as $key => $value){

            // check if the url is found is in the link
            if(strpos($value['link'], $url) !== false){

                // return the data if found
                return array(
                    "position" => $value["position"],
                    "link" => $value["link"],
                    "search_page_number" => $data["search_information"]["page_number"] ?? 1, //page number -- this is the search engine page number
                    "search_page_offset" => $data["search_parameters"]["start"] // page offset -- 0 is page 1, 10 is page 2, 20 is page 3, etc
                );

                // break the loop
                break;
            } else {
                    
                // add to the validation array
                $validation[] = false;
            }
        }

        // check if the validation has false or if the array is empty
        if(in_array(false, $validation) || empty($validation)){

            // return false
            return false;
        }
    }

	// get page word count inside body tag without script tags and style tags
	function page_word_count($page_link = NULL){

        // check if page link is not empty
        if($page_link == NULL){
            return false;
        }
		// $page_content = file_get_contents($page_link);
        $page_content = file_get_contents($page_link, false, stream_context_create(
            array("http" => array("user_agent" => "any"))
        ));
		$page_content = str_replace(array("\n", "\r", "\t"), '', $page_content);
		$page_content = preg_replace('/<script(.*?)<\/script>/is', '', $page_content);
		$page_content = preg_replace('/<style(.*?)<\/style>/is', '', $page_content);
		$page_content = preg_replace('/<!--(.*?)-->/is', '', $page_content);
		$page_content = preg_replace('/<(.*?)>/is', '', $page_content);
		$page_content = preg_replace('/\s\s+/', ' ', $page_content);
		$page_content = preg_replace('/\s+/', ' ', $page_content);
		return str_word_count($page_content);
	}
}

// add htaccess to newly created folder with the correct permissions
function writeht($domain, $folder){
    $fp = fopen($folder.'/.htaccess','a+');
    if($fp){
        // check if the htaccess already exists
        $htaccess = file_get_contents($folder.'/.htaccess');

        // 
        if(strpos($htaccess, 'options +indexes') === false){
            fwrite($fp,'options +indexes');
            fclose($fp);
        }
    }
}

// add custom css for admin
add_action('admin_head', 'custom_admin_css');
function custom_admin_css() {
    echo '<style>
        .duplicator-pro-admin-notice{display: none;}
    </style>';
}

// encode decode oauth state url
function base64UrlEncode($inputStr){
    return strtr(base64_encode($inputStr), '+/=', '-_,');
}
function base64UrlDecode($inputStr){
    return base64_decode(strtr($inputStr, '-_,', '+/='));
}

// Start session on init hook.
// add_action( 'init', 'wpse16119876_init_session' );
function wpse16119876_init_session() {
    if ( ! session_id() ) {
        session_start();
    }
}


/*
 * PREPOPULATE KEYWORD REPORT GENERATOR FORM
 * 
 */
add_filter( 'gform_pre_render', 'populate_choices' );
//Note: when changing choice values, we also need to use the gform_pre_validation so that the new values are available when validating the field.
add_filter( 'gform_pre_validation', 'populate_choices' );
//Note: when changing choice values, we also need to use the gform_admin_pre_render so that the right values are displayed when editing the entry.
add_filter( 'gform_admin_pre_render', 'populate_choices' );
//Note: this will allow for the labels to be used during the submission process in case values are enabled
add_filter( 'gform_pre_submission_filter', 'populate_choices' );
function populate_choices( $form ) {
 
    //only populating drop down for specific form
    if ( $form['id'] != 19 && $form['id'] != 20 ) {
       return $form;
    }

    // past 2 months
    $past_2_months = date("F Y", strtotime("-2 month"));

    // last month w/ year
    $last_month = date("F Y", strtotime("-1 month"));

    // current month
    $current_month = date("F Y");

    // next month
    // $next_month = date("F Y", strtotime("+1 month"));
    $next_month = date("F Y", strtotime("last day of next month"));
    
    // 
    $dates = [];

    // 
    $dates[] = array(
        'value' => $past_2_months,
        'text' => $past_2_months
    );
    $dates[] = array(
        'value' => $last_month,
        'text' => $last_month
    );
    $dates[] = array(
        'value' => $current_month,
        'text' => $current_month
    );
    $dates[] = array(
        'value' => $next_month,
        'text' => $next_month
    );
 
    //Adding items to field
    foreach ( $form['fields'] as &$field ) {

		// gender
		if ( $field->id == 13 ) {
			$field->choices = $dates;
		}
    }
 
    return $form;
}

/*
 * GFROM CONFIRMATION MESSAGE
 * - SEO STRATEGY FORM 17 & 18
 * 
 */
add_filter( 'gform_confirmation', 'custom_confirmation_message', 10, 4 );
function custom_confirmation_message( $confirmation, $form, $entry, $ajax ) {
    if ( ! is_string( $confirmation )  ) {
        return $confirmation;
    }

    // GET FORM ID
    $form_id = $form['id'];

    // CHECK IF FORM ID IS 17 OR 18
    if($form_id == 17 || $form_id == 18){

        ob_start();

        // GET ENTRY ID
        $entry_id = $entry['id'];
        // 
        $strategyData = gform_get_meta($entry_id, 'seo_strategy');

        // dd($entry);
        // dd($strategyData);
?>
        <div class="bg-white p-3 mb-3 border border-orange">
            <div class="text fw-medium">You can access the loaded todo list here.</div>
            <a class="btn btn-orange small-text d-inline-block mt-2" href="/seo-manager/todos/list/?eid=<?php echo $entry_id; ?>">View Todo List</a>
        </div>

        <?php 
        if($strategyData['keyword_data']){

            $keywords = $strategyData['keywords'];
            foreach($strategyData['keyword_data'] as $key => $data){
        ?>
                <!-- <br><br> -->
                <div class="table-wrap">
                    <div class="text fw-bold mt-4 mb-2">Keyword: "<?php echo $data['keyword']; ?>" Top 3 Competitor Data</div>
                    <table class="metric-table table bg-white">
                        <thead>
                            <tr>
                                <th class="text fw-medium">Competitor URL</th>
                                <th class="text fw-medium">Word Count</th>
                                <th class="text fw-medium">Headings</th>
                                <th class="text fw-medium">Paragraphs</th>
                                <th class="text fw-medium">Images</th>
                                <th class="text fw-medium">Domain Authority</th>
                                <th class="text fw-medium">Backlinks</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php

                                // average data
                                $average_data = [];
                                

                                // loop through the sites
                                foreach($data['data'] as $key => $site_data){


                                    // reset array
                                    $headings = [];
                                    $check_empty = [];
                                    
                                    // site data
                                    $page_link      = $site_data['page_link'];
                                    $page_wc = $site_data['word_count'];
                                    $page_da = $site_data['domain_authority'];
                                    $page_backlinks = $site_data['backlinks'];
                                    $page_p = $site_data['p'];
                                    $page_img = $site_data['img'];
                                    
                                    // add to headings array
                                    $headings[] += $site_data['h1'];
                                    $headings[] += $site_data['h2'];
                                    $headings[] += $site_data['h3'];
                                    $headings[] += $site_data['h4'];
                                    $headings[] += $site_data['h5'];
                                    $headings[] += $site_data['h6'];
                                    
                                    // check if not crawled
                                    $check_empty[] += array_sum($headings);
                                    $check_empty[] += $page_p;
                                    $check_empty[] += $page_img;
                                    $check_empty[] += $page_wc;
                                    
                                    // populate avarage data
                                    $average_data['headings'][] += array_sum($headings);
                                    $average_data['p'] [] += $page_p;
                                    $average_data['img'][]+= $page_img;
                                    $average_data['wc'][] += $page_wc;
                                    $average_data['da'][] += $page_da;
                                    $average_data['bl'][] += $page_backlinks;
                            ?>
                                    <tr>
                                        <td class="small-text fw-medium"><?php echo $page_link; ?></td>
                                        <?php if(array_sum($check_empty) > 0){ ?>
                                            <td class="small-text fw-medium"><?php echo $page_wc; ?></td>
                                            <td class="small-text fw-medium"><?php echo array_sum($headings); ?></td>
                                            <td class="small-text fw-medium"><?php echo $page_p; ?></td>
                                            <td class="small-text fw-medium"><?php echo $page_img; ?></td>
                                        <?php } else { ?>
                                            <td colspan="4" style="text-align:center;">Page can't be crawled</td>
                                        <?php } ?>
                                        <td class="small-text fw-medium"><?php echo $page_da; ?></td>
                                        <td class="small-text fw-medium"><?php echo number_format($page_backlinks, 2); ?></td>
                                    </tr>
                            <?php } ?>

                            <!-- average data -->
                            <tr style="background: rgba(0,0,0,0.1);">
                                <td class="small-text fw-bold">Average:</td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'wc'); ?></td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'headings'); ?></td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'p'); ?></td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'img'); ?></td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'da'); ?></td>
                                <td class="small-text fw-bold"><?php echo getAverageData($average_data, 'bl'); ?></td>
                            </tr>
                            <!-- !end average row -->

                            <!--  -->
                            <?php 
                            if($data['own_data']){
                                $own_data = $data['own_data'];
                                $headings[] += $own_data['h1'];
                                $headings[] += $own_data['h2'];
                                $headings[] += $own_data['h3'];
                                $headings[] += $own_data['h4'];
                                $headings[] += $own_data['h5'];
                                $headings[] += $own_data['h6'];
                            ?>
                                <?php //$own_data_content = getLinkData($own_data["link"]); ?>
                                <tr class="orange">
                                    <th class="text fw-medium">Your Url</th>
                                    <th class="text fw-medium">Word Count</th>
                                    <th class="text fw-medium">Headings</th>
                                    <th class="text fw-medium">Paragraphs</th>
                                    <th class="text fw-medium">Images</th>
                                    <th class="text fw-medium">Domain Authority</th>
                                    <th class="text fw-medium">Backlinks</th>
                                </tr>
                                <tr>
                                    <td class="small-text fw-medium">(<strong><?php echo $own_data["position"] ?></strong>) <?php echo $own_data["page_link"]; ?></td>
                                    <td class="small-text fw-medium"><?php echo $own_data["word_count"]; ?></td>
                                    <td class="small-text fw-medium"><?php echo array_sum($headings); ?></td>
                                    <td class="small-text fw-medium"><?php echo $own_data["p"]; ?></td>
                                    <td class="small-text fw-medium"><?php echo $own_data["img"]; ?></td>
                                    <td class="small-text fw-medium"><?php echo $own_data["domain_authority"]; ?></td>
                                    <td class="small-text fw-medium"><?php echo $own_data["backlinks"]; ?></td>
                                </tr>
                            <?php } ?>
                        </tbody>
                    </table>
                </div>
            <?php } ?>
        <?php } ?>
<?php
        $confirmation = ob_get_clean();

    } //

    return $confirmation;
}

/*
 * GRAVITYFORM LOADER
 * 
 */
add_filter( 'gform_ajax_spinner_url', '_spinner_url', 10, 2 );
function _spinner_url( $image_src, $form ) {
    return get_stylesheet_directory_uri()."/assets/images/loader.gif";
}

/*
 * TOOLS: CONTENT READABILITY
 * 
 */
class Content_Readability{

    // 
    public $data;

    //
    public $url;

    /*
     * GET THE COMPILED READABILITY DATA
     * 
     * return array
     * 
     */
    public function check_readability($url){
        
        // get content
        // $content = $this->get_content($url);
        $content = file_get_contents($url, false, stream_context_create(
            array("http" => array("user_agent" => "any"))
        ));

        // 
        $content = str_replace(array("\n", "\r", "\t"), '', $content);
		$content = preg_replace('/<script(.*?)<\/script>/is', '', $content);
		$content = preg_replace('/<style(.*?)<\/style>/is', '', $content);
		// $content = preg_replace('/<!--(.*?)-->/is', '', $content);
		// $content = preg_replace('/<(.*?)>/is', '', $content);
		// $content = preg_replace('/\s\s+/', ' ', $content);
		// $content = preg_replace('/\s+/', ' ', $content);
        // $content = strip_tags($content);
        // $content = preg_replace("/[^a-zA-Z0-9\s]/", "", $content);
        // $content = strtolower($content);

        // 
        $word_count = str_word_count($content);
        $sentence_count = preg_match_all("/[^\.!?]+[\.!?]+/", $content, $matches);
        $syllable_count = 0;
        $words = str_word_count($content, 1);

        // 
        foreach ($words as $word) {
            $syllables = $this->syllable_count($word);
            $syllable_count += $syllables;
        }

        // Calculate the average number of words per sentence
        $avg_words_per_sentence = $word_count / $sentence_count;

        // Calculate the average number of syllables per word
        $avg_syllables_per_word = $syllable_count / $word_count;

        // Calculate the Flesch-Kincaid Reading Ease score
        $flesch_kincaid_reading_ease = $this->flesch_kincaid_reading_ease($word_count, $sentence_count, $syllable_count);

        // Calculate the Flesch-Kincaid Grade Level
        $flesch_kincaid_grade_level = $this->flesch_kincaid_grade_level($word_count, $sentence_count, $syllable_count);

        // build data
        $data = array(
            'word_count' => $word_count,
            'sentence_count' => $sentence_count,
            'syllable_count' => $syllable_count,
            'avg_words_per_sentence' => $avg_words_per_sentence,
            'avg_syllables_per_word' => $avg_syllables_per_word,
            'flesch_kincaid_reading_ease' => $flesch_kincaid_reading_ease,
            'flesch_kincaid_grade_level' => $flesch_kincaid_grade_level
        );

        // 
        return $data;
    }

    // get website content
    private function get_content($url){
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        $content = curl_exec($ch);
        curl_close($ch);

        return $content;
    }

    // Function to calculate the Flesch-Kincaid Reading Ease score
    private function flesch_kincaid_reading_ease($word_count, $sentence_count, $syllable_count) {
        $score = 206.835 - (1.015 * ($word_count / $sentence_count)) - (84.6 * ($syllable_count / $word_count));
        return $score;
    }

    // Function to calculate the Flesch-Kincaid Grade Level
    private function flesch_kincaid_grade_level($word_count, $sentence_count, $syllable_count) {
        $score = 0.39 * ($word_count / $sentence_count) + 11.8 * ($syllable_count / $word_count) - 15.59;
        return $score;
    }

    // Function to count the syllables in a word
    private function syllable_count($word) {
        $syllables = 0;
        $vowels = "aeiou";
        $word = strtolower($word);
        if (strlen($word) <= 3) {
            return 1;
        }
        $word = preg_replace("/[^$vowels]/", "", $word);
        $syllables = strlen($word);
        $syllables = $syllables / 2;
        $syllables = floor($syllables);
        return $syllables;
    }
}

/*
 * SAVE WEBSITE TO USER WEBSITE META
 * 
 * @param string $website
 * @param int $user_id
 * 
 * @return array || Boolean
 */
function saveUserWebsite(string $website = '', $user_id = ''){

    // CHECK IF WEBISTE IS EMPTY
    if(!$website){
        return false;
    }
    
    // CHECK IF USER ID IS PROVIDED
    if(!$user_id){
        // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
        $user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
        // IF EMPTY, GET THE CURRENT USER ID
        $user_id = $user_id ? $user_id : get_current_user_id();
    }

    // GET LIST OF WEBSITES
    $user_websites = get_user_meta( $user_id, '_user_websites', true );
    // CHECK IF LIST IS EMPTY
    $user_websites = $user_websites ? $user_websites : array();
    
    // REMOVE HTTPS, HTTP AND TRAILING SLASH
    $website = preg_replace('#^https?://#', '', rtrim($website,'/'));
    // REMOVE TRAILIN SPACE
    $website = rtrim($website,' ');

    // CHECK IF WEBSITE IS ALREADY IN THE LIST
    if(in_array($website, $user_websites)){
        return false;
    } else {
        // ADD WEBSITE TO THE LIST
        $user_websites[] = $website;
        // SAVE THE LIST
        update_user_meta( $user_id, '_user_websites', $user_websites );
        // RETURN THE LIST
        return $user_websites;
    }
}

/*
 * GET AVERAGE DATA
 * 
 */
function getAverageData($data = NULL, $key = NULL) {
    
    // check if $data is not empty
    if($data && $key){

        // remove empty values
        // $data[$key] = array_filter($data[$key]);

        // get average data
        $average_data = array_sum($data[$key]) / count($data[$key]);

        // decimal count 2
        // return number_format($average_data, 2);
        return number_format($average_data);
    } else {

        // return 0
        return false;
    }
}

/*
 * BUILD THE SERVICES FOR THE TODO LIST
 * 
 */
function buildServices($user_email = NULL, $entry_id = NULL){
    
    if(!$user_email || !$entry_id){
        return [];
    }

    // SET THE SERVICES IN THE TODO LIST
    $services = [];

    $services[] = array(
        "To Do"    => "Site Speed Optimisation",
        "Info"     => "Optimise site load speed. We have optimised images by reducing file size and other unnecessary files to improve your site's load speed.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Content Creation and Optimisation",
        "Info"     => "Created new content and optimised for the chosen keywords to beat the competition.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Supporting Content Marketing",
        "Info"     => "We created a new supporting blog post linking to the main sales page. 

        Creating a new blog post that answers people's questions about your product and services shows search engines that you are a good source of information on the topic. These posts will also drive targeted traffic to your sales pages.
        ",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Blogger Outreach",
        "Info"     => "We reached out to relevant high-domain authority blogs and secured guest posts with powerful links to your site and content.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Authority Mini Sites",
        "Info"     => "We create mini blog sites on high-domain Authority blogging platforms to build multiple backlinks with random anchor texts. These help build a natural backlink and anchor text profile.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Rich Media Citations",
        "Info"     => "We have created media content, including a company video clip and audio files and will distribute them on high-domain authority media sites, including backlinks to your site and content.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "GMB Optimisation",
        "Info"     => "We have optimised your Google My Business page for your top keywords. 

        To take full advantage of your GMB page, it is essential to be active, collect recommendations, answer messages, and upload optimised images to your profile.
        ",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Local Citation Building",
        "Info"     => "We have hand-created high-quality citations. Consistent and up-to-date citations are one of local SEO's most important ranking factors. They build trust with the search engines that you are a well-established trading business.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );
    $services[] = array(
        "To Do"    => "Local Link Building",
        "Info"     => "Local link building is a powerful way to build authority with the search engine and rank for your local keywords. We have created local mini-sites with relevant local information linking to your site, GMB page, and top citations. Links from locally relevant content tell the search engine you are part of the local community and build trust.",
        "Comments" => "",
        "Status"   => "on-going",
        "Client"   => $user_email,
        "Entry"    => $entry_id
    );

    return $services;
}


/*
 * VARDUMP FUNCTION
 */
function dd($data){
    echo '<pre>';
    var_dump($data);
    echo '</pre>';
}

/**
* Auto login after registration if not logged in.
*/

add_action( 'gform_user_registered', 'tme_gravity_registration_autologin', 10, 4 );
function tme_gravity_registration_autologin( $user_id, $user_config, $entry, $password ) {
	$user = get_userdata( $user_id );
	$user_login = $user->user_login;
	$user_password = $password;

    wp_signon( array(
            'user_login' => $user_login,
            'user_password' =>  $user_password,
            'remember' => false
    ) );
}
/* this is needed for the auto auto login */
add_filter( 'gform_is_feed_asynchronous', function ( $is_asynchronous, $feed ) {
    if ( ! $is_asynchronous || rgar( $feed, 'addon_slug' ) !== 'gravityformsuserregistration' ) {
        return $is_asynchronous;
    }
 
    return gf_user_registration()->is_update_feed( $feed ) ? $is_asynchronous : false;
}, 10, 2 );


// FILTER WEBSITE URL
function filterWebsiteUrl($url = null){

    if(!$url){
        return false;
    }

    $website = parse_url($url);
    // GET HOSTNAME
    $website = $website['host'] ?? $website['path'];
    // REMOVE WWW
    $website = str_replace('www.', '', $website);
    // REMOVE sc:domain:
    $website = str_replace('sc:domain:', '', $website);
    // REMOVE TRAILING SLASH
    $website = rtrim($website, '/');

    /* $url = $_SERVER['REQUEST_URI'];
    $url = explode('?', $url);
    $url = $url[0]; */
    return $website;
}

function custom_seo_feed_shortcode() {
    $feed_1 = 'https://ahrefs.com/blog/feed'; // Replace with the RSS feed URL you want to use
    $feed_2 = 'https://moz.com/posts/rss/blog'; 

    $rss1 = fetch_feed($feed_1);
    $rss2 = fetch_feed($feed_2);

    if (!is_wp_error($rss1) && !is_wp_error($rss2)) {
        $max_items1 = $rss1->get_item_quantity(4); // Adjust the number of items to display
        $rss_items1 = $rss1->get_items(0, $max_items1);
        $max_items2 = $rss2->get_item_quantity(4); // Adjust the number of items to display
        $rss_items2 = $rss2->get_items(0, $max_items2);
        $rss_items = array_merge($rss_items1, $rss_items2);
        // randomize the array
        shuffle($rss_items);
        // max 5
        $rss_items = array_slice($rss_items, 0, 5);

        ?>
        <div class="col-12 col-lg-6">
            <table class="table bg-white">
                <thead>
                    <tr>
                        <th class="text fw-medium">Latest SEO News</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($rss_items as $item) { ?>
                        <tr>
                            <td class="text">
                                <a href="<?php echo esc_url($item->get_permalink()); ?>"><?php echo esc_html($item->get_title()); ?></a>
                            </td>
                        </tr>
                    <?php } ?>
                </tbody>
            </table>
        </div>
        <?php
    }
}
add_shortcode('seo_feed', 'custom_seo_feed_shortcode');

/*
 * GO HIGH LEVEL API
 * 
 * @param array $contact_data
 * 
 */
function addGoHighLevelContact($contact_data){

    // CHECK IF CONTACT DATA IS NOT EMPTY
    if(!$contact_data){
        return false;
    }
    
    // API KEY - SETTINGS -> BUSINESS PROFILE -> API KEY
    $api_key = "eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJsb2NhdGlvbl9pZCI6IkZFamhnZ3k1RTBaS0VUT2lWVnRsIiwiY29tcGFueV9pZCI6Im9sY1NueEIzTExTR0NQYTk3S2J1IiwidmVyc2lvbiI6MSwiaWF0IjoxNzAwMDM5MzU0OTExLCJzdWIiOiJ1c2VyX2lkIn0.sb39f635NeUjiNyZyth4bV78udtunvSXE3ywq8qqUaw";
		
    // API ENDPOINT
    $endpoint = 'https://rest.gohighlevel.com/v1/contacts/';

    // Send the data to GoHighLevel using WordPress HTTP API
    $response = wp_remote_post( $endpoint, array(
        'method'      => 'POST',
        'timeout'     => 45,
        'redirection' => 5,
        'httpversion' => '1.0',
        'blocking'    => true,
        'headers'     => array(
            'Content-Type' => 'application/json',
            'Accept' => 'application/json',
            'Authorization' => 'Bearer ' . $api_key
        ),
        'body'        => json_encode($contact_data),
        'cookies'     => array()
    ) );
}