<?php 
if ( !defined( 'ABSPATH' ) ) {
	exit;
}

// REQUIRE CONFIG FILE
require_once(ABSPATH . 'wp-content/themes/thrive-theme-child/includes/google/google-config.php');

// GOOGLE SEARCH CONSOLE CLASS & METHODS
class GOOGLE_SEARCH_CONSOLE extends SEOI {
    
	/*
	 * Get Site List
	 * 
	 * @param string $user_id -- the user_id is where the google token is saved in the user meta
	 * @param string $customer_id
	 */
	public function siteList($user_id = NULL, $customer_id = NULL){

		// Validate user 
		if($this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id)){

			// Get site list
			return $this->getSiteList($user_id, $customer_id);
		} else {

			return false;
		}
	}

	/*
	 * Get Site Data
	 * 
	 * @param string $site_url
	 * @param string $user_id == $manager_id
	 * @param string $customer_id
	 */
	public function siteData($site_url = NULL, $user_id = NULL, $customer_id = NULL, $inner = NULL){

		if(!$user_id && !$customer_id){
			return false;
		}

		
		// Validate user
		// return $this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id);
		/* return array(
			'user_id' => $user_id
		); */
		
		if($this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id)){
			
			
			// GET THE SAVED SITE DATA
			$site_data = get_user_meta( $customer_id, 'google_site_data', true );

			// IF INNER
			if($inner){
				// GET THE INNER SITE DATA
				// $site_data = $site_data['pages'][$inner];
				if($siteData['pages']){
                    foreach($siteData['pages'] as $key => $tracked_page){
                        if($inner == $tracked_page['site']){
                            // SET SITE DATA
                            $site_data = $tracked_page;
                        }
                    }
                }
			}

			/* return array(
				'inner' => $inner,
				'site_data' => $site_data
			); */

			// check if site data exists and return the already generated data
			// if( $site_data && $site_data['last_month'] != NULL && !$site_data['last_month']['error'] && $site_data['site'] == $site_url ){
			if( $site_data && $site_data['last_month'] != NULL && !$site_data['last_month']['error'] ){

				// Get date generated
				$date_generated = $site_data['date_generated'];
				// date for testing !remove if not needed - yyyy-mm-dd
				// $date_generated = '2023-05-25';

				

				// check if date generated is today
				if( $date_generated == date('Y-m-d') ){

					// return
					// return $this->compareSiteData( $site_data );
					return $site_data;
				} else {

					

					// generate new data
					$data = $this->generateSiteData( $site_url, $user_id, $customer_id, $inner );

					/* return array(
						'inner' => $inner,
						'date_generated' => $date_generated,
						'site_data' => $data,
					);  */

					// return
					return $data;
					// return $this->compareSiteData( $data );
				}
			} else { // generate new data

				// generate new data
				$data = $this->generateSiteData( $site_url, $user_id, $customer_id, $inner );

				// return
				return $data;
				// return $this->compareSiteData( $data );
			}
		} else {
			return false;
		}
	}

	/*
	 * Validate if the website exists in the user's Google Search Console site list
	 * 
	 * @param string $website
	 * @param string $user_id
	 * @param string $customer_id
	 * 
	 */
	public function validateUserSite( $website = NULL, $user_id = NULL, $customer_id = false ){

		// return 
		// run the validate user method
		// return $this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id);
		// $this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id);

		// Validate user
		if($this->validateUser('', 'GOOGLE_SEARCH_CONSOLE', $user_id)){
			if($website && $user_id && $customer_id){

				// Get site list
				$site_list = $this->getSiteList($user_id, $customer_id);

				// dd($site_list);
				// return $site_list;
				
				// 
				// $website_url = false;

				// ob_start();

				// check if the order website url is in the list of website urls
				if ($website && $site_list != false) {

					
					/* $website = parse_url(rtrim(str_replace("www.", "", $website), "/"));
					$website = $website["host"] ? $website["host"] : $website["path"]; */

					// REMOVE HTTPS, HTTP AND TRAILING SLASH
					// $website = preg_replace('#^https?://#', '', rtrim($website,'/'));
					
					// REMOVE TRAILIN SPACE
					// $website = rtrim($website,' ');

					// GET BASE URL OF THE WEBSITE
					$website = parse_url($website);
					// GET HOSTNAME
					$website = $website['host'] ?? $website['path'];
					// REMOVE WWW
					$website = str_replace('www.', '', $website);

					/* return array(
						'website' => $website,
						'site_list' => $site_list
					); */


					
					// loop through the search console site list
					foreach ($site_list as $key => $site) {

						
						// check if the order website url exists in the site_list
						if (strpos($site["siteUrl"], $website) !== false) {
						// if (strpos($site, $website) !== false) {

							// check permission
							if($site["permissionLevel"] == "siteOwner" || $site["permissionLevel"] == "siteFullUser"){

								// google search console api requires the site url specified in the site list
								$website_url = urlencode($site["siteUrl"]);
							}
						}
					}

					return $website_url;
				} elseif($site_list['error']) {

					// RESET TOKENS - return false
					return $this->resetMetaTokens();

					// return false;

				} else {
					
					return false;
				}

			} else {

				// return "false";
				return false;
			}
		} else {

				// return "false";
				return false;
		}
	}

	/*
	 * Get Site List
	 * - Get list of sites from Google Search Console
	 * - MATCH THE SITE LIST FROM YOUR EXISTING _user_websites and only return the matched sites
	 * 
	 * @param string $user_id
	 * @param string $customer_id
	 * 
	 */
	public function getSiteList($user_id = NULL, $customer_id = NULL){

		if(!$user_id){
			return false;
		}

		/* // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
		$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
		// IF EMPTY, GET THE CURRENT USER ID
		$user_id = $user_id ? $user_id : get_current_user_id(); */

		// GET THE ACCESS TOKEN FROM THE SEO MANAGER OF THE CUSTOMER
		$token_access = get_user_meta( $user_id, 'google_token_access', true );

		/* return array(
			'user_id' => $user_id,
			'customer_id' => $customer_id,
			'token_access' => $token_access
		); */

		// Set up the HTTP headers with the access token
		$headers = array(
			"Authorization" => "Bearer ".$token_access,
			"Content-Type" => "application/json"
		);

		// Send the GET request to the API endpoint using wp_remote_post
		$response = wp_remote_post('https://searchconsole.googleapis.com/webmasters/v3/sites', array(
			"headers" => $headers,
			"method" => "GET"
		));

		// dd($response);
		// GET ERROR MESSAGE
		// $error_message = wp_remote_retrieve_response_message( $response );
		// GET CODE
		$response_code = wp_remote_retrieve_response_code( $response );
		// return $response_code;

		

		// Check for errors in the response
		if ($response_code != 200) {
			
			$error_message = wp_remote_retrieve_response_message( $response );
			return array(
				'code' => $response_code,
				'error' => true,
				'message' => $error_message
			);

			// Handle the error
			// return false;
		} elseif ($response_code == 200) {
			// ASSIGN THE RESPONSE TO A VARIABLE
			$site_list = json_decode( wp_remote_retrieve_body( $response ), true );
			// return $customer_id;
			// SAVE AND FILTER THE SITE LIST
			$site_list = $this->saveSiteList( $site_list, $customer_id );
			
			// Return
			return $site_list;
		} else {
			// Handle the error
			return false;

		}
	}

	/*
	 * SAVE THE SITE LIST TO THE CUSTOMER USER META
	 * 
	 * @param array $site_list
	 * @param string $user_id
	 * 
	 * @return array
	 */
	private function saveSiteList( $site_list = NULL, $user_id = NULL ){

		if(!$site_list && !$user_id){
			return false;
		}

		/* // GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
		$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
		// IF EMPTY, GET THE CURRENT USER ID
		$user_id = $user_id ? $user_id : get_current_user_id(); */

		// GET LIST OF WEBSITES
		$user_websites = get_user_meta( $user_id, '_user_websites', true );
		// CHECK IF LIST IS EMPTY
		$user_websites = $user_websites ? $user_websites : array();

		/* dd($user_id);
		dd($user_websites); */

		// return $user_websites;

		//
		$website_list = [];

		// CHECK IF THE SITE LIST IS EMPTY
		if($site_list['siteEntry']){
			// LOOP THROUGH THE SITE LIST
			foreach($site_list['siteEntry'] as $key => $site_data){
				// SITE URL
				$url = $site_data['siteUrl'];
				// REMOVE HTTPS, HTTP AND TRAILING SLASH
				$site_url = preg_replace('#^https?://#', '', rtrim($url,'/'));
				// REMOVE TRAILIN SPACE
				$site_url = rtrim($site_url,' ');
				// REMOVE sc-domain:
				$site_url = str_replace('sc-domain:', '', $site_url);
				
				// dd($site_url);
				// LOOP THROUGH THE USER WEBSITE LIST
				foreach($user_websites as $key => $user_website){
					// CHECK STRING POSITION
					if(strpos($user_website, $site_url) !== false){
						// CHECK IF SITE DATA IS IN THE WEBSITE LIST
						if(!in_array($site_data, $website_list)){
							// ADD TO THE WEBSITE LIST
							$website_list[] = $site_data;
						}
					}
				}
				/* if(in_array($site_url, $user_websites)){
					// ADD TO THE WEBSITE LIST
					$website_list[] = $site_data;
				} */
			}
		}

		// dd($website_list);
			// die();

		// SAVE THE SITE LIST
		update_user_meta( $user_id, 'google_search_console_site_list', $website_list );

		return $website_list;
	}

	/*
	 * Get Site Data
	 * 
	 */
	public function getSiteData( $site_url = NULL, $start_date = NULL, $end_date = NULL, $row_limit = NULL, $user_id = NULL, $startRow = 0, $inner = NULL ){

		// Set the API endpoint for the searchanalytics endpoint
		$api_endpoint = "https://www.googleapis.com/webmasters/v3/sites/{siteUrl}/searchAnalytics/query"; 

		// Get access token
		$token_access = get_user_meta( $user_id, 'google_token_access', true );

		// Set up the HTTP headers with the access token
		$headers = array(
			"Authorization" => "Bearer ".$token_access,
			"Content-Type" => "application/json"
		);

		// Set up the request body with the site's URL and other parameters
		$request_body = array(
			"startDate"  => $start_date, // yyyy-mm-dd
			"endDate"    => $end_date, // yyyy-mm-dd
			"dimensions" => array("query"),
			"searchType" => "web",
			"rowLimit"   => $row_limit,
			"startRow"   => $startRow,
			"dimensionFilterGroups" => array(
				array(
					"filters" => array(
						array(
							"dimension"  => "country",
							"expression" => "gbr"
						)
					)
				)
			)
		);
		

		// IF INNER ADD PAGE FILTER OR CHECK FOR THE MAIN SITE
		$sanitized_site_url = str_replace('sc-domain:', 'https://', $site_url);
        // add trailing slash
        $sanitized_site_url = rtrim($sanitized_site_url, '/').'/';
		$inner = $inner ? $inner : $sanitized_site_url;
		if($inner){
			// ADD PAGE FILTER TO FILTERS
			$request_body['dimensionFilterGroups'][0]['filters'][] = array(
				"dimension"  => "page",
				"expression" => $inner
			);
		}

		// CHECK IF SITE URL HAS HTTPS
		if(strpos($site_url, 'https://') !== false){
			// URL ENCODE THE SITE URL
			$site_url = urlencode($site_url);
		}

		// Replace {siteUrl} in the API endpoint with the site's URL
		$api_endpoint = str_replace("{siteUrl}", $site_url, $api_endpoint);

		// Send the POST request to the API endpoint using wp_remote_post
		$response = wp_remote_post($api_endpoint, array(
			"headers" => $headers,
			"method" => "POST",
			"body" => json_encode($request_body)
		));

		// get response code
		$response_code = wp_remote_retrieve_response_code( $response );
		// Retrieve the headers from the response
		// $response_headers = wp_remote_retrieve_headers($response);
		// Retrieve the body of the response
		$response_body = wp_remote_retrieve_body($response);
		// build the response
		/* $response_return = array(
			'code' => $response_code,
			'headers' => $response_headers,
			'body' => $response_body,
			'start_row' => $startRow,
		); */

		if ($response_code == 404) {

			// Handle the error
			return false;
		} else {

			// Return
			return json_decode( $response_body, true );
			// return $response_return;
		}
	}

	/*
	 * Generate Site Data
	 * 
	 * @param string $site_url
	 * @param string $user_id
	 * @param string $customer_id
	 */
	public function generateSiteData( $site_url = NULL, $user_id = NULL, $customer_id = NULL, $inner = NULL ){

		/* // get last month first day
		$start_date = date('Y-m-d', strtotime('first day of last month'));
		// get last month last day
		$end_date = date('Y-m-d', strtotime('last day of last month'));
		// get 2 months ago first day
		$start_date_2 = date('Y-m-d', strtotime('first day of last month -1 month'));
		// get 2 months ago last day
		$end_date_2 = date('Y-m-d', strtotime('last day of last month -1 month')); */

		// GET DATES
        $end_date = strtotime('yesterday');
        $start_date = strtotime('30 days ago', $end_date);
        $end_date_2 = strtotime('yesterday', $start_date);
        $start_date_2 = strtotime('31 days ago', $end_date_2);
        // GET FORMATTED DATES
		$start_date = date('Y-m-d', $start_date);
		$end_date = date('Y-m-d', $end_date);
		$end_date_2 = date('Y-m-d', $end_date_2);
		$start_date_2 = date('Y-m-d', $start_date_2);

		// 
		$data = [];
				
		// add site url
		$data['site'] = $inner ? $inner : $site_url;
		// add date generated day with time
		$data['date_generated'] = date('Y-m-d H:i:s');

		// GET LAST MONTH DATA
		// $data['last_month'] = $this->getSiteData( $site_url, $start_date, $end_date, 500, $user_id ); // original
		$lastMonthStartRow = 0;
		$lastMonthData = $this->getSiteData( $site_url, $start_date, $end_date, 100, $user_id, $lastMonthStartRow, $inner );

		/* return array(
			'start_date' => $start_date,
			'end_date' => $end_date,
			'last_month' => $lastMonthData,
		);
 */
		// do loop if rows is less than or equal to 100
		if($lastMonthData['rows']){
			while(count($lastMonthData['rows']) == 100){
				// ADD 100 TO THE START ROW
				$lastMonthStartRow += 100;
				// GET THE NEXT 100 ROWS OF DATA
				$lastMonthDataLoop = $this->getSiteData( $site_url, $start_date, $end_date, 100, $user_id, $lastMonthStartRow, $inner );
				// ADD THE NEW DATA TO THE EXISTING ROWS DATA
				$lastMonthData['rows'] = array_merge($lastMonthData['rows'], $lastMonthDataLoop['rows']);
			}
		}
		// RETURN LAST MONTH DATA
		$data['last_month'] = $lastMonthData;

		// GET 2 MONTHS AGO DATA
		// $data['2_months_ago'] = $this->getSiteData( $site_url, $start_date_2, $end_date_2, 500, $user_id ); // original
		$twoMonthsAgoStartRow = 0;
		$twoMonthsAgoData = $this->getSiteData( $site_url, $start_date_2, $end_date_2, 100, $user_id, $twoMonthsAgoStartRow, $inner );
		// do loop if rows is less than or equal to 100
		if($twoMonthsAgoData['rows']){
			while(count($twoMonthsAgoData['rows']) == 100){
				// ADD 100 TO THE START ROW
				$twoMonthsAgoStartRow += 100;
				// GET THE NEXT 100 ROWS OF DATA
				// ADD THE NEW DATA TO THE EXISTING ROWS DATA
				$twoMonthsAgoDataLoop = $this->getSiteData( $site_url, $start_date, $end_date, 100, $user_id, $twoMonthsAgoStartRow, $inner );
				$twoMonthsAgoData['rows'] = array_merge($twoMonthsAgoData['rows'], $twoMonthsAgoDataLoop['rows']);
			}
		}
		// RETURN 2 MONTHS AGO DATA
		$data['2_months_ago'] = $twoMonthsAgoData;

		// return $data;

		
		// COMPARE SITE DATA
		$data['data'] = $this->compareSiteData( $data );

		// CHECK IF INNER PAGE
		if($inner){
			// GET SAVED SITE DATA JUST FOR THE DATE AND SITE URL
            $siteData = get_user_meta( $customer_id, 'google_site_data', true );
			// CHECK IF INNER IS IN PAGES
			$is_inner = false;
			// CHECK IF PAGES IS SET
			if(!$siteData['pages']){
				// CREATE PAGES ARRAY
				$siteData['pages'] = [];
				// ADD DATA TO PAGES
				$siteData['pages'][] = $data;
			} else {

				// CHECK IF THE INNER PAGE IS IN THE PAGES
				foreach($siteData['pages'] as $key => $tracked_page){
					// CHECK IF INNER PAGE IS EQUAL TO THE TRACKED PAGE
					if($inner == $tracked_page['site']){
						// SET SITE DATA
						$siteData['pages'][$key] = $data;
					}
				} 
			}

			// SAVE THE SITE DATA
			$data = $siteData;
		}
		
		// SAVE THE SITE DATA
		update_user_meta( $customer_id, 'google_site_data', $data );


		// TRACKED PAGES / POWER PAGES
		// $trackedData[] = $data;
		// update_user_meta( $customer_id, 'google_tracked_pages', $data );

		// return
		return $data;
	}

	/*
	 * Compare Site Last Month & 2 Months Ago Data
	 * - return by position
	 * 
	 * @param $site_data
	 * @return array
	 */
	public function compareSiteData( $site_data = NULL ){

		// set current data
		$current_data = [];

		if( isset($site_data['last_month']) && isset($site_data['2_months_ago'])){

			
			if( isset($site_data['last_month']['rows']) && isset($site_data['2_months_ago']['rows'])){
				// 
				$current_data = $site_data['last_month']['rows'];
				$prev_data = $site_data['2_months_ago']['rows'];
	
				// insert past position to array if keyword exists
				foreach( $current_data as $key => $value ){
		
					$current_data[$key]['past_position'] = NULL;
		
					foreach( $prev_data as $prev_key => $prev_value ){
						if( $value['keys'][0] == $prev_value['keys'][0] ){
							$current_data[$key]['past_position'] = $prev_value['position'];
						}
					}
				}
			}
	
			// sort by position
			usort($current_data, fn($a, $b) => $a["position"] <=> $b["position"]);
		}


		// return
		return $current_data;
	}

	/*
	 * Save keyword data to user meta
	 * 
	 */
	public function saveKeywordData( $keyword = NULL, $position = NULL, $past_position = NULL, $site_url = NULL ){

		// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
		$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
		// IF EMPTY, GET THE CURRENT USER ID
		$user_id = $user_id ? $user_id : get_current_user_id();

		// get user meta
		$keyword_data = get_user_meta( $user_id, 'google_user_keyword_basket', true );

		// if keyword data is empty
		if( empty( $keyword_data ) ){

			// set keyword data to array
			$keyword_data = [];
			// $keyword_data[$site_url] = [];
		}

		// CHECK IF THE SITE URL EXISTS AS KEY
		if( !array_key_exists( $site_url, $keyword_data ) ){

			// ADD SITE URL AS KEY
			$keyword_data[$site_url] = [];
		}

		// return $keyword_data;

		// check if keyword exists
		if( array_key_exists( $keyword, $keyword_data[$site_url] ) ){

			// IF KEYWORD EXISTS REMOVE THE KEYWORD
			unset($keyword_data[$site_url][$keyword]);
			/* $keyword_data[$site_url][$keyword]['positions'][] = $past_position;
			$keyword_data[$site_url][$keyword]['positions'][] = $position;
			// update updated date
			$keyword_data[$site_url][$keyword]['updated'] = date('Y-m-d'); */
		} else {

			// add keyword to array
			$keyword_data[$site_url][$keyword] = array(
				'keyword'   => $keyword,
				'positions' => array($past_position, $position),
				'added'     => date('Y-m-d'),
				'updated'   => date('Y-m-d')
			);
		}

		// update user meta
		update_user_meta( $user_id, 'google_user_keyword_basket', $keyword_data );
	}
}