<?php
defined( 'ABSPATH' ) || exit;

// REGISTER POST TYPES
add_action( 'init', '_learningHubPostType' );
function _learningHubPostType() {
    register_post_type( 'learning_hub',
        array(
          'labels' => array(
            'name'          => __( 'SEO Learning' ),
            'singular_name' => __( 'SEO Learning' )
          ),
          "has_front"    => true,
          'public'       => true,
          'has_archive'  => false,
        //   'publicly_queryable' => true,
          'menu_icon'    => 'dashicons-welcome-learn-more',
          'show_in_menu' => true,
          'supports'     => array('editor', 'title', 'thumbnail', 'excerpt'),
        //   'rewrite' => array('slug' => 'seo-learning', 'with_front' => true)
          'rewrite'      => array('slug' => 'seo-learning/%learning_hub_categories%', 'with_front' => false)
        )
    );
    
    // REGISTER TAXONOMY
    register_taxonomy('learning_hub_categories', 'learning_hub',  array(
        'labels' => array(
            'name'          => 'Categories',
            'singular_name' => 'Category',
        ),
        'show_ui'            => true,
        'show_admin_column'  => true,
        'hierarchical'       => true,
        'query_var'          => true,
        'rewrite'            => array('slug' => 'seo-learning', 'with_front' => false)
    ));
}

// LEARNING HUB RE-PERMALINK
add_filter( 'post_type_link', '_learningHubRepermalink', 1, 3 );
function _learningHubRepermalink( $post_link, $id = 0 ){

    // if ( get_post_type( $post ) == 'learning_hub' ) {
        $post = get_post($id);
        if ( is_object( $post ) ){
            $terms = wp_get_object_terms( $post->ID, 'learning_hub_categories' );
            if( $terms ){
                return str_replace( '%learning_hub_categories%' , $terms[0]->slug , $post_link );
            }
        }
    // }
    return $post_link;
}


// SEO LEARNING BUTTON COMPLETED ARTICLE
add_shortcode( 'seoLearningCompletedButton', '_seoLearningCompletedButton' );
function _seoLearningCompletedButton() {
    ob_start();
    $pageId = get_queried_object_id();

    if ( is_user_logged_in() ) {
        $user       = wp_get_current_user();
        $slug       = basename( get_permalink( $pageId ) );
        $uniqueName = $slug . "_" . $user->ID;
        $val        = get_the_author_meta( $uniqueName, $user->ID );
        $buttonText = $val == "done" ? "You have completed this article" : "Mark this article as read" ;
?>
    <div class="seo-learning-progress-wrap">
        <?php if ( $val != "done" ){ ?>
            <p>Finished with this article? Please click the button below:</p>
        <?php } ?>
        <a href="" id="seo-learning-progress-button" class="<?php echo $val == "done" ? "done" : "" ; ?>"><img src="<?php echo get_stylesheet_directory_uri(); ?>/assets/images/loader.gif" alt="loader"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-check-circle-outlined" data-name=""><path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"></path></svg><span class="text"><?php echo $buttonText; ?></span></a>
    </div>
<?php
    }

    return ob_get_clean();
}

// SINGLE PAGE SEO LEARNING SIDEBAR
// add_shortcode( 'seo-learning-sidebar', '_seoLearningSidebarSinglePost' );
function _seoLearningSidebarSinglePost() {
    $postTerms = wp_get_post_terms( get_queried_object_id(), "learning_hub_categories" );

    ob_start();

    if ( $postTerms ) {
        $seoLearningQuery = new WP_Query( array(
            "post_type"      => "learning_hub",
            "post_status"    => "publish",
            "posts_per_page" => -1,
            "order"          => "DESC",
            "orderby"        => "menu_order",
            "tax_query"      => array(
                array(
                    "taxonomy" => "learning_hub_categories",
                    "field"    => "id",
                    "terms"    => array( $postTerms[0]->term_id )
                )
            )
        ) );
?>
    <div class="sidebarSeoLearning">
        <div class="sidebar-seolearning-widget">
            <h4><?php echo $postTerms[0]->name; ?></h4>

            <?php
                if ( $seoLearningQuery->have_posts() ) {
                    echo "<ul class='post-items'>";
                    while ( $seoLearningQuery->have_posts() ) { $seoLearningQuery->the_post();
                        $activeClass = get_queried_object_id() == get_the_ID() ? "active" : "";
                        $image = get_the_post_thumbnail_url(get_the_ID(), "thumbnail");
                    ?>
                        <li class='<?php echo $activeClass; ?>'>
                            <!-- <svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-chevron_right-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M10 6L8.59 7.41 13.17 12l-4.58 4.59L10 18l6-6-6-6z"></path></svg> -->
                            <a href='<?php echo get_the_permalink(); ?>'>
                                <div class="img" style="background-image: url(<?php echo $image; ?>);"></div>
                                <span class="title"><?php echo get_the_title(); ?></span>
                                <span class="excerpt"><?php echo wp_trim_words( get_the_excerpt(), 12, '...' ); ?></span>
                            </a>
                        </li>
                    <?php
                    } wp_reset_postdata();
                    echo "</ul>";
                }
            ?>
        </div>
        <div class="sidebar-seolearning-widget">
            <?php echo wp_nav_menu(array(
                "menu" => "Main Menu"
            )); ?>
        </div>
    </div>
<?php
    }

    return ob_get_clean();
}

// SEO LEARNING SHORTCODE
add_shortcode( 'seoLearning', '_seoLearningShortcode' );
function _seoLearningShortcode() {
    ob_start();
    
    // seo learning page id = 747
    // list all the main seo learning categories
    if ( is_page( array( 747 ) ) ) {
        $terms = get_terms( "learning_hub_categories", array(
            "hide_empty" => true,
            "parent"     => 0,
            "orderby"    => "menu_order"
        ) );

        if ( $terms ) {
            echo "<div class='learn-seo-wrap'>";
            foreach ( $terms as $key => $term ) { ?>
                <div class="learn-seo-item seo-item-cat">
                    <div class="item-content">
                        <a href="<?php echo get_term_link( $term->term_id ); ?>">
                            <h3><?php echo $term->name; ?></h3>
                            <?php if ( $term->description ){ ?>
                                <div class="item-desc"><?php echo $term->description; ?></div>
                            <?php } ?>
                        </a>
                    </div>
                </div>
            <?php }
            echo "</div>";
        }
    } else {
        // for the archive & category pages
        // list all products wrapped by their main category
        $pageObj = get_queried_object();

        $terms = get_terms( "learning_hub_categories", array(
            "hide_empty" => true,
            "parent"     => $pageObj->term_id,
            "orderby"    => "menu_order"
        ) );

        echo "<div class='learn-seo-wrap'>";

        // if the category page has child categories it will section the child categories and show its posts
        if ( $terms ) {
            foreach ( $terms as $key => $term ) {
                $termQuery = new WP_Query( array(
                    "post_type"      => "learning_hub",
                    "post_status"    => "publish",
                    "posts_per_page" => -1,
                    "orderby"        => "menu_order",
                    "tax_query" => array(
                        array(
                            "taxonomy" => "learning_hub_categories",
                            "field"    => "id",
                            "terms"    => array( $term->term_id )
                        )
                    )
                ) );

                if ( $termQuery->have_posts() ) {
                    // echo "<div class='ls-item'>";
                    // echo "<h3>" . $term->name . "</h3>";
                    while ( $termQuery->have_posts() ) { $termQuery->the_post();
                        $postImage = get_the_post_thumbnail_url( get_the_ID(), "medium_large" );
            ?> 
                        <div class="learn-seo-item seo-item-cat">
                            <div class="item-content">
                                <a href="<?php echo get_the_permalink(); ?>">
                                    <h3><?php echo the_title(); ?></h3>
                                    <?php if ( get_the_excerpt() ){ ?>
                                        <div class="item-desc"><?php echo get_the_excerpt(); ?></div>
                                    <?php } ?>
                                </a>
                            </div>
                        </div>
            <?php
                    } wp_reset_postdata();
                    // echo "</div><hr />";
                } else {
                    echo "<div class='ls-not-found'>No posts found.</div>";
                }
            }
        } else {
            // if the category page has no category it will just list all the existing posts
            $termQuery = new WP_Query( array(
                "post_type"      => "learning_hub",
                "post_status"    => "publish",
                "posts_per_page" => -1,
                "orderby"        => "menu_order",
                "tax_query" => array(
                    array(
                        "taxonomy" => "learning_hub_categories",
                        "field"    => "id",
                        "terms"    => array( $pageObj->term_id )
                    )
                )
            ) );

            if ( $termQuery->have_posts() ) {
                // echo "<div class='ls-item'>";
                while ( $termQuery->have_posts() ) { $termQuery->the_post();
                    $postImage = get_the_post_thumbnail_url( get_the_ID(), "medium_large" );
        ?> 
                    <div class="learn-seo-item seo-item-cat">
                        <div class="item-content">
                            <a href="<?php echo get_the_permalink(); ?>">
                                <?php if ( $postImage ){ ?>
                                    <div class="img" style="background-image: url(<?php echo $postImage; ?>);"></div>
                                <?php } ?>
                                <h3><?php echo the_title(); ?></h3>
                                <?php if ( get_the_excerpt() ){ ?>
                                    <div class="item-desc"><?php echo get_the_excerpt(); ?></div>
                                <?php } ?>
                            </a>
                        </div>
                    </div>
                    <!-- <div class="ls-post">
                        <div class="ls-image" style="background-image: url( <?php echo $postImage; ?> );"></div>
                        <h5><?php the_title(); ?></h5>
                        <div><?php the_excerpt(); ?></div>
                        <a href="<?php echo get_the_permalink(); ?>" class="ls-learn-more">Learn More</a>
                    </div> -->
        <?php
                } wp_reset_postdata();
                // echo "</div>";
            } else {
                echo "<div class='ls-not-found'>No posts found.</div>";
            }

        }
        echo "</div>";
    }
    
    return ob_get_clean();
}