<?php
defined( 'ABSPATH' ) || exit;

/*
 *
 * SEO Manager - Customer Orders Dashboard
 * - Order information
 *
 *
 */
// SEO MANAGER CUSTOM ORDERS TABLE
add_action( "woocommerce_before_account_orders", "_cstmOrdersTable" );
function _cstmOrdersTable(){
	// get user data
    $user = wp_get_current_user();

	// get all customer orders
	/*$customer_orders = get_posts( array(
	    'numberposts' => -1,
	    'meta_key'    => '_customer_user',
	    'meta_value'  => $user->ID,
	    'post_type'   => wc_get_order_types(),
	    'post_status' => array_keys( wc_get_order_statuses() ),
	) );*/

	$customer_orders = wc_get_orders( array(
	    'customer_id' => $user->ID,
	    'orderby'     => 'date',
	    'order'       => 'DESC',
	) );

	// account manager
	$accountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );
	$accountManager = get_user_by( "email", $accountManager );

	// check if the correct data is available
	if ( isset( $_GET['pId'] ) && isset( $_GET['orderId'] ) ) {

		// check if the order_id is legitimate
		$validateOrder = get_post_type( $_GET['orderId'] );

		if ( $validateOrder ) {
			// get the order
			$order = new WC_Order( $_GET['orderId'] );

			// get order date
            $orderDate = $order->get_date_created();
            $orderDate = date( 'd-m-Y', strtotime( $orderDate ) );

			// validate if the itemId exists within the order
			$validateOrderItems = [];

			// get all order items
			$order_items = $order->get_items();

			// loop order items
			foreach ( $order_items as $key => $item ) {
				$productId = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();

				// check if the itemId exists within the order
				if ( $_GET['pId'] == $productId ) {
					$validateOrderItems[] = true; // validate that the product exists

					$itemStatus  = get_post_meta( $_GET['orderId'], '_order_item_status_'.$_GET['orderId'].'_'.$_GET['pId'], true ) ? get_post_meta( $_GET['orderId'], '_order_item_status_'.$_GET['orderId'].'_'.$_GET['pId'], true ) : 'Processing';

					// $test = $item->get_data();
					// $itemMetaData = $item->get_meta_data();
					$formattedMetaData = $item->get_formatted_meta_data( '_', true );

					// get the product type
					$product_type = get_the_terms( $productId, 'product_type' )[0]->slug;

					// get website from order
					// note: this is also saved on the user meta
					$website = $item->get_meta( 'Website URL', true );
				?>
					<div class="account-order-data-wrap">
						<div class="order-item-details-wrap">
							<!-- order item details here -->
							<div class="order-item-details">
								<h3>Order Item Details</h3>
								<ul>
									<li>Name: <?php echo $item->get_name(); ?></li>
									<li>Website URL: <?php echo $website; ?></li>
									<li>Status: <?php echo $itemStatus; ?></li>
									<li>Item ID: <?php echo $_GET['itemId']; ?></li>
									<li>Order ID: <?php echo $_GET['orderId']; ?></li>
									<li>Order Date: <?php echo $orderDate; ?></li>
								</ul>
								<?php
									if ( $product_type && $product_type == "subscription" ):
										$susbcriptionId = $_GET['orderId'] + 1;
										$subscriptionLink = get_site_url()."/seo-manager/view-subscription/" . $susbcriptionId . "/";
								?>
									<a class="subscriptionButton" href="<?php echo $subscriptionLink; ?>">View Subscription</a>
								<?php endif ?>
							</div>
							<?php
								// meta data
								if ( $formattedMetaData ) {
									echo '<div class="order-item-details">';
									echo "<h3>Additional Information</h3><ul>";
									foreach ( $formattedMetaData as $key => $mData ) {
										if ( $mData->key == "Attachment") {
											echo "<li>".$mData->key.": <a href='".$mData->value."'>Download File</a></li>";
										} else {
											echo "<li>".$mData->key.": ".$mData->value."</li>";
										}
									}
									echo "</ul></div>";
								}
							?>
						</div>
						<?php
							// order entries
							$accountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );
							$accountManager = get_user_by( "email", $accountManager );
							$orderItemGformEntries = get_the_author_meta( "_order_item_gform_entries", $user->ID );
		                    $orderItemGformEntries = $orderItemGformEntries ? $orderItemGformEntries : array();

		                    // 
		                    $downloadableData = "";
						?>
						<div class="processes-wrap">
							<ul class="process-tabs" style="font-size: 16px;">
								<li class="active" data-tab="information">Information</li>
								<li data-tab="reports">Reports</li>
							</ul>

							<div class="process-tab-content active" data-tab="information">
								<?php if ( array_key_exists( $_GET['itemId'], $orderItemGformEntries ) ){ ?>
		                            <?php
		                            	$count = 1;
		                            	$downloadableData = array();
		                            	foreach ( $orderItemGformEntries[$_GET['itemId']]['process'] as $key => $process ) {
		                            		$processTitle = $key;
		                            ?>
		                                <div class="process-item-wrap <?php echo $process['approved'] ? "approved" : ""; ?>">
		                                	<div class="number"><?php echo $count; ?></div>
		                                    <div class="process-title">
		                                        <h4><?php echo $key; ?></h4>
		                                        <div class="process-status">Status: <strong><?php echo $process['approved'] ? "Approved" : "Pending Approval"; ?></strong></div>
		                                    </div>
		                                    <div class="table-wrap">
			                                    <table class="dashboard-table process-table">
			                                        <thead>
			                                            <tr>
			                                                <!-- <th>Entry Number</th> -->
			                                                <th>Message Log</th>
			                                                <!-- <th class="td-file-download">File/s</th> -->
			                                                <!-- <th class="td-actions"></th> -->
			                                            </tr>
			                                        </thead>
			                                        <tbody>
			                                            <?php
				                                            // reverse array so new items will always be on top
			                                                $processEntries = array_reverse( $process['entries'] );

			                                                // get the downloadable reports data
			                                                // $downloadableData = get_the_author_meta( "_downloadable_reports", $user->ID );

			                                                // if the downloadable reports data is empty initialize an empty array
														    // if ( !is_array( $downloadableData ) ) {
														        // $downloadableData = array();
														    // }

			                                                // date day_month_year
			                                                // check if date today is already in array
			                                                /*$currentMonth = date("F_Y");
			                                                if ( !array_key_exists( $currentMonth, $downloadableData )  ) {
			                                                	$downloadableData[$currentMonth] = [];
			                                                }
*/
			                                                foreach ( $processEntries as $key => $entry_id ) {
			                                                    // get gform entry object
			                                                    $entry = GFAPI::get_entry( $entry_id );

			                                                    // get gform entry data
			                                                    $comments = rgar( $entry, '2' );
			                                                    $file     = rgar( $entry, '3' );
			                                                    $files    = rgar( $entry, '10' );
			                                                    $fromUser = rgar( $entry, '9' );
			                                                    $fromUser = get_user_by( "email", $fromUser );

			                                                    $month = date("F",strtotime($entry["date_created"]));

			                                                    // insert downloadable file into data
			                                                    if ( $file ) {
			                                                    	$downloadableData[$month][$entry_id]["date_created"] = $entry["date_created"];
			                                                    	$downloadableData[$month][$entry_id]["file"] = $file;
			                                                    }
			                                                    if ( $files ) {
	                                                                $downloadableData[$month][$entry_id]["date_created"] = $entry["date_created"];
	                                                                $downloadableData[$month][$entry_id]["files"] = json_decode($files);
	                                                            }
			                                            ?>
			                                                    <tr>
			                                                        <!-- <td><?php //echo $entry_id; ?></td> -->
			                                                        <td>
			                                                        	<div class="user-info">
			                                                        		<div class="name"><?php echo $fromUser->display_name; ?></div>
			                                                        		<div class="date"><?php echo date( "F j, Y, g:i a", strtotime( $entry['date_created'] ) ); ?></div>
			                                                        	</div>
			                                                        	<div class="message">
				                                                        	<?php echo apply_filters( "the_content", $comments ); ?>
				                                                        	<div class="process-actions">
				                                                        		<?php if ( $file ){ ?>
					                                                                <a href="<?php echo $file; ?>" title="Download File/s" download class="file-download"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>
					                                                            <?php } ?>
					                                                            <?php if ( $files ){ ?>
	                                                                                <!-- <pre><?php //var_dump($files); ?></pre> -->
	                                                                                <a href="" title="Download File/s" class="file-download multiple-file-download" data-files=<?php echo $files; ?>><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>
	                                                                            <?php } ?>
					                                                        	<!-- <a href="" class="dashboard-edit-request <?php //echo $process['approved'] ? 'request-approved' : ''; ?>" data-target="#dashboardEditRequestModal" data-main-entry-id="<?php //echo $entry_id; ?>" data-process-title="<?php //echo $processTitle; ?>">Edit Request</a> -->
				                                                        	</div>
			                                                        	</div>
			                                                        	<?php if ($process['entry_edits'] ){
			                                                        		echo "<table>";
			                                                        		foreach ( $process['entry_edits'] as $key => $requests ) {
			                                                        			if ( $key == $entry_id ) {
				                                                        			foreach ( $requests as $key => $request ) {
				                                                        				$erEntry     = GFAPI::get_entry( $request );
				                                                        				$erComments  = rgar( $erEntry, '1' );
							                                                   			$erFiles     = rgar( $erEntry, '2' );
							                                                   			$erFiles     = $erFiles ? json_decode( $erFiles ) : "";
							                                                   			$newFromUser = rgar( $erEntry, '9' );
							                                                   			$newFromUser = get_user_by( "email", $newFromUser );
					                                                        			/*echo "<pre style='font-size: 14px;'>";
							                                                			var_dump($erEntry);
							                                                			echo "</pre>";*/
					                                                        		?>
					                                                        			<tr>
					                                                        				<td>
					                                                        					<div class="user-info">
									                                                        		<div class="name"><?php echo $newFromUser->display_name; ?></div>
									                                                        		<div class="date"><?php echo date( "F j, Y, g:i a", strtotime( $erEntry['date_created'] ) ); ?></div>
									                                                        	</div>
									                                                        	<div class="message">
						                                                        					<?php echo apply_filters( "the_content", $erComments ); ?>
						                                                        					<div class="process-actions">
						                                                        						<?php
											                                                        		if ( $erFiles ){
											                                                        			echo '<a href="" class="downloadMultipleFiles" title="Download File/s"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-download-solid" data-name=""><path d="M5,20H19V18H5M19,9H15V3H9V9H5L12,16L19,9Z"></path></svg></a>';
											                                                        			echo '<div class="d-none multipleFilesDownload">';
											                                                        			foreach ( $erFiles as $key => $file ) {
											                                                        				echo "<a href='".$file."' download></a>";
											                                                        			}
											                                                        			echo '</div';
											                                                        		}
											                                                        	?>
						                                                        					</div>
									                                                        	</div>
					                                                        				</td>
					                                                        			</tr>
					                                                        		<?php
				                                                        			}
			                                                        			}
			                                                        		}
			                                                        		echo "</table>";
			                                                        	} ?>
			                                                        	<?php
			                                                        		// the page id of the service
			                                                        		$page_id = "";
			                                                        		if ($formattedMetaData) {
			                                                        			foreach ($formattedMetaData as $key => $value) {
					                                                        		if ( $value->key == "Product ID" ) {
						                                                        		$page_id = $value->value;
					                                                        		}
			                                                        			}
			                                                        		}
			                                                        		$button_text = in_array( $page_id, MANAGED_SERVICES ) ? "Add Comment" : "Edit Request";
			                                                        	?>
			                                                        	<a href="" class="dashboard-edit-request <?php echo $process['approved'] ? 'request-approved' : ''; ?>" data-target="#dashboardEditRequestModal" data-main-entry-id="<?php echo $entry_id; ?>" data-process-title="<?php echo $processTitle; ?>"><?php echo $button_text; ?></a>
			                                                        </td>
			                                                        <!-- <td>
			                                                            <?php //if ( $file ){ ?>
			                                                                <a href="<?php //echo $file; ?>" download class="file-download">Download</a>
			                                                            <?php //} ?>
			                                                        </td> -->
			                                                        <!-- <td><a href="" class="dashboard-edit-request <?php //echo $process['approved'] ? 'request-approved' : ''; ?>" data-toggle="modal" data-target="#dashboardEditRequestModal" data-main-entry-id="<?php //echo $entry_id; ?>">Edit Request</a></td> -->
			                                                       <!--  <td>
			                                                        	 <?php //if ( $file ){ ?>
			                                                                <a href="<?php //echo $file; ?>" download class="file-download">Download</a>
			                                                            <?php //} ?>
			                                                        	<a href="" class="dashboard-edit-request <?php //echo $process['approved'] ? 'request-approved' : ''; ?>" data-target="#dashboardEditRequestModal" data-main-entry-id="<?php //echo $entry_id; ?>" data-process-title="<?php //echo $processTitle; ?>">Edit Request</a>
			                                                        </td> -->
			                                                    </tr>
			                                            <?php } ?>
			                                        </tbody>
			                                    </table>
		                                    </div>

		                                    <!--
												Only show the approved process button if the service bought is content writing or blog writing
		                                    -->
		                                    <?php if ( intval($page_id) == BLOG_WRITING_SERVICES || intval($page_id) != CONTENT_WRITING_SERVICES ): ?>
			                                    <div class="process-footer <?php echo $process['approved'] ? "approved" : ""; ?>">
			                                    	<?php if ( !$process['approved'] ) { ?>
				                                    	<p>By clicking the approve button you agree to the <a href="<?php echo get_site_url(); ?>/terms-and-conditions/">Terms &amp; Service</a> agreement.</p>
			                                    	<?php } ?>
			                                    	<a href="" class="customer-approve-process <?php echo $process['approved'] ? 'request-approved' : ''; ?>" data-item-id="<?php echo $_GET['itemId']; ?>" data-process-title="<?php echo $processTitle; ?>"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-check-circle-outlined" data-name=""><path d="M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm0 48c110.532 0 200 89.451 200 200 0 110.532-89.451 200-200 200-110.532 0-200-89.451-200-200 0-110.532 89.451-200 200-200m140.204 130.267l-22.536-22.718c-4.667-4.705-12.265-4.736-16.97-.068L215.346 303.697l-59.792-60.277c-4.667-4.705-12.265-4.736-16.97-.069l-22.719 22.536c-4.705 4.667-4.736 12.265-.068 16.971l90.781 91.516c4.667 4.705 12.265 4.736 16.97.068l172.589-171.204c4.704-4.668 4.734-12.266.067-16.971z"></path></svg> <?php echo $process['approved'] ? "Approved" : "Approve Process"; ?></a>
			                                    </div>
		                                    <?php endif ?>
		                                </div>
		                            <?php $count++; } ?> 
		                        <?php } else { ?>
		                        	<p>No order data.</p>
		                        <?php } ?>
	                        </div>
	                        <div class="process-tab-content reports" data-tab="reports">
	                        	<!-- Downloadable Data -->
                                <?php if ($downloadableData): ?>
                                	<div class="process-title">
                                        <h4>Reports</h4>
                                    </div>
                                    <div class="table-wrap">
	                                    <table class="dashboard-table user-downloadables">
	                                    	<thead>
	                                    		<tr>
	                                    			<th>Month</th>
	                                    			<th>Date Uploaded</th>
	                                    			<th></th>
	                                    		</tr>
	                                    	</thead>
	                                    	<tbody>
	                                    		<?php foreach ($downloadableData as $mainkey => $dd) { $monthCtr = 1; ?>
                                    				<?php foreach ($dd as $key => $ddData): ?>
                                    					<tr>
                                    						<td><?php
                                    							// $month = substr($mainkey, 0, strpos($mainkey, "_"));
                                    							echo $monthCtr == 1 ? $mainkey : "";
                                    						?></td>
		                                    				<?php foreach ($ddData as $key => $ddD): ?>
			                                    				<td><?php 
			                                    					if ( $key == "date_created" ) {
                                                                        $newdate = date( "F j, Y", strtotime($ddD) );
                                                                        echo $newdate;
                                                                    } elseif( $key == "files" ) {
                                                                        foreach ($ddD as $key => $f) {
                                                                            $filename = basename(parse_url($f, PHP_URL_PATH));
                                                                            echo $key > 0 ? ", " : "";
                                                                            // echo $key;
                                                                            // echo "<a href='".$f."' download>".$filename."</a>";
                                                                            $fileId    = "modal-" . $key;
                                                                            echo "<a href='' data-pdf-url='".$f."' class='pdf-modal'>".$filename."</a>";
                                                                        }
                                                                    } else {
                                                                        $filename = basename(parse_url($ddD, PHP_URL_PATH));
                                                                        echo "<a href='".$ddD."' download>".$filename."</a>";
                                                                    }
			                                    				?></td>
		                                    				<?php endforeach ?>
	                                    				</tr>
                                    				<?php $monthCtr++; endforeach; ?>
	                                    		<?php } ?>
	                                    	</tbody>
	                                    </table>
	                                </div>
                                <?php else: ?>
                                        <p style="font-size: 14px;">No reports found.</p>
                                <?php endif ?>
                                <?php
                                	/*echo "<pre style='font-size:14px;'>";
                                    var_dump($downloadableData);
                                    echo "</pre>";*/

                                    // after update meta data
                                    // update_user_meta( $user->ID, "_downloadable_reports", $downloadableData );
                                    // update_user_meta( $user->ID, "_downloadable_reports", array() ); // reset
                                ?>
	                        </div>
	                    <!-- </div> -->
	                	</div>
	                </div>
				<?php
				} // end if productId
			}

			// if $validateOrderItems is empty that means there is valid order item
			if ( empty( $validateOrderItems ) ) {
				echo "<p>Error! Invalid Order.</p>";
			}

			// 
			echo do_shortcode('[gravityform id=3 title=false description=false ajax=true]');
		} else{
			echo "<p>Error! Invalid Order.</p>";
		}
	} else {
		if ( $customer_orders ) {
?>	
			<div class="account-order-data-wrap">
				<div class="order-item-details-wrap">
					<div class="order-item-details">
						<h3>Your Account Manager</h3>
						<?php if ( $accountManager ){ ?>
							<ul>
								<li>Name: <?php echo $accountManager->display_name; ?></li>
								<li>Email: <?php echo $accountManager->user_email; ?></li>
							</ul>
						<?php } else { ?>
							<p style="margin-top: 10px; margin-bottom: 0; padding-bottom: 0;"><em>An Account Manager will be assigned to you soon.</em></p>
						<?php } ?>
					</div>

					<!--  -->
					<?php
						$userWebsites = get_the_author_meta( "_user_websites", $user->ID ) ? get_the_author_meta( "_user_websites", $user->ID ) : [];
					?>
					<div class="order-item-details">
						<div class="filter-item-wrap">
							<label>Filter by Date:</label>
							<select name="" id="dashboard-filter-date">
								<option value="newest">Newest</option>
								<option value="oldest">Oldest</option>
							</select>
						</div>
						<?php if ( $userWebsites ){ ?>
							<div class="filter-item-wrap">
								<label>Filter by Website:</label>
								<select name="" id="dashboard-filter-website">
									<option value="" selected>All</option>
									<?php foreach ( $userWebsites as $key => $website ) { ?>
										<option value="<?php echo $website; ?>"><?php echo $website; ?></option>
									<?php } ?>
								</select>
							</div>
						<?php } ?>
					</div>
				</div>

				<div class="dashboard-table-wrap">
					<table class="dashboard-table dt-filter-table">
						<thead style="text-align: left;">
							<tr>
								<th>Name</th>
								<th>Website</th>
								<!-- <th>Item ID</th> -->
								<th>Status</th>
								<th>Order Date</th>
								<th>Order ID</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							<?php
								// subscription based products
								$productSubscriptions = [];

								foreach ( $customer_orders as $key => $co ) {
									$order       = new WC_Order( $co->ID );
									$order_id    = $co->ID;
									$order_items = $order->get_items();

									$orderDate = $order->get_date_created();
						            $orderDate = date( 'd-m-Y', strtotime( $orderDate ) );
							?>
									
									<?php
										foreach ( $order_items as $key => $item ) {
											$productName = $item->get_name();
											$productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
											$itemStatus  = get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) ? get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) : 'Processing';
											$itemId      = $productId . "_" . $order_id; // this is a combination of the product id + order id

											$product_type = get_the_terms( $productId,'product_type');
											/*echo "<pre>";
											var_dump($product_type);
											echo "</pre>";*/

											// if ( $product_type[0]->slug != "subscription" ) {
											// get website from order
											// note: this is also saved on the user meta
											$website = $item->get_meta( 'Website URL', true );
									?>
												<tr>
													<td><?php echo $productName; ?></td>
													<td><?php echo $website; ?></td>
													<!-- <td><?php //echo $itemId; ?></td> -->
													<td><?php echo $itemStatus; ?></td>
													<td><?php echo $orderDate; ?></td>
													<td><?php echo $order_id; ?></td>
													<td><a href="?itemId=<?php echo $itemId; ?>&orderId=<?php echo $order_id; ?>&pId=<?php echo $productId; ?>">View</a></td>
													<!-- <pre><?php ///var_dump($item->get_name()); ?></pre> -->
												</tr>
										<?php 
											/*} else {
												// if product type is == subscription
												$productSubscriptions[] = array(
													"item_order_status" => $itemStatus,
													"item_id"           => $itemId,
													"order_id"          => $order_id,
													"product_type"      => $product_type[0]->slug,
													"product_name"      => $productName,
													"product_id"        => $productId,
												);
											}*/
										?>
									<?php } // end foreach order items ?>
							<?php } //end foreach orders ?>
						</tbody>
					</table>
				</div>

				<!-- products that are subscription based -->
				<?php //if ( !empty( $productSubscriptions ) ){ ?>
					<!-- <div class="order-item-details">
						<h3>Your Subscription Based Services</h3>
					</div>
					<table class="dashboard-table">
						<thead style="text-align: left;">
							<tr>
								<th>Name</th>
								<th>Status</th>
								<th>Item ID</th>
								<th>Order ID</th>
								<th></th>
							</tr>
						</thead>
						<tbody>
							<?php //foreach ( $productSubscriptions as $key => $pSub ) { ?>
								<tr>
									<td><?php //echo $pSub['product_name']; ?></td>
									<td><?php //echo $pSub['item_order_status']; ?></td>
									<td><?php //echo $pSub['item_id']; ?></td>
									<td><?php //echo $pSub['order_id']; ?></td>
									<td><a href="?itemId=<?php //echo $pSub['item_id']; ?>&orderId=<?php //echo $pSub['order_id']; ?>&pId=<?php //echo $pSub['product_id']; ?>">View</a></td>
								</tr>
							<?php //} ?>
						</tbody>
					</table> -->
				<?php //} // end if product subscriptions ?>
			</div>
		<?php } else { // end if customer orders ?>
			<div class="account-no-order">
				<p>No order has been made yet.</p>
				<a href="<?php echo get_site_url(); ?>/seo-manager/">Browse Our Services</a>
			</div>
		<?php } ?>
	<?php } // end if ?>
<?php }

// pre populate client email
add_filter('gform_field_value_account_manager', '_gformAccountManager');
function _gformAccountManager( $value ){

	// get user data
    $user = wp_get_current_user();

    // get the account manager
    $accountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );

    // 
    return $accountManager;
}

// update order item custom meta with gform data
add_action( 'gform_after_submission_2', '_gformCustomerUpdateOrderItemData', 10, 2 );
function _gformCustomerUpdateOrderItemData( $entry, $form ) {

	// get user data
    $user = wp_get_current_user();

    // get the order item entries
    $orderItemGformEntries = get_the_author_meta( "_order_item_gform_entries", $user->ID );

    // process
    $process     = rgar( $entry, 7 );
    $mainEntryId = rgar( $entry, 8 );

    // insert the values into the array
    $orderItemGformEntries[$_GET['itemId']]['process'][$process]['entry_edits'][$mainEntryId][] = $entry['id'];

    // update the user meta
    update_user_meta( $user->ID, "_order_item_gform_entries", $orderItemGformEntries );
}

// customer order item dashboard approve the process
add_action( 'gform_after_submission_3', '_customerApproveOrderProcess', 10, 2 );
function _customerApproveOrderProcess( $entry, $form ) {

	// get user data
    $user = wp_get_current_user();

    // 
	$orderItemId  = rgar( $entry, 1 );
	$processTitle = rgar( $entry, 5 );

	// 
	$orderItemGformEntries = get_the_author_meta( "_order_item_gform_entries", $user->ID );
	$currentTime = date( "F j, Y, g:i a" ); // current date and time

	// update the values
	$orderItemGformEntries[$orderItemId]["process"][$processTitle]["date_approved"] = $currentTime;
	$orderItemGformEntries[$orderItemId]["process"][$processTitle]["approved"] = true;

	// update the user meta
    update_user_meta( $user->ID, "_order_item_gform_entries", $orderItemGformEntries );
}

// customer order item dashboard pre populate account manager form field on form 3
add_filter('gform_field_value_process_approved_customer_manager', '_gformProcessApprovedCustomerManager');
function _gformProcessApprovedCustomerManager( $value ){

	// get user data
    $user = wp_get_current_user();

    // account manager
	$accountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );

    // return data
    return $accountManager;
}

// 
add_action( 'wp_ajax_dashboardFilterCustomerOrders', 'dashboardFilterCustomerOrders' ); 
add_action( 'wp_ajax_nopriv_dashboardFilterCustomerOrders', 'dashboardFilterCustomerOrders' ); 
function dashboardFilterCustomerOrders() {
    $user       = wp_get_current_user();
	$date       = $_REQUEST['date'];
	$newwebsite = $_REQUEST['website'];

	$customer_orders = wc_get_orders( array(
	    'customer_id' => $user->ID,
	    'orderby'     => 'date',
	    'order'       => 'DESC',
	) );

	// reverse the array
	if ( $date == "oldest" ) {
		$customer_orders = array_reverse( $customer_orders );
	}

	if ( $newwebsite ) {
		foreach ( $customer_orders as $key => $co ) {
			$order       = new WC_Order( $co->ID );
			$order_id    = $co->ID;
			$order_items = $order->get_items();
			$orderDate   = $order->get_date_created();
	        $orderDate   = date( 'd-m-Y', strtotime( $orderDate ) );

			foreach ( $order_items as $key => $item ) {
				$productName = $item->get_name();
				$productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
				$itemStatus  = get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) ? get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) : 'Processing';
				$itemId      = $productId . "_" . $order_id; // this is a combination of the product id + order id

				$product_type = get_the_terms( $productId,'product_type');

				// note: this is also saved on the user meta
				$website = $item->get_meta( 'Website URL', true );

				if ( $newwebsite == $website ) {
?>
					<tr>
						<td><?php echo $productName; ?></td>
						<td><?php echo $website; ?></td>
						<td><?php echo $itemStatus; ?></td>
						<td><?php echo $orderDate; ?></td>
						<td><?php echo $order_id; ?></td>
						<td><a href="?itemId=<?php echo $itemId; ?>&orderId=<?php echo $order_id; ?>&pId=<?php echo $productId; ?>">View</a></td>
					</tr>
<?php
				}
			} // end foreach order items
		} //end foreach orders
	} else {
		foreach ( $customer_orders as $key => $co ) {
			$order       = new WC_Order( $co->ID );
			$order_id    = $co->ID;
			$order_items = $order->get_items();
			$orderDate   = $order->get_date_created();
	        $orderDate   = date( 'd-m-Y', strtotime( $orderDate ) );

			foreach ( $order_items as $key => $item ) {
				$productName = $item->get_name();
				$productId   = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();
				$itemStatus  = get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) ? get_post_meta( $order_id, '_order_item_status_'.$order_id.'_'.$productId, true ) : 'Processing';
				$itemId      = $productId . "_" . $order_id; // this is a combination of the product id + order id

				$product_type = get_the_terms( $productId,'product_type');

				// note: this is also saved on the user meta
				$website = $item->get_meta( 'Website URL', true );
?>
				<tr>
					<td><?php echo $productName; ?></td>
					<td><?php echo $website; ?></td>
					<td><?php echo $itemStatus; ?></td>
					<td><?php echo $orderDate; ?></td>
					<td><?php echo $order_id; ?></td>
					<td><a href="?itemId=<?php echo $itemId; ?>&orderId=<?php echo $order_id; ?>&pId=<?php echo $productId; ?>">View</a></td>
				</tr>
<?php
			} // end foreach order items
		} //end foreach orders
	} // end


	die();
}