<?php

// require google config
require_once(ABSPATH . 'wp-content/themes/thrive-theme-child/includes/google/search-console-api.php');
require_once(ABSPATH . 'wp-content/themes/thrive-theme-child/includes/google/analytics-api.php');


// main dashboard content
add_shortcode( 'seo-manager', 'dashboardWrapper' );
function dashboardWrapper() {
    ob_start();

    // get page slug
	$page_slug = strtok($_SERVER["REQUEST_URI"], '?');

	if (is_user_logged_in()){

		// redirect to view order after oauth2 google verification
		$state = isset($_GET["state"]) ? $_GET["state"] : '';
		$code  = isset($_GET["code"]) ? $_GET["code"] : '';
		if ($state) {
			header('Location:'.$state.'?code='.$code);
		    exit();
		}
		// =============================
?>
		<?php do_action('custom_notifications_before_content'); ?>
		<div class="dashboard-wrapper">
			<?php echo do_shortcode("[dashboard-sidebar]"); ?>
			<div class="dashboard-content p-3">

				<!--  -->
				<?php do_action('custom_notifications'); ?>

				<div class="menu-wrapper dashboard-menu-toggle d-lg-none">
					MENU
					<div class="bars">
						<span class="bar"></span>
						<span class="bar"></span>
						<span class="bar"></span>
					</div>
				</div>
				<?php
					if ($page_slug == '/seo-manager/') {
						echo do_shortcode("[dashboard-overview]");
					} elseif ($page_slug == '/seo-manager/report-history/') {
						echo do_shortcode("[report-history]");
					} elseif ($page_slug == '/seo-manager/assigned-orders/') {
						echo do_shortcode("[assigned-orders]");
					} elseif ($page_slug == '/seo-manager/seo-strategy/') {
						echo do_shortcode("[seo-strategy]");
					} elseif ($page_slug == '/seo-manager/todos/') {
						echo do_shortcode("[seo-todo]");
					} elseif ($page_slug == '/seo-manager/todos/list/') {
						echo do_shortcode("[seo-todo-list]");
					} elseif ($page_slug == '/seo-manager/seo-learning/') {
						echo do_shortcode("[seo-learning]");
					} elseif ($page_slug == '/seo-manager/rankings/') {
						echo do_shortcode("[seo-rankings]");
					} elseif ($page_slug == '/seo-manager/client-information/') {
						echo do_shortcode("[seo-customer-information]");					
					} elseif ($page_slug == '/seo-manager/managers/') {
						echo do_shortcode("[seo-managers-view]");					
					} elseif ($page_slug == '/seo-manager/managers/manager/') {
						echo do_shortcode("[seo-manager-details]");					
					} elseif ($page_slug == '/seo-manager/tools/backlink-checker/') {
						echo do_shortcode("[seo-tools-backlink-checker]");					
					} elseif ($page_slug == '/seo-manager/tools/domain-authority-checker/') {
						echo do_shortcode("[seo-tools-domain-authority-checker]");					
					} elseif ($page_slug == '/seo-manager/tools/wordcount/') {
						echo do_shortcode("[seo-tools-wordcount]");					
					} elseif ($page_slug == '/seo-manager/tools/anchor-count/') {
						echo do_shortcode("[seo-tools-anchor-count]");					
					} elseif ($page_slug == '/seo-manager/tools/content-readability/') {
						echo do_shortcode("[seo-tools-content-readability]");					
					} elseif ($page_slug == '/seo-manager/tools/ssl-certificate-checker/') {
						echo do_shortcode("[seo-tools-ssl-checker]");					
					} elseif ($page_slug == '/seo-manager/tools/keyword-density/') {
						echo do_shortcode("[seo-tools-keyword-density]");					
					} elseif ($page_slug == '/seo-manager/tools/keyword-extraction/') {
						echo do_shortcode("[seo-tools-keyword-extraction]");					
					} elseif ($page_slug == '/seo-manager/tools/conversion-rate-calculator/') {
						echo do_shortcode("[seo-tools-conversion-rate-calculator]");					
					} 
					/* elseif ($page_slug == '/seo-manager/new-dashboard/') {
						echo do_shortcode("[new-dashboard]");					
					} */
				?>
			</div>
		</div>
<?php
	}

	return ob_get_clean();
}

// dashboard sidebar
add_shortcode( 'dashboard-sidebar', 'dashboardSidebar' );
function dashboardSidebar() {
	ob_start();

	// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$user_id = $user_id ? $user_id : get_current_user_id();
	// GET THE USER OBJECT
    $user = get_user_by("ID", $user_id);
	// GET THE USER ROLE
    $user_role = $user->roles[0];
	// GET PAGE SLUG
	$page_slug = strtok($_SERVER["REQUEST_URI"], '?');

	// GET THE VIEW AS TO CHECK IF THE USER IS VIEWING AS A CUSTOMER
	$view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
?>
		<div class="dashboard-sidebar">
			<!-- <div class="ds-inner"> -->
				<div class="dashboard-menu-toggle">&times;</div>
				<div class="site-logo">
					<a href="<?php echo get_site_url(); ?>/seo-manager/"><img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/03/seoilogo-3.png" alt="SEOi"></a>
				</div>
				<ul class="sidebar-menu">
					<li class="<?php echo $page_slug == '/seo-manager/' ? "is-active" : ""; ?>"><a href="<?php echo site_url(); ?>/seo-manager/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 640 512" data-id="icon-laptop-code-solid" data-name=""><path d="M255.03 261.65c6.25 6.25 16.38 6.25 22.63 0l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L253.25 192l35.71-35.72c6.25-6.25 6.25-16.38 0-22.63l-11.31-11.31c-6.25-6.25-16.38-6.25-22.63 0l-58.34 58.34c-6.25 6.25-6.25 16.38 0 22.63l58.35 58.34zm96.01-11.3l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0l58.34-58.34c6.25-6.25 6.25-16.38 0-22.63l-58.34-58.34c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63L386.75 192l-35.71 35.72c-6.25 6.25-6.25 16.38 0 22.63zM624 416H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33.02-17.47-32.77-32H16c-8.8 0-16 7.2-16 16v16c0 35.2 28.8 64 64 64h512c35.2 0 64-28.8 64-64v-16c0-8.8-7.2-16-16-16zM576 48c0-26.4-21.6-48-48-48H112C85.6 0 64 21.6 64 48v336h512V48zm-64 272H128V64h384v256z"></path></svg></span><span class="text">Overview</span></a></li>

					<?php if ($user_role != "account_manager" && $user_role != "administrator") { ?>
						<?php
							if($view_as != 'user'){
								// order link class
								$order_class = "";
								if ($page_slug == '/seo-manager/orders/' || strpos($page_slug, 'view-order') !== false) {
									$order_class = "is-active";
								}
						?>
								<li class="<?php echo $order_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/orders/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-order-bool-descending-variant-solid" data-name=""><path d="M4 3C2.89 3 2 3.89 2 5V9C2 10.11 2.89 11 4 11H8C9.11 11 10 10.11 10 9V5C10 3.89 9.11 3 8 3M8.2 4.5L9.26 5.55L5.27 9.5L2.74 6.95L3.81 5.9L5.28 7.39M4 13C2.89 13 2 13.89 2 15V19C2 20.11 2.89 21 4 21H8C9.11 21 10 20.11 10 19V15C10 13.89 9.11 13 8 13M4 15H8V19H4M12 5H22V7H12M12 19V17H22V19M12 11H22V13H12Z"></path></svg></span><span class="text">Your Orders</span></a></li>
						<?php } ?>

						<?php
							// order link class
							$seo_rankings_class = "";
							if ($page_slug == '/seo-manager/rankings/') {
								$seo_rankings_class = "is-active";
							}
						?>
						<li class="<?php echo $seo_rankings_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/rankings/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-chevron-triple-up-solid" data-name=""><path d="M16.59,9.42L12,4.83L7.41,9.42L6,8L12,2L18,8L16.59,9.42M16.59,15.42L12,10.83L7.41,15.42L6,14L12,8L18,14L16.59,15.42M16.59,21.42L12,16.83L7.41,21.42L6,20L12,14L18,20L16.59,21.42Z"></path></svg></span><span class="text">Rank Tracker</span></a></li>
						
						<?php
							// if($view_as != 'user'){
								// seo strategy class
								$seo_strategy_class = "";
								if ($page_slug == '/seo-manager/seo-strategy/') {
									$seo_strategy_class = "is-active";
								}
						?>
								<li class="<?php echo $seo_strategy_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li>
						<?php //} ?>

						<?php
							// todos
							$todos_class = "";
							if ($page_slug == '/seo-manager/todos/' || $page_slug == '/seo-manager/todos/list/') {
								$todos_class = "is-active";
							}
						?>
						<li class="<?php echo $todos_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/todos/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-format_list_bulleted-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M7 5h14v2H7z"></path><circle cx="4" cy="6" r="1.5"></circle><path d="M7 11h14v2H7zm0 6h14v2H7zm-3 2.5c.82 0 1.5-.68 1.5-1.5s-.67-1.5-1.5-1.5-1.5.68-1.5 1.5.68 1.5 1.5 1.5z"></path><circle cx="4" cy="12" r="1.5"></circle></svg></span><span class="text">Todos</span></a></li>


						<?php
						if($view_as != 'user'){
							// order link class
							$seo_learning_class = "";
							if ($page_slug == '/seo-manager/seo-learning/') {
								$seo_learning_class = "is-active";
							}
						?>
							<li class="<?php echo $seo_learning_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-learning/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-info-circle-solid" data-name=""><path d="M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"></path></svg></span><span class="text">SEO Learning</span></a></li>
						<?php } ?>
						<?php
							// report history class
							$report_history_class = "";
							if ($page_slug == '/seo-manager/report-history/') {
								$report_history_class = "is-active";
							}
						?>
						<li class="<?php echo $report_history_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/report-history/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-file-chart-outlined" data-name=""><path d="M14 2H6C4.9 2 4 2.9 4 4V20C4 21.1 4.9 22 6 22H18C19.1 22 20 21.1 20 20V8L14 2M18 20H6V4H13V9H18V20M9 13V19H7V13H9M15 15V19H17V15H15M11 11V19H13V11H11Z"></path></svg></span><span class="text">Report History</span></a></li>

						<?php
							/* // seo strategy class
							$seo_strategy_class = "";
							if ($page_slug == '/seo-manager/seo-strategy/') {
								$seo_strategy_class = "is-active";
							} */
						?>
						<!-- <li class="<?php //echo $seo_strategy_class; ?>"><a href="<?php //echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li> -->

						<?php
							// tools
							$tools_class = "";
							if ($page_slug == '/seo-manager/tools/' || $page_slug == '/seo-manager/tools/backlink-checker/' || $page_slug == '/seo-manager/tools/domain-authority-checker/' || $page_slug == '/seo-manager/tools/wordcount/' || $page_slug == '/seo-manager/tools/anchor-count/') {
								$tools_class = "is-active active";
							}
						?>
						<li class="<?php echo $tools_class; ?> menu-item-has-children"><a href=""><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-tools-solid" data-name=""><path d="M21.71 20.29L20.29 21.71A1 1 0 0 1 18.88 21.71L7 9.85A3.81 3.81 0 0 1 6 10A4 4 0 0 1 2.22 4.7L4.76 7.24L5.29 6.71L6.71 5.29L7.24 4.76L4.7 2.22A4 4 0 0 1 10 6A3.81 3.81 0 0 1 9.85 7L21.71 18.88A1 1 0 0 1 21.71 20.29M2.29 18.88A1 1 0 0 0 2.29 20.29L3.71 21.71A1 1 0 0 0 5.12 21.71L10.59 16.25L7.76 13.42M20 2L16 4V6L13.83 8.17L15.83 10.17L18 8H20L22 4Z"></path></svg></span><span class="text">Tools</span></a>
							
							<ul class="sub-menu">
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/backlink-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-variant-solid" data-name=""><path d="M10.59,13.41C11,13.8 11,14.44 10.59,14.83C10.2,15.22 9.56,15.22 9.17,14.83C7.22,12.88 7.22,9.71 9.17,7.76V7.76L12.71,4.22C14.66,2.27 17.83,2.27 19.78,4.22C21.73,6.17 21.73,9.34 19.78,11.29L18.29,12.78C18.3,11.96 18.17,11.14 17.89,10.36L18.36,9.88C19.54,8.71 19.54,6.81 18.36,5.64C17.19,4.46 15.29,4.46 14.12,5.64L10.59,9.17C9.41,10.34 9.41,12.24 10.59,13.41M13.41,9.17C13.8,8.78 14.44,8.78 14.83,9.17C16.78,11.12 16.78,14.29 14.83,16.24V16.24L11.29,19.78C9.34,21.73 6.17,21.73 4.22,19.78C2.27,17.83 2.27,14.66 4.22,12.71L5.71,11.22C5.7,12.04 5.83,12.86 6.11,13.65L5.64,14.12C4.46,15.29 4.46,17.19 5.64,18.36C6.81,19.54 8.71,19.54 9.88,18.36L13.41,14.83C14.59,13.66 14.59,11.76 13.41,10.59C13,10.2 13,9.56 13.41,9.17Z"></path></svg></span><span class="text">Backlink Checker</span></a></li>
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/domain-authority-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-search-web-solid" data-name=""><path d="M15.5,14L20.5,19L19,20.5L14,15.5V14.71L13.73,14.43C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.43,13.73L14.71,14H15.5M9.5,4.5L8.95,4.53C8.71,5.05 8.34,5.93 8.07,7H10.93C10.66,5.93 10.29,5.05 10.05,4.53C9.87,4.5 9.69,4.5 9.5,4.5M13.83,7C13.24,5.97 12.29,5.17 11.15,4.78C11.39,5.31 11.7,6.08 11.93,7H13.83M5.17,7H7.07C7.3,6.08 7.61,5.31 7.85,4.78C6.71,5.17 5.76,5.97 5.17,7M4.5,9.5C4.5,10 4.58,10.53 4.73,11H6.87L6.75,9.5L6.87,8H4.73C4.58,8.47 4.5,9 4.5,9.5M14.27,11C14.42,10.53 14.5,10 14.5,9.5C14.5,9 14.42,8.47 14.27,8H12.13C12.21,8.5 12.25,9 12.25,9.5C12.25,10 12.21,10.5 12.13,11H14.27M7.87,8L7.75,9.5L7.87,11H11.13C11.21,10.5 11.25,10 11.25,9.5C11.25,9 11.21,8.5 11.13,8H7.87M9.5,14.5C9.68,14.5 9.86,14.5 10.03,14.47C10.28,13.95 10.66,13.07 10.93,12H8.07C8.34,13.07 8.72,13.95 8.97,14.47L9.5,14.5M13.83,12H11.93C11.7,12.92 11.39,13.69 11.15,14.22C12.29,13.83 13.24,13.03 13.83,12M5.17,12C5.76,13.03 6.71,13.83 7.85,14.22C7.61,13.69 7.3,12.92 7.07,12H5.17Z"></path></svg></span><span class="text">Domain Authority Checker</span></a></li>
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/wordcount/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-text-box-outlined" data-name=""><path d="M5,3C3.89,3 3,3.89 3,5V19C3,20.11 3.89,21 5,21H19C20.11,21 21,20.11 21,19V5C21,3.89 20.11,3 19,3H5M5,5H19V19H5V5M7,7V9H17V7H7M7,11V13H17V11H7M7,15V17H14V15H7Z"></path></svg></span><span class="text">Word Count</span></a></li>
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/anchor-count/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Anchor Count</span></a></li>
								<!-- <li><a href="<?php //echo site_url(); ?>/seo-manager/tools/content-readability/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Content Readability</span></a></li> -->
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/ssl-certificate-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-shield-lock-outlined" data-name=""><path d="M21,11C21,16.55 17.16,21.74 12,23C6.84,21.74 3,16.55 3,11V5L12,1L21,5V11M12,21C15.75,20 19,15.54 19,11.22V6.3L12,3.18L5,6.3V11.22C5,15.54 8.25,20 12,21M14.8,11V9.5C14.8,8.1 13.4,7 12,7C10.6,7 9.2,8.1 9.2,9.5V11C8.6,11 8,11.6 8,12.2V15.7C8,16.4 8.6,17 9.2,17H14.7C15.4,17 16,16.4 16,15.8V12.3C16,11.6 15.4,11 14.8,11M13.5,11H10.5V9.5C10.5,8.7 11.2,8.2 12,8.2C12.8,8.2 13.5,8.7 13.5,9.5V11Z"></path></svg></span><span class="text">SSL Checker</span></a></li>
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/keyword-density/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-format-text-rotation-down-vertical-solid" data-name=""><path d="M15.25 4H13.75L9 15H11.1L12 12.8H17L17.9 15H20L15.25 4M12.63 11L14.5 6L16.37 11H12.63M5 17.5L8 14.5H6V2H4V14.5H2L5 17.5M22 20L19 17V19H6.5V21H19V23L22 20Z"></path></svg></span><span class="text">Keyword Density</span></a></li>
								<!-- <li><a href="<?php //echo site_url(); ?>/seo-manager/tools/keyword-extraction/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Keyword Extraction</span></a></li> -->
								<li><a href="<?php echo site_url(); ?>/seo-manager/tools/conversion-rate-calculator/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-calculator-variant-solid" data-name=""><path d="M9,2H4A2,2 0 0,0 2,4V9A2,2 0 0,0 4,11H9A2,2 0 0,0 11,9V4A2,2 0 0,0 9,2M9,7H4V6H9V7M20,13H15A2,2 0 0,0 13,15V20A2,2 0 0,0 15,22H20A2,2 0 0,0 22,20V15A2,2 0 0,0 20,13M20,19H15V18H20V19M20,17H15V16H20V17M20,2H15A2,2 0 0,0 13,4V9A2,2 0 0,0 15,11H20A2,2 0 0,0 22,9V4A2,2 0 0,0 20,2M20,7H18V9H17V7H15V6H17V4H18V6H20V7M9,13H4A2,2 0 0,0 2,15V20A2,2 0 0,0 4,22H9A2,2 0 0,0 11,20V15A2,2 0 0,0 9,13M8.62,18.91L7.91,19.62L6.5,18.21L5.09,19.62L4.38,18.91L5.79,17.5L4.38,16.09L5.09,15.38L6.5,16.79L7.91,15.38L8.62,16.09L7.21,17.5L8.62,18.91Z"></path></svg></span><span class="text">Conversion Rate Calculator</span></a></li>
							</ul>
						</li>

						<?php
							if($view_as != 'user'){
								// payment link class
								$payment_class = "";
								if ($page_slug == '/seo-manager/payment-methods/' || $page_slug == '/seo-manager/add-payment-method/') {
									$payment_class = "is-active";
								}
						?>
								<li class="<?php echo $payment_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/payment-methods/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 640 512" data-id="icon-money-check-solid" data-name=""><path d="M0 448c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V128H0v320zm448-208c0-8.84 7.16-16 16-16h96c8.84 0 16 7.16 16 16v32c0 8.84-7.16 16-16 16h-96c-8.84 0-16-7.16-16-16v-32zm0 120c0-4.42 3.58-8 8-8h112c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H456c-4.42 0-8-3.58-8-8v-16zM64 264c0-4.42 3.58-8 8-8h304c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8v-16zm0 96c0-4.42 3.58-8 8-8h176c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8v-16zM624 32H16C7.16 32 0 39.16 0 48v48h640V48c0-8.84-7.16-16-16-16z"></path></svg></span><span class="text">Payment</span></a></li>
						<?php } ?>
					<?php } else if($user_role == "account_manager") { ?>

						<?php
							// customer-information link class
							$assigned_orders_class = "";
							if ($page_slug == '/seo-manager/client-information/' || strpos($page_slug, 'client-information') !== false) {
								$assigned_orders_class = "is-active";
							}
						?>
						<li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/client-information/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-cog-solid" data-name=""><path d="M10 4A4 4 0 0 0 6 8A4 4 0 0 0 10 12A4 4 0 0 0 14 8A4 4 0 0 0 10 4M17 12C16.87 12 16.76 12.09 16.74 12.21L16.55 13.53C16.25 13.66 15.96 13.82 15.7 14L14.46 13.5C14.35 13.5 14.22 13.5 14.15 13.63L13.15 15.36C13.09 15.47 13.11 15.6 13.21 15.68L14.27 16.5C14.25 16.67 14.24 16.83 14.24 17C14.24 17.17 14.25 17.33 14.27 17.5L13.21 18.32C13.12 18.4 13.09 18.53 13.15 18.64L14.15 20.37C14.21 20.5 14.34 20.5 14.46 20.5L15.7 20C15.96 20.18 16.24 20.35 16.55 20.47L16.74 21.79C16.76 21.91 16.86 22 17 22H19C19.11 22 19.22 21.91 19.24 21.79L19.43 20.47C19.73 20.34 20 20.18 20.27 20L21.5 20.5C21.63 20.5 21.76 20.5 21.83 20.37L22.83 18.64C22.89 18.53 22.86 18.4 22.77 18.32L21.7 17.5C21.72 17.33 21.74 17.17 21.74 17C21.74 16.83 21.73 16.67 21.7 16.5L22.76 15.68C22.85 15.6 22.88 15.47 22.82 15.36L21.82 13.63C21.76 13.5 21.63 13.5 21.5 13.5L20.27 14C20 13.82 19.73 13.65 19.42 13.53L19.23 12.21C19.22 12.09 19.11 12 19 12H17M10 14C5.58 14 2 15.79 2 18V20H11.68A7 7 0 0 1 11 17A7 7 0 0 1 11.64 14.09C11.11 14.03 10.56 14 10 14M18 15.5C18.83 15.5 19.5 16.17 19.5 17C19.5 17.83 18.83 18.5 18 18.5C17.16 18.5 16.5 17.83 16.5 17C16.5 16.17 17.17 15.5 18 15.5Z"></path></svg></span><span class="text">Clients</span></a></li>

						<?php /*
							// assigned orders link class
							$assigned_orders_class = "";
							if ($page_slug == '/seo-manager/assigned-orders/' || strpos($page_slug, 'view-order') !== false) {
								$assigned_orders_class = "is-active";
							}
						?>
						<li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/assigned-orders/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-order-bool-descending-variant-solid" data-name=""><path d="M4 3C2.89 3 2 3.89 2 5V9C2 10.11 2.89 11 4 11H8C9.11 11 10 10.11 10 9V5C10 3.89 9.11 3 8 3M8.2 4.5L9.26 5.55L5.27 9.5L2.74 6.95L3.81 5.9L5.28 7.39M4 13C2.89 13 2 13.89 2 15V19C2 20.11 2.89 21 4 21H8C9.11 21 10 20.11 10 19V15C10 13.89 9.11 13 8 13M4 15H8V19H4M12 5H22V7H12M12 19V17H22V19M12 11H22V13H12Z"></path></svg></span><span class="text">Assigned Orders</span></a></li>
						<?php */ ?>

						<?php
							// seo strategy class
							$seo_strategy_class = "";
							if ($page_slug == '/seo-manager/seo-strategy/') {
								$seo_strategy_class = "is-active";
							}
						?>
						<li class="<?php echo $seo_strategy_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li>

						<?php
							// todos
							$todos_class = "";
							if ($page_slug == '/seo-manager/todos/' || $page_slug == '/seo-manager/todos/list/') {
								$todos_class = "is-active";
							}
						?>
						<li class="<?php echo $todos_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/todos/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-format_list_bulleted-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M7 5h14v2H7z"></path><circle cx="4" cy="6" r="1.5"></circle><path d="M7 11h14v2H7zm0 6h14v2H7zm-3 2.5c.82 0 1.5-.68 1.5-1.5s-.67-1.5-1.5-1.5-1.5.68-1.5 1.5.68 1.5 1.5 1.5z"></path><circle cx="4" cy="12" r="1.5"></circle></svg></span><span class="text">Todos</span></a></li>

						
					<?php } else if($user_role == "administrator") { ?>
						<?php
							// seo strategy class
							$seo_managers_view_class = "";
							if ($page_slug == '/seo-manager/managers/' || $page_slug == '/seo-manager/managers/manager/') {
								$seo_managers_view_class = "is-active";
							}
						?>
						<li class="<?php echo $seo_managers_view_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/managers/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-group-solid" data-name=""><path d="M12,5.5A3.5,3.5 0 0,1 15.5,9A3.5,3.5 0 0,1 12,12.5A3.5,3.5 0 0,1 8.5,9A3.5,3.5 0 0,1 12,5.5M5,8C5.56,8 6.08,8.15 6.53,8.42C6.38,9.85 6.8,11.27 7.66,12.38C7.16,13.34 6.16,14 5,14A3,3 0 0,1 2,11A3,3 0 0,1 5,8M19,8A3,3 0 0,1 22,11A3,3 0 0,1 19,14C17.84,14 16.84,13.34 16.34,12.38C17.2,11.27 17.62,9.85 17.47,8.42C17.92,8.15 18.44,8 19,8M5.5,18.25C5.5,16.18 8.41,14.5 12,14.5C15.59,14.5 18.5,16.18 18.5,18.25V20H5.5V18.25M0,20V18.5C0,17.11 1.89,15.94 4.45,15.6C3.86,16.28 3.5,17.22 3.5,18.25V20H0M24,20H20.5V18.25C20.5,17.22 20.14,16.28 19.55,15.6C22.11,15.94 24,17.11 24,18.5V20Z"></path></svg></span><span class="text">SEO Managers</span></a></li>	

						<?php
							// customer-information link class
							$assigned_orders_class = "";
							if ($page_slug == '/seo-manager/client-information/' || strpos($page_slug, 'client-information') !== false) {
								$assigned_orders_class = "is-active";
							}
						?>
						<li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/client-information/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-cog-solid" data-name=""><path d="M10 4A4 4 0 0 0 6 8A4 4 0 0 0 10 12A4 4 0 0 0 14 8A4 4 0 0 0 10 4M17 12C16.87 12 16.76 12.09 16.74 12.21L16.55 13.53C16.25 13.66 15.96 13.82 15.7 14L14.46 13.5C14.35 13.5 14.22 13.5 14.15 13.63L13.15 15.36C13.09 15.47 13.11 15.6 13.21 15.68L14.27 16.5C14.25 16.67 14.24 16.83 14.24 17C14.24 17.17 14.25 17.33 14.27 17.5L13.21 18.32C13.12 18.4 13.09 18.53 13.15 18.64L14.15 20.37C14.21 20.5 14.34 20.5 14.46 20.5L15.7 20C15.96 20.18 16.24 20.35 16.55 20.47L16.74 21.79C16.76 21.91 16.86 22 17 22H19C19.11 22 19.22 21.91 19.24 21.79L19.43 20.47C19.73 20.34 20 20.18 20.27 20L21.5 20.5C21.63 20.5 21.76 20.5 21.83 20.37L22.83 18.64C22.89 18.53 22.86 18.4 22.77 18.32L21.7 17.5C21.72 17.33 21.74 17.17 21.74 17C21.74 16.83 21.73 16.67 21.7 16.5L22.76 15.68C22.85 15.6 22.88 15.47 22.82 15.36L21.82 13.63C21.76 13.5 21.63 13.5 21.5 13.5L20.27 14C20 13.82 19.73 13.65 19.42 13.53L19.23 12.21C19.22 12.09 19.11 12 19 12H17M10 14C5.58 14 2 15.79 2 18V20H11.68A7 7 0 0 1 11 17A7 7 0 0 1 11.64 14.09C11.11 14.03 10.56 14 10 14M18 15.5C18.83 15.5 19.5 16.17 19.5 17C19.5 17.83 18.83 18.5 18 18.5C17.16 18.5 16.5 17.83 16.5 17C16.5 16.17 17.17 15.5 18 15.5Z"></path></svg></span><span class="text">Clients</span></a></li>
					<?php } ?>
				</ul>
				<ul class="sidebar-menu bottom border-top">
					<?php
					if($view_as != 'user'){
						// edit account link class
						$edit_account_class = "";
						if ($page_slug == '/seo-manager/edit-account/') {
							$edit_account_class = "is-active";
						}

						if ($user_role != "account_manager" && $user_role != "administrator") {
					?>
							<li class="<?php echo $edit_account_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/edit-account/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-map-marker-outlined" data-name=""><path d="M12,6.5A2.5,2.5 0 0,1 14.5,9A2.5,2.5 0 0,1 12,11.5A2.5,2.5 0 0,1 9.5,9A2.5,2.5 0 0,1 12,6.5M12,2A7,7 0 0,1 19,9C19,14.25 12,22 12,22C12,22 5,14.25 5,9A7,7 0 0,1 12,2M12,4A5,5 0 0,0 7,9C7,10 7,12 12,18.71C17,12 17,10 17,9A5,5 0 0,0 12,4Z"></path></svg></span><span class="text">Account Details</span></a></li>
						<?php } ?>
					<?php } ?>

					<!-- <li><a href=""><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-circle-outlined" data-name=""><path d="M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M7.07,18.28C7.5,17.38 10.12,16.5 12,16.5C13.88,16.5 16.5,17.38 16.93,18.28C15.57,19.36 13.86,20 12,20C10.14,20 8.43,19.36 7.07,18.28M18.36,16.83C16.93,15.09 13.46,14.5 12,14.5C10.54,14.5 7.07,15.09 5.64,16.83C4.62,15.5 4,13.82 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,13.82 19.38,15.5 18.36,16.83M12,6C10.06,6 8.5,7.56 8.5,9.5C8.5,11.44 10.06,13 12,13C13.94,13 15.5,11.44 15.5,9.5C15.5,7.56 13.94,6 12,6M12,11A1.5,1.5 0 0,1 10.5,9.5A1.5,1.5 0 0,1 12,8A1.5,1.5 0 0,1 13.5,9.5A1.5,1.5 0 0,1 12,11Z"></path></svg></span><span class="text">Addresses</span></a></li> -->

					<li><a href="<?php echo wp_logout_url( get_site_url().'/seo-manager/' ); ?>"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-power-off-solid" data-name=""><path d="M400 54.1c63 45 104 118.6 104 201.9 0 136.8-110.8 247.7-247.5 248C120 504.3 8.2 393 8 256.4 7.9 173.1 48.9 99.3 111.8 54.2c11.7-8.3 28-4.8 35 7.7L162.6 90c5.9 10.5 3.1 23.8-6.6 31-41.5 30.8-68 79.6-68 134.9-.1 92.3 74.5 168.1 168 168.1 91.6 0 168.6-74.2 168-169.1-.3-51.8-24.7-101.8-68.1-134-9.7-7.2-12.4-20.5-6.5-30.9l15.8-28.1c7-12.4 23.2-16.1 34.8-7.8zM296 264V24c0-13.3-10.7-24-24-24h-32c-13.3 0-24 10.7-24 24v240c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24z"></path></svg></span><span class="text">Logout</span></a></li>
				</ul>
			<!-- </div> -->
		</div>
<?php
	return ob_get_clean();
}

/*
 * DASHBOARD OVERVIEW SHORTCODE
 *
 */
require_once( plugin_dir_path( __FILE__ ) . 'inc/dashboard-overview.php' );

add_action( 'wp_ajax__seoManagerDashboardOverviewProjectData', '_seoManagerDashboardOverviewProjectData' ); 
add_action( 'wp_ajax_nopriv__seoManagerDashboardOverviewProjectData', '_seoManagerDashboardOverviewProjectData' ); 
function _seoManagerDashboardOverviewProjectData(){
	// variables
    $project_data       = $_REQUEST['project_data'];
    $project_id         = $project_data["project"];
    $project_user_email = $project_data["user"];
    $project_domain     = $project_data["domain"];
   
    // webceo api
    $webceo_query             = new WEBCEO();
    $project                  = $webceo_query->get_project($project_user_email, $project_domain, $project_id);
    $project_rankings         = $webceo_query->get_rankings($project_id);
    $project_average_rankings = $webceo_query->get_average_rankings($project_id, false);
    $project_site_audit       = $webceo_query->get_site_audit_data($project_id);

    // get average ranking
    $project_average_ranking = "";
    foreach ($project_average_rankings["data"]["avg_rankings"][0] as $key => $value) {
    	$project_average_ranking = $value["pos"];
    }

    if($project_data){
?>
		<div class="do-title">
			<h4>Site Overview for:</h4>
			<h3><a href="https://<?php echo $project["data"]["domain"]; ?>" target="_blank"><?php echo $project["data"]["name"] ? $project["data"]["name"] : $project["data"]["domain"]; ?> <svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-box-variant-outlined" data-name=""><path d="M19,3H5A2,2 0 0,0 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5A2,2 0 0,0 19,3M19,19H5V5H19V19M13.94,10.06C14.57,10.7 14.92,11.54 14.92,12.44C14.92,13.34 14.57,14.18 13.94,14.81L11.73,17C11.08,17.67 10.22,18 9.36,18C8.5,18 7.64,17.67 7,17C5.67,15.71 5.67,13.58 7,12.26L8.35,10.9L8.34,11.5C8.33,12 8.41,12.5 8.57,12.94L8.62,13.09L8.22,13.5C7.91,13.8 7.74,14.21 7.74,14.64C7.74,15.07 7.91,15.47 8.22,15.78C8.83,16.4 9.89,16.4 10.5,15.78L12.7,13.59C13,13.28 13.18,12.87 13.18,12.44C13.18,12 13,11.61 12.7,11.3C12.53,11.14 12.44,10.92 12.44,10.68C12.44,10.45 12.53,10.23 12.7,10.06C13.03,9.73 13.61,9.74 13.94,10.06M18,9.36C18,10.26 17.65,11.1 17,11.74L15.66,13.1V12.5C15.67,12 15.59,11.5 15.43,11.06L15.38,10.92L15.78,10.5C16.09,10.2 16.26,9.79 16.26,9.36C16.26,8.93 16.09,8.53 15.78,8.22C15.17,7.6 14.1,7.61 13.5,8.22L11.3,10.42C11,10.72 10.82,11.13 10.82,11.56C10.82,12 11,12.39 11.3,12.7C11.47,12.86 11.56,13.08 11.56,13.32C11.56,13.56 11.47,13.78 11.3,13.94C11.13,14.11 10.91,14.19 10.68,14.19C10.46,14.19 10.23,14.11 10.06,13.94C8.75,12.63 8.75,10.5 10.06,9.19L12.27,7C13.58,5.67 15.71,5.68 17,7C17.65,7.62 18,8.46 18,9.36Z"></path></svg></a></h3>
		</div>
		<div class="do-content">
			<ul class="do-site-statistics">
				<li>
					<span>Average Rankings</span>
					<strong><?php echo $project_average_ranking; ?></strong>
				</li>
				<li>
					<span>Scanned Pages</span>
					<strong><?php echo $project_site_audit["data"]["scanned_pages"]; ?></strong>
				</li>
				<li>
					<span>Site Optimization</span>
					<strong><?php echo $project_site_audit["data"]["site_optimization"]; ?></strong>
				</li>
			</ul>
			<div class="do-site-keywords">
				<table>
					<thead>
						<tr>
							<th rowspan="2" class="align-bottom">Keyword</th>
							<th rowspan="2" class="align-bottom">Monthly Searches</th>
							<th colspan="<?php echo count($project_rankings["data"]["ranking_data"][0]["positions"]); ?>" class="text-center">Rankings</th>
						</tr>
						<tr>
							<?php
								foreach ($project_rankings["data"]["ranking_data"][0]["positions"] as $key => $value) {
							    	$is_mobile = $value["mobile"] == 1 ? " (Mobile)" : "";
							    	echo "<th>".ucfirst($value["se"]) . $is_mobile."</th>";
							    }
							?>
						</tr>
					</thead>
					<tbody>
						<?php
							foreach ($project_rankings["data"]["ranking_data"] as $key => $value) {
						?>
								<tr>
									<td><?php echo $value["kw"]; ?></td>
									<td><?php echo number_format($value["global_searches"]); ?></td>
									<?php
										foreach ($value["positions"] as $key => $position) {
									?>
											<td><?php echo $position["scan_history"][1]["pos"] == 0 ? "-" : $position["scan_history"][1]["pos"]; ?></td>
									<?php
								    	}
									?>
								</tr>
						<?php
							}
						?>
					</tbody>
				</table>
			</div>
		</div>
<?php
	}

    die();
}

// ADD CUSTOM MENU ITEMS TO SEO MANAGER DASHBOARD
add_filter ( 'woocommerce_account_menu_items', 'dashboardSidebarLinks', 40 );
function dashboardSidebarLinks( $menu_links ){
	// get user data
    // $user = wp_get_current_user();
    // $userRole = $user->roles[0];

    // endpoints
	$menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'rankings' => 'Rankings' ) + array_slice( $menu_links, 5, NULL, true );
	$menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'seo-learning' => 'SEO Learning' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'report-history' => 'Report History' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'assigned-orders' => 'Assigned Orders' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'seo-strategy' => 'SEO Strategy' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'todos' => 'Todos' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'todos/list' => 'Todo' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'client-information' => 'Clients' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'managers' => 'Managers' ) + array_slice( $menu_links, 5, NULL, true );
	
	// tools
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/backlink-checker' => 'Backlink Checker' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/domain-authority-checker' => 'Domain Authority Checker' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/wordcount' => 'Wordcount' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/anchor-count' => 'Anchor Count' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/content-readability' => 'Content Readability' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/ssl-certificate-checker' => 'SSL Checker' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/keyword-density' => 'Keyword Density' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/keyword-extraction' => 'Keyword Extraction' ) + array_slice( $menu_links, 5, NULL, true );
    $menu_links = array_slice( $menu_links, 0, 5, true ) + array( 'tools/conversion-rate-calculator' => 'Conversion Rate Calculator' ) + array_slice( $menu_links, 5, NULL, true );
}
// REGISTER CUSTOM SIDEBAR LINK ENDPOINTS
add_action( 'init', '_cstmMyAccountTabLinkEndpoint' );
function _cstmMyAccountTabLinkEndpoint() {
    add_rewrite_endpoint( 'rankings', EP_PAGES );
    add_rewrite_endpoint( 'seo-learning', EP_PAGES );
    add_rewrite_endpoint( 'report-history', EP_PAGES );
    add_rewrite_endpoint( 'assigned-orders', EP_PAGES );
    add_rewrite_endpoint( 'seo-strategy', EP_PAGES );
    add_rewrite_endpoint( 'todos', EP_PAGES );
    add_rewrite_endpoint( 'todos/list', EP_PAGES );
    add_rewrite_endpoint( 'client-information', EP_PAGES );
    add_rewrite_endpoint( 'managers', EP_PAGES );
    // add_rewrite_endpoint( 'assigned-orders', EP_PAGES );
    // add_rewrite_endpoint( 'seo-strategies', EP_PAGES );
	
	// tools
    add_rewrite_endpoint( 'tools/backlink-checker', EP_PAGES );
    add_rewrite_endpoint( 'tools/domain-authority-checker', EP_PAGES );
    add_rewrite_endpoint( 'tools/wordcount', EP_PAGES );
    add_rewrite_endpoint( 'tools/anchor-count', EP_PAGES );
    add_rewrite_endpoint( 'tools/content-readability', EP_PAGES );
    add_rewrite_endpoint( 'tools/ssl-certificate-checker', EP_PAGES );
    add_rewrite_endpoint( 'tools/keyword-density', EP_PAGES );
    add_rewrite_endpoint( 'tools/keyword-extraction', EP_PAGES );
    add_rewrite_endpoint( 'tools/conversion-rate-calculator', EP_PAGES );
}

class WEBCEO {
	// api link
	// https://seo-tools.seoi.co.uk/help-center/api/seo-api-reference.html

	// private variables
	private $_endpoint = "https://seo-tools.seoi.co.uk/api/";
	private $_apikey   = "a3f36b7e0caa64733a";

	// public variables
	public $user_email;
	public $project_domain;
	public $project_id;

	// get all webceo projects
	public function get_projects(){
		return $this->get_data(array(
			"method" => "get_projects",
			"key"    => $this->_apikey,
			"user"   => ""
 		));
	}

	// get specific project
	public function get_project($user_email, $project_domain, $project_id){
		return $this->get_data(array(
			"method" => "get_project",
			"key"    => $this->_apikey,
			"data"   => array(
				"user"    => $user_email,
				"domain"  => $project_domain,
				"project" => $project_id
			)
		));
	}

	// get project rankings
	public function get_rankings($project_id){
		return $this->get_data(array(
			"method" => "get_rankings",
			"key"    => $this->_apikey,
			"data"   => array(
				"project" => $project_id
			)
		));
	}

	// get project average rankings
	public function get_average_rankings($project_id, $starred){
		// starred keywords 0 (False) or 1 (True)
		$starred = $starred ? true : false;
		return $this->get_data(array(
			"method" => "get_average_rankings",
			"key"    => $this->_apikey,
			"data"   => array(
				"project" => $project_id,
				"starred_keywords" => $starred
			)
		));
	}

	// get list of keywords that are configured in the Rank Tracking settings of the project
	public function get_rankings_keywords($project_id){
		return $this->get_data(array(
			"method" => "get_rankings_keywords",
			"key"    => $this->_apikey,
			"data"   => array(
				"project" => $project_id
			)
		));
	}

	// get site audit & landing page seo data
	public function get_site_audit_data($project_id){
		return $this->get_data(array(
			"method" => "get_site_audit_data",
			"key"    => $this->_apikey,
			"data"   => array(
				"project" => $project_id
			)
		));
	}

	// curl function to fetch webceo data depending on the api method
	private function get_data($data){
	    $ch = curl_init( $this->_endpoint );
	    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
	    curl_setopt($ch, CURLOPT_POSTFIELDS, "json=".urlencode(json_encode($data)));
	    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
	    $result = curl_exec($ch);
	    $json_result = json_decode($result, True)[0];

	    return $json_result;
	}
}

// if (current_user_can('administrator')) {
	class NEW_SEOI_GOOGLE{
		// private variables
		private $_token_endpoint = "https://oauth2.googleapis.com/token";
		private $_redirect_url   = "https://seoi.io/seo-manager";
		private $_api_key        = "AIzaSyAe7A9yi7ad8yaVpiz__4q8PR2NZZoK7rs";
		private $_client_id      = "127200449562-uhkammqg8jsdcejvc2rhlv0fd1kcr6a3.apps.googleusercontent.com";
		private $_client_secret  = "u9FY9WnJyFr4WaECHT8C7ryG";

		// public variables
		public $code;
		public $access_token;
		public $refresh_token;
		public $website;
		public $start_date;
		public $end_date;
		public $file_data;
		public $file_dir;
		public $query_num;
		public $data;
		public $additional_data;
		public $keywords;
		public $keyword;
		public $type;

		// google variables
		public $curl_url;
		public $curl_type;
		public $curl_data;
		public $curl_data_type;
		private $_google_folder_id = "1-Cbnk1-0NW7r3__3M8bgquYOzUhuvGCa";
		public $google_folder_name;
		public $google_file_directory;
		public $google_file_id;
		public $google_file_name;
		public $google_file_path;

		// google appsheets variables
		public $appsheet_data;
		private $_appsheet_app_id     = "d739e0e3-0463-4c46-a22d-9f8caf1a06ee";
    	private $_appsheet_access_key = "V2-oFeK5-O7ChG-32unI-0Rspn-V0qog-kpwhV-5j8ga-Qvn7O";
    	private $_appsheet_table_name = "To%20do";
		// public $appsheet_app_id;
		// public $appsheet_access_key;
		// public $appsheet_table_name;

		// get code for access and refresh tokens
		public function oauth_link($extra_parameter = NULL){
			$page_link = (isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? "https" : "http") . "://$_SERVER[HTTP_HOST]$_SERVER[REQUEST_URI]";

			// $auth_params = '{ "b" : "a" , }';
			// $auth_params = base64UrlDecode($auth_params);
			// $auth_params = base64UrlEncode('{ "b" : "a" , "page_link" : "'.$page_link.'" }');

		/* 	// url encode the page link
			$page_link = urlencode($page_link);

			echo "<pre>";
			// var_dump(base64UrlEncode('{ "b" : "a" , "page_link" : "'.$page_link.'" }'));
			var_dump($page_link);
			echo "</pre>";
 */
			// get additional query string parameters
			// $extra_parameter = $extra_parameter ? "&".$extra_parameter : "";

			// return 'https://accounts.google.com/o/oauth2/v2/auth?scope=https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.file+https://www.googleapis.com/auth/webmasters%20https://www.googleapis.com/auth/webmasters.readonly&access_type=offline&include_granted_scopes=true&response_type=code&state='.$page_link.';&redirect_uri='.$this->_redirect_url.'&client_id='.$this->_client_id.'&prompt=consent';
			return 'https://accounts.google.com/o/oauth2/v2/auth?scope=https://www.googleapis.com%2Fauth%2Fdrive%20https://www.googleapis.com%2Fauth%2Fdrive.appdata%20https://www.googleapis.com%2Fauth%2Fdrive.file%20https://www.googleapis.com%2Fauth%2Fdrive.metadata%20https://www.googleapis.com%2Fauth%2Fdrive.metadata.readonly%20https://www.googleapis.com%2Fauth%2Fdrive.photos.readonly%20https://www.googleapis.com%2Fauth%2Fdrive.readonly%20https://www.googleapis.com/auth/webmasters%20https://www.googleapis.com/auth/webmasters.readonly&access_type=offline&include_granted_scopes=true&response_type=code&state='.$page_link.'&redirect_uri='.$this->_redirect_url.'&client_id='.$this->_client_id.'&prompt=consent';

			// https://www.googleapis.com/auth/drive https://www.googleapis.com/auth/drive.appdata https://www.googleapis.com/auth/drive.file https://www.googleapis.com/auth/drive.metadata https://www.googleapis.com/auth/drive.metadata.readonly https://www.googleapis.com/auth/drive.photos.readonly https://www.googleapis.com/auth/drive.readonly

			// ttps://accounts.google.com/o/oauth2/iframerpc?action=issueToken&response_type=token&login_hint=AJDLj6KgV9kdAd77_xP7rgZrlfgtRsMzUCYtWNP_GEe92U4cX09PFIK3N1upJJhBwHF9ZfppOzH2_WMXGsOUHDnJQq_3uuZGc2oKBuIJ5_OJQtmsGkX4Ewg&client_id=292824132082.apps.googleusercontent.com&origin=https%3A%2F%2Fexplorer.apis.google.com&scope=https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.appdata%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.file%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.metadata%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.metadata.readonly%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.photos.readonly%20https%3A%2F%2Fwww.googleapis.com%2Fauth%2Fdrive.readonly&ss_domain=https%3A%2F%2Fexplorer.apis.google.com&include_granted_scopes=false
		}

		// get list of Google Search Console assigned sites
		public function get_site_list(){

			// the site list is saved to the admin user
			// $site_list = get_user_meta(1, "user_sc_site_list", true); 

			// get the access and refresh tokens
			// $access_token = $this->get_tokens("access");

			// check if there is no site list
			// if (!$site_list) {

				// get the site list from the Google Search Console API
				// $site_list = $this->generate_site_list($access_token);
				$access_token = isset($access_token) ? $access_token : '';
				$site_list = $this->generate_site_list($access_token);
			// }

			// return the Google Search Console site list
			return $site_list;
		}

		/* // get Google Search Console data from specific website
		public function get_site_data($website, $start_date, $end_date, $query_num, $original_website){

			// use the origginal url as the folder name
			$website_url = preg_replace('/^(http(s)?:\/\/)/', '', $original_website);

			// 
			$file_name  = $website."-".$start_date."-to-".$end_date.".csv";
			$root_dir   = $_SERVER['DOCUMENT_ROOT'];
		    // $report_dir = str_replace("public_html", "", $root_dir)."seoi_reports/";
			$report_dir = $root_dir."/"."reports/";
		    $site_dir   = $report_dir.$website_url."/";
		    $file_dir   = $site_dir.$file_name;

		    // main report directory
		    if (!file_exists($report_dir)) {
		        mkdir($report_dir);
		    }

		    // site report directory
		    if (!file_exists($site_dir)) {
		        mkdir($site_dir);
				writeht("seoi.io", $site_dir);
		    }

		    // check if the csv report already exists
			if (!file_exists($file_dir)){

				// get the access and refresh tokens
				$access_token = $this->get_tokens("access");

				// generate new site data from Google Search Console
				$site_data = $this->generate_site_data(
					$access_token,
					$website,
					$start_date,
					$end_date,
					$query_num,
					$file_dir
				);
			} else {

				// get the file if it already exists
			    // no need to go through Google Search console again
			    $site_data = csv_to_multidimension_array($file_dir);
			}

			// return the Google Search Console site list
			return $site_data;
		} */

		/* // get data from a list of keywords
		public function get_keyword_data($website, $start_date, $end_date, $keywords, $keyword_count, $type, $original_url){

			// use the origginal url as the folder name
			$website_url = preg_replace('/^(http(s)?:\/\/)/', '', $original_url);

			// 
			$file_name  = $website."-".$start_date."-to-".$end_date.".csv";
			$root_dir   = $_SERVER['DOCUMENT_ROOT'];
		    // $report_dir = str_replace("public_html", "", $root_dir)."seoi_reports/";
			$report_dir = $root_dir."/"."reports/";
		    $site_dir   = $report_dir.$website_url."/";
		    $file_dir   = $site_dir.$file_name;


			// type is the type of report we will generate 
			if ($type) {

			    // save data of the generated report
				$report_date = date("Y-m-d H:m");
				
				$type_data = get_user_meta(1, "generated_report", true);
				if (!is_array($type_data)) {
					$type_data = [];
				}
				$type_data[$website][$type] = array(
					"report_date" => $report_date,
					"website"     => $website,
					"start_date"  => $start_date,
					"end_date"    => $end_date,
					"file_dir"    => $file_dir
				);
				update_user_meta(1, "generated_report", $type_data); 
			}



		    // check if there are keywords
		    if ($keywords) {

				// 
				$keyword_data = [];

			    // main report directory
			    if (!file_exists($report_dir)) {
			        mkdir($report_dir);
			    }

			    // site report directory
			    if (!file_exists($site_dir)) {
			        mkdir($site_dir);
					writeht("seoi.co.uk", $site_dir);
			    }

			    // check if the keyword has been updated
				// remove the old csv if there's new keywords
				if ($keyword_count != count($keywords)) {

					// check if the file exists
					if (file_exists($file_dir)){

						// delete if it exists
						unlink($file_dir);
					}
				}

			    // check if the csv report already exists
				if (!file_exists($file_dir)){

					// get the access and refresh tokens
					$access_token = $this->get_tokens("access");

					// 
					$keyword_arr = [];

					// loop through available keywords
					foreach ($keywords as $key => $keyword) {

						// generate the data from Google Search Console api per keyword
						$k = $this->generate_keyword_data(
							$access_token,
							$website,
							$start_date,
							$end_date,
							$file_dir,
							$keyword
						);

						// 
						if ($k) {
							$keyword_arr[] = $k;
						}
					}

					// restructure array for initial get
					foreach ($keyword_arr as $key => $data) {

						// 
						foreach ($data["rows"] as $key => $value) {

							$keyword_data[] = array(
								$value["keys"][0], // keyword
				    			$value["clicks"],
				    			$value["impressions"],
				    			$value["ctr"], // click through rate
				    			$value["position"]
							);
						}
					}

					// save the data to csv
					$this->save_data_to_csv($keyword_arr, $file_dir, "keyword-data");
				} else {

					// get the file if it already exists
				    // no need to go through Google Search console again
				    $keyword_data = csv_to_multidimension_array($file_dir);
				}

				return $keyword_data;
		    } else {
		    	return false;
		    } // end keywords
		} */

		// validate the data, return refreshed data and regenerate expired tokens
		public function validate_data($data, $type, $additional_data = NULL){

			// generate new tokens
			if (isset($data["error"])) {
				// get the access and refresh tokens
				$refresh_token = $this->get_tokens("refresh");

				// get the new tokens
				$tokens       = $this->generate_new_tokens($refresh_token);
				$access_token = $tokens["access_token"];
			}

			// return Google Search Console site list data
			if ($type == "site-list" && isset($data["error"])) {

				// get the new data if you have the new access token
				$data = $this->generate_site_list($access_token);

				// save search console site list to admin user
				// user 1 for admin
				update_user_meta(1, "user_sc_site_list", $data);
			} elseif ($type == "site-data" && isset($data["error"])) {

				// get the new data if you have the new access token
				$data = $this->generate_site_data(
					$access_token,
					$additional_data["website"],
					$additional_data["start_date"],
					$additional_data["end_date"],
					$additional_data["query_num"],
				);

				// save data to csv
			    // this will generate and save a csv file with all the data
			    // $this->save_data_to_csv($data, $additional_data["file_dir"], "site-data");
			} elseif ($type == "keyword-data" && isset($data["error"])) {

				// get the new data if you have the new access token
				$data = $this->generate_keyword_data(
					$access_token,
					$additional_data["website"],
					$additional_data["start_date"],
					$additional_data["end_date"],
					$additional_data["file_dir"],
					$additional_data["keyword"],
				);
			}

			// return validated data
			return $data;
		}

		// get the access and refresh tokens
		// $token_type can be "access" or "refresh"
		public function get_tokens($token_type){

			// the tokens are saved to the admin user
			$tokens = get_user_meta(1, "user_tokens", true);

			// check if there are existing tokens
			if (isset($tokens["access_token"]) || isset($tokens["refresh_token"])) {
				
				// get requested token
				// if token type is empty return all tokens
				$token = $token_type ? $tokens[$token_type."_token"] : $tokens;

				// return requested token
				return $token;
			} else {

				// you should generate new tokens
				return false;
			}
		}

		// get the access and refresh token from google oauth2
		public function generate_tokens($code){

			// 
			$user_code = get_user_meta(1, "user_sc_code", true);

			if ($user_code["code"] != $code) {

				$ch = curl_init($this->_token_endpoint);
			    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
			    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
			    	'Content-Type: application/x-www-form-urlencoded'
			    ));
			    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
			    	"code"          => $code,
					"client_id"     => $this->_client_id,
					"client_secret" => $this->_client_secret,
					"redirect_uri"  => $this->_redirect_url,
					"access_type "  => "offline",
					"grant_type"    => "authorization_code"
			    )));
			    $result = curl_exec($ch);
			    $result = json_decode($result, true);
			    curl_close($ch);

			    if (!isset($result["error"])) {
				    // save access and refresh token
					update_user_meta(1, "user_tokens", array(
						"access_token"  => $result["access_token"],
						"refresh_token" => $result["refresh_token"],
					));
			    }

				// save user code for validation
				// if the user code is the same as the saved on we don't need to generate a new token
				update_user_meta(1, "user_sc_code", array(
					"code" => $code,
				));

			    return $result;
			}
		}

		// get another access token if the current one is expired using the stored refresh token
		public function generate_new_tokens($refresh_token){
			$ch = curl_init($this->_token_endpoint);

		    curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "POST");
		    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
		    curl_setopt($ch, CURLOPT_HTTPHEADER, array(
		    	'Content-Type: application/x-www-form-urlencoded'
		    ));
		    curl_setopt($ch, CURLOPT_POSTFIELDS, http_build_query(array(
				"client_id"     => $this->_client_id,
				"client_secret" => $this->_client_secret,
				"grant_type"    => "refresh_token",
				"refresh_token" => $refresh_token
		    )));
		    $result = curl_exec($ch);
			$result = json_decode($result, true);
			curl_close($ch);

			// save access and refresh token
			if (!isset($result["error"])) {
				update_user_meta(1, "user_tokens", array(
					"access_token"  => $result["access_token"],
					"refresh_token" => $refresh_token
				)); // user 1 for admin
			}

		    return $result;
		}

		// fetch list of sites for the $domain_url
		public function generate_site_list($access_token = NULL){
			$curl = curl_init();

			$access_token = $this->get_tokens("access");

			curl_setopt_array($curl, array(
				CURLOPT_URL            => 'https://searchconsole.googleapis.com/webmasters/v3/sites',
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING       => '',
				CURLOPT_MAXREDIRS      => 10,
				CURLOPT_TIMEOUT        => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST  => 'GET',
				CURLOPT_HTTPHEADER     => array(
				    'Authorization: Bearer ' . $access_token
				),
			));

			$response = curl_exec($curl);
			$result   = json_decode($response, true);
			curl_close($curl);

			// validate data, generate tokens if expired and return data
			return $this->validate_data($result, "site-list");
		}

		/*
		 * 
		 * Google Search Console API
		 * https://developers.google.com/webmaster-tools/v1/searchanalytics/query
		 * 
		 * Get search analytics data for the given site.
		 * 
		 * @param string $access_token
		 * @param string $website
		 * @param string $start_date YYYY-MM-DD
		 * @param string $end_date YYYY-MM-DD
		 * @param string $row_limit
		 * @param string $file_dior
		 * 
		 * @return array
		 * 
		 */
		public function generate_site_data($access_token = NULL, $website, $start_date, $end_date, $row_limit, $file_dir = NULL, $start_row = NULL){

			$curl = curl_init();

			// start row
			$start_row = $start_row ? $start_row : 0;
			// 
            // $access_token = $this->get_tokens("access");

			// get the access and refresh tokens
		/* 	$refresh_token = $this->get_tokens("refresh");
		
			// generate new access token using the refresh token
			$this->generate_new_tokens($refresh_token); */

			// 
            $access_token = $this->get_tokens("access");

			// start date and end date format: YYYY-MM-DD
			curl_setopt_array($curl, array(
			  	CURLOPT_URL            => 'https://www.googleapis.com/webmasters/v3/sites/'.$website.'/searchAnalytics/query',
			  	CURLOPT_RETURNTRANSFER => true,
			  	CURLOPT_ENCODING       => '',
			  	CURLOPT_MAXREDIRS      => 10,
			  	CURLOPT_TIMEOUT        => 60,
			  	CURLOPT_FOLLOWLOCATION => true,
			  	CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			  	CURLOPT_CUSTOMREQUEST  => 'POST',
			  	CURLOPT_POSTFIELDS     =>'{
				    "type": "web",
				    "startDate": "'.$start_date.'",
				    "endDate": "'.$end_date.'",
				    "rowLimit": "'.$row_limit.'",
				    "startRow": "'.$start_row.'",
				    "dimensions": ["QUERY"],
				    "dimensionFilterGroups": [{
				    	"filters": [{
				    		"dimension": "COUNTRY",
				    		"expression": "gbr"
				    	}]
				    }]
				}',
			  	CURLOPT_HTTPHEADER => array(
			    	'Authorization: Bearer ' . $access_token,
			    	'Content-Type: text/plain'
			  	),
			));

			$response = curl_exec($curl);
			$result   = json_decode($response, true);
			curl_close($curl);

			/* // return $result;
			echo "<pre>";
			var_dump($result);
			echo "</pre>";
			// die(); */

			$query_num = isset($query_num) ? $query_num : '';

			// generate additional data for validation
			$additional_data = array(
				"website"    => $website,
				"start_date" => $start_date,
				"end_date"   => $end_date,
				"query_num"  => $query_num,
				"file_dir"   => $file_dir,
			);

			// validate data, generate tokens if expired and return data
			return $this->validate_data($result, "site-data", $additional_data);
		}

		public function generate_keyword_data($access_token, $website, $start_date, $end_date, $file_dir, $keyword){
			$curl = curl_init();

			// start date and end date format: YYYY-MM-DD
			curl_setopt_array($curl, array(
			  	CURLOPT_URL            => 'https://www.googleapis.com/webmasters/v3/sites/'.$website.'/searchAnalytics/query',
			  	CURLOPT_RETURNTRANSFER => true,
			  	CURLOPT_ENCODING       => '',
			  	CURLOPT_MAXREDIRS      => 10,
			  	CURLOPT_TIMEOUT        => 0,
			  	CURLOPT_FOLLOWLOCATION => true,
			  	CURLOPT_HTTP_VERSION   => CURL_HTTP_VERSION_1_1,
			  	CURLOPT_CUSTOMREQUEST  => 'POST',
			  	CURLOPT_POSTFIELDS     =>'{
				    "type": "web",
				    "startDate": "'.$start_date.'",
				    "endDate": "'.$end_date.'",
				    "dimensions": ["QUERY"],
				    "dimensionFilterGroups": [{
				    	"filters": [
				    		{
				    			"dimension": "COUNTRY",
				    			"expression": "gbr"
				    		},
				    		{
				    			"dimension": "QUERY",
				    			"operator": "EQUALS",
				    			"expression": "'.$keyword.'"
				    		}
				    	]
				    }]
				}',
			  	CURLOPT_HTTPHEADER => array(
			    	'Authorization: Bearer ' . $access_token,
			    	'Content-Type: text/plain'
			  	),
			));

			$response = curl_exec($curl);
			$result   = json_decode($response, true);
			curl_close($curl);

			// generate additional data for validation
			$additional_data = array(
				"website"    => $website,
				"start_date" => $start_date,
				"end_date"   => $end_date,
				"file_dir"   => $file_dir,
				"keyword"    => $keyword
			);

			return $this->validate_data($result, "keyword-data", $additional_data);
		}

		public function save_data_to_csv($file_data, $file_dir, $type){

			// generate csv file
		    $fd = fopen($file_dir, "w");

		    // check if data exists
		    if ($file_data && $type == "site-data") {

		    	// loop through the data from Google search console
		    	foreach ($file_data["rows"] as $key => $data) {
		    		$line_data = array(
		    			$data["keys"][0], // keyword
		    			// $data["keys"][1], // date
		    			$data["clicks"],
		    			$data["impressions"],
		    			$data["ctr"], // click through rate
		    			$data["position"]
		    		);

		    		// insert data into the csv
		    		fputcsv($fd, $line_data); 
		    	}
		    } else if ($file_data && $type == "keyword-data"){

		    	// loop through the data from Google search console
		    	foreach ($file_data as $key => $data) {

		    		foreach ($data["rows"] as $key => $value) {

			    		// insert data into the csv
			    		fputcsv($fd, array(
			    			$value["keys"][0], // keyword
			    			$value["clicks"],
			    			$value["impressions"],
			    			$value["ctr"], // click through rate
			    			$value["position"]
			    		)); 
		    		}
		    	}
		    }

		    // close file
		    fclose($fd);
		}

		public function validate_website($website){

			// 
			$site_list   = $this->get_site_list();
			$website_url = false;

			// ob_start();

			// check if the order website url is in the list of website urls
			if ($website) {
				$website = parse_url(rtrim(str_replace("www.", "", $website), "/"));
				$website = isset($website["host"]) ? $website["host"] : $website["path"];

				// loop through the search console site list
				foreach ($site_list["siteEntry"] as $key => $site) {

					// check permission
					if($site["permissionLevel"] == "siteOwner" || $site["permissionLevel"] == "siteFullUser"){

						// check if the order website url exists in the site_list
						if (strpos($site["siteUrl"], $website) !== false) {

							// google search console api requires the site url specified in the site list
							$website_url = urlencode($site["siteUrl"]);
						}
					}
				}
			}

			/* echo "<pre>";
			var_dump($site_list["siteEntry"]);
			var_dump($website);
			var_dump($website_url);
			echo "</pre>";

			return ob_get_clean(); */
			return $website_url;
		}
		
		/*
		 *
		 * GOOGLE DRIVE API
		 *
		 */
		
		//  Gdrive - List all drive folders by parent folder id
		public function googleDriveListFolders($google_folder_id, $find_type = NULL){

			// check if folder_id exists
			if($google_folder_id){

				// mime type
				$mime_type = $find_type == "document" ? "document": "folder";
				
				// build the curl url
				$curl_url = 'https://www.googleapis.com/drive/v3/files?corpora=allDrives&includeItemsFromAllDrives=true&includeTeamDriveItems=true&q=%27'.$google_folder_id.'%27%20in%20parents%20and%20mimeType%3D%27application%2Fvnd.google-apps.'.$mime_type.'%27&supportsAllDrives=true';

				/* echo "<pre>";
				var_dump($curl_url);
				echo "</pre>"; */

				// 
				return $this->googleDriveCurl($curl_url, "GET", "", "json");
			} else {
				return array("error" => "No folder id specified.");
			}
		}

		// Gdrive - Copy a file to a folder
		public function googleDriveCopyFile($google_file_id){

			// check if file_id and folder_id exists
			if($google_file_id){

				// build the curl url
				$curl_url = 'https://www.googleapis.com/drive/v3/files/'.$google_file_id.'/copy';

				// 
				return $this->googleDriveCurl($curl_url, "POST", "", "json");
			} else {
				return array("error" => "No file id or folder id specified.");
			}
		}

		/*
		 * Gdrive - Upload File
		 * 
		 * @param string $google_file_directory	
		 * @param string $file_path
		 * 
		 */
		public function googleDriveUploadFile($google_file_directory, $file_path){

			// get the access and refresh tokens
			$refresh_token = $this->get_tokens("refresh");
		
			// generate new access token using the refresh token
			$tokens = $this->generate_new_tokens($refresh_token);
			
			// check if file_path variable is not empty
			if($google_file_directory && $file_path){

				// convert string to array delimeted by /
				$path = explode("/", $file_path);

				// the file name is the last element
				$file_name = end($path);

				// remove file extension regex
				// $file_name = preg_replace('/\.[^.]+$/', '', $file_name);
					
				// build the curl url
				$curl_url = 'https://www.googleapis.com/upload/drive/v3/files?uploadType=media';
				// $curl_url = 'https://www.googleapis.com/upload/drive/v3/files?uploadType=multipart';
				
				// uploaded file data
				$uploaded_file = $this->googleDriveCurl($curl_url, "POST", file_get_contents($file_path), '');
				/* $uploaded_file = $this->googleDriveCurl($curl_url, "POST", array(
					'metadata' => json_encode(array(
						'name' => $file_name,
						// 'parents' => array($this->_google_folder_id),
						// 'mimeType' => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' // for xlsx
						"mimeType" => 'application/vnd.ms-excel', // for xls
						// "mimeType" => 'application/vnd.google-apps.spreadsheet',
						// "mimeType" => 'text/csv',
						// 'uploadType' => 'multipart',
					)),
					"mimeType" => 'application/vnd.ms-excel', // for xls
					'name' => $file_name,
					// 'media' => file_get_contents($file_path)
					// 'data' => file_get_contents($file_path)
				), 'json'); */

				
				if(!isset($uploaded_file["error"])){
					
					// create the directories if they don't exist
					$folder_id = $this->googleDriveCreateFolder($google_file_directory, $this->_google_folder_id, "upload");

					
					// update the file meta
					// -- moves it to the correct folder, update name etc.
					$updated_file = $this->googleDriveUpdateFile($folder_id, $uploaded_file["id"], $file_name, $file_path);

					return $updated_file;
				} else {
					return $uploaded_file["error"];
				}
			} else {
				return array("error" => "There was an error uploading your file.");
			}
		}

		// Gdrive - Update file
		public function googleDriveUpdateFile($google_folder_id, $google_file_id, $google_file_name, $file_path = NULL){
			
			// check if file_id exists
			if($google_file_id && $google_folder_id && $google_file_name){
					
				// build the curl url
				$curl_url = 'https://www.googleapis.com/drive/v3/files/'.$google_file_id.'?addParents='.$google_folder_id;
					
				// 
				// return  $this->googleDriveCurl($curl_url, "PATCH", file_get_contents($file_path), '');
				return $this->googleDriveCurl($curl_url, "PATCH", json_encode(array(
					// "mimeType" => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
					// "mimeType" => 'application/vnd.google-apps.spreadsheet',
					// "mimeType" => 'application/vnd.ms-excel',
					// "mimeType" => 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
					// "mimeType" => 'text/csv',
					// 'uploadType' => 'multipart',
					"name" => $google_file_name
				)), 'json');
				
			} else {
				return array("error" => "No file id or folder id specified.");
			}
		}

		// Gdrive - Update permissions
		public function googleDriveUpdatePermissions($google_file_id, $google_email, $google_role){
			
			// check if file_id exists
			if($google_file_id && $google_email && $google_role){
					
				// build the curl url
				$curl_url = 'https://www.googleapis.com/drive/v3/files/'.$google_file_id.'/permissions';
					
				// 
				return $this->googleDriveCurl($curl_url, "POST", json_encode(
					array(
						"role"         => $google_role,
						"type"         => "user",
						"emailAddress" => $google_email
				)), 'json');
			} else {
				return array("error" => "No file id or folder id specified.");
			}
		}

		// Gdrive - Check if folder exists by name
		public function googleDriveCheckFolder($google_folder_name, $google_folder_id, $find_type){
			
			// check if folder_name exists
			if($google_folder_name){

				// mime type
				$mime_type = $find_type == "document" ? "document": "folder";
				
				// list gdrive folders
				$gdrive_folders = $this->googleDriveListFolders($google_folder_id, $mime_type);

				// 
				if(!isset($gdrive_folders["error"])){

					// initialize value
					$folder_id = false;
					
					// loop through the folders
					foreach ($gdrive_folders["files"] as $key => $folder) {

						// check if folder exists
						if($folder["name"] == $google_folder_name){
							$folder_id = $folder["id"];
						}
					}

					return $folder_id;
				} else {
					return $gdrive_folders["error"];
				}
			} else {
				return array("error" => "No folder name specified.");
			}
		}

		// Gdrive - Create Folder
		public function googleDriveCreateFolder($google_file_path, $google_folder_id, $google_folder_type){

			// assign the default google folder id
			$google_folder_id = $this->_google_folder_id;

			// validate folder if it exists
			if($google_file_path){

				// remove public_html and reports from the file path
				// $google_file_path = str_replace("/home/fb4142mw/public_html/reports/", "", $google_file_path);
				$google_file_path = $google_folder_type == "upload" ? str_replace("/home/fb4142mw/public_html/reports/", "", $google_file_path) : $google_file_path;

				// convert string to array delimeted by /
				$file_path = explode("/", $google_file_path);

				// the file name is the last element
				// $file_name = end($file_path);
				
				// remove last element from the array (the last element is the file if it's an upload)
				array_pop($file_path);

				//
				$parent_folder_id = "";

				/* echo "<pre>";
				var_dump($file_path);
				echo "</pre>"; */

				// loop through the file paths and create google drive folders
				foreach($file_path as $key => $f_name){

					// if($key == 0 || $key == 1){

						/* echo "<pre>";
						var_dump($f_name . " - " . $key); */
						
						// parent folder id
						$parent_folder_id = ($key == 0) ? $google_folder_id : $folder_id;
						// var_dump($parent_folder_id);

						// if($key == 0){

							// returns false or the folder id
							$folder_id = $this->googleDriveCheckFolder($f_name, $parent_folder_id, "");
							// var_dump($folder_id);

							// check if the folder id exists and create one if it doesnt
							if($folder_id == false && $parent_folder_id){
								
								// create the google drive folder
								$folder = $this->googleDriveCurl("https://www.googleapis.com/drive/v3/files", "POST", json_encode(array(
									'mimeType' => 'application/vnd.google-apps.folder',
									'name'     => $f_name, // folder name
									'parents'  => array($parent_folder_id)
								)), 'json');
								
								// check again if the folder id exists
								$folder_id = $this->googleDriveCheckFolder($f_name, $parent_folder_id, "");
							}
						// }

						// 


						// update parent folder id
						// $parent_folder_id = $folder_id;
						
						// echo "Folder ID Updated: ".$folder_id;
						// var_dump($folder_id);
						// var_dump($folder);
						// var_dump($f_name);
						/* var_dump($folder_id);
						echo "</pre>"; */
					// }
				}

				// 
				if($folder_id){

					// change file permission
					$change_permission = $this->googleDriveChangeFilePermission($folder_id);
				}

				// return the last folder id
				return $folder_id;
			} else {
				return array("error" => "No file path specified.");
			}
		}
		
		/* GOOGLE DRIVE: CHANGE FILE PERMISSION */
		private function googleDriveChangeFilePermission($folder_id){
			
			// create curl resource
			$curl = curl_init();

			// get access token
			$access_token = $this->get_tokens("access");

			// set permissions
			$filePermission = array('role' => 'reader', 'type' => 'anyone');
			$filePermission = json_encode($filePermission);

			// set curl options
			curl_setopt_array($curl, array(
				CURLOPT_URL => "https://www.googleapis.com/drive/v3/files/" . $folder_id . "/permissions",
				CURLOPT_RETURNTRANSFER => true,
				CURLOPT_ENCODING => "",
				CURLOPT_MAXREDIRS => 10,
				CURLOPT_TIMEOUT => 0,
				CURLOPT_FOLLOWLOCATION => true,
				CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
				CURLOPT_CUSTOMREQUEST => "POST",
				CURLOPT_POSTFIELDS => $filePermission,
				CURLOPT_HTTPHEADER => array(
				  "Authorization: Bearer ".$access_token,
				  "Content-Type: application/json"
				),
			));

			$response = curl_exec($curl);

			curl_close($curl);

			return $response;
		}

		/*
		 * GOOGLE DRIVE DELETE FILE
		 * 
		 */
		public function googleDriveDeleteFile($google_file_id){
			
			// check if file_id exists
			if($google_file_id){

				// build the curl url
				$curl_url = 'https://www.googleapis.com/drive/v3/files/'.$google_file_id;
					
				// 
				return $this->googleDriveCurl($curl_url, "DELETE", "", "json");
			} else {
				return array("error" => "No file id specified.");
			}
		}

		// google drive curl call
		private function googleDriveCurl($curl_url, $curl_type, $curl_data, $curl_data_type){

			// get access token
			$access_token = $this->get_tokens("access");

			// 
			if($curl_url && $curl_type){
				// curl init
				$curl = curl_init();
	
				// transform text to uppercase
				$curl_type = $curl_type ? strtoupper($curl_type) : "";
				$curl_data_type = $curl_data_type ? strtoupper($curl_data_type) : "";
	
				// build request data
				curl_setopt($curl, CURLOPT_REFERER, '*.seoi.io/*');
				curl_setopt($curl, CURLOPT_URL, $curl_url);
				curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($curl, CURLOPT_ENCODING, 'gzip, deflate');
				if($curl_type == "POST"){
					curl_setopt($curl, CURLOPT_POST, 1);
				} else {
					curl_setopt($curl, CURLOPT_CUSTOMREQUEST, $curl_type);
				}
				if($curl_data){
					curl_setopt($curl, CURLOPT_POSTFIELDS, $curl_data);
				}
	
				// build headers
				$headers = array();
				$headers[] = 'Authorization: Bearer '.$access_token;
				if($curl_data_type == 'JSON'){
					$headers[] = 'Accept: application/json';
					$headers[] = 'Content-Type: application/json';
					// $headers[] = 'Content-Type: application/vnd.google-apps.spreadsheet';
				}
				curl_setopt($curl, CURLOPT_HTTPHEADER, $headers);
	
				// curl results
				$result = curl_exec($curl);
				$result = json_decode($result, true);

				// return
				return $result;

				// 
				curl_close($curl);
			} else {
				return array("error" => "No folder id specified.");
			}
		}
		/* =============================== */


		/*
		 * 
		 * Google Appsheets API 
		 * https://support.google.com/appsheet/topic/10105767?hl=en&ref_topic=10101404
		 * 
		 * Add a new row to the spreadsheet
		 * 
		 * @param array  $appsheet_data
		 * 
		 */
		
		public function appSheetAddData($appsheet_data){

			if($appsheet_data && is_array($appsheet_data)){

				// 
				$data = array(
					"Action" => "Add",
					"Properties" => array(
						"Locale" => "en-US",
					),
					"Rows" => array($appsheet_data)
				);

				// 
				return $this->appSheetCurl($data);

			} else {
				return array("error" => "No data specified.");
			}
		}

		/*
		 * 
		 * Find the row data in the spreadsheet
		 * 
		 * @param array  $appsheet_data
		 * 
		 */
		public function appSheetFindData($appsheet_data){

			if(is_array($appsheet_data)){

				// 
				$data = array(
					"Action" => "Find",
					"Properties" => array(
						"Locale" => "en-US",
					)
				);

				// check if array is empty
				if(empty($appsheet_data)){
					$data["Rows"] = array(); 
				} else {
					$data["Rows"] = array($appsheet_data);
				}
				return $this->appSheetCurl($data);
			} else {

				// return error
				return array("error" => "No data specified.", "type" => "Find");
			}
		}

		/*
		 * 
		 * Edit the row data in the spreadsheet
		 * 
		 * @param array  $appsheet_data
		 * 
		 */
		public function appSheetEditData($appsheet_data){

			if(is_array($appsheet_data)){

				// 
				$data = array(
					"Action" => "Edit",
					"Properties" => array(
						"Locale" => "en-US",
					)
				);

				// check if array is empty
				if(empty($appsheet_data)){
					$data["Rows"] = array(); 
				} else {
					$data["Rows"] = array($appsheet_data);
				}
				return $this->appSheetCurl($data);
			} else {

				// return error
				return array("error" => "No data specified.", "type" => "Find");
			}
		}

		/*
		 * 
		 * App Sheet CURL
		 * 
		 * @param array  $appsheet_data
		 * @param string $appsheet_app_id
		 * @param string $appsheet_access_key
		 * @param string $appsheet_table_name encoded as url
		 * 
		 */
		private function appSheetCurl($appsheet_data){

			// 
			$appsheet_app_id = $this->_appsheet_app_id;
			$appsheet_access_key = $this->_appsheet_access_key;
			$appsheet_table_name = $this->_appsheet_table_name;

			// 
			if(is_array($appsheet_data) && $appsheet_app_id && $appsheet_access_key && $appsheet_table_name){

				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, 'https://api.appsheet.com/api/v2/apps/'.$appsheet_app_id.'/tables/'.$appsheet_table_name.'/Action');
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_POST, 1);
				curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($appsheet_data));
				
				$headers = array();
				$headers[] = 'Applicationaccesskey: '.$appsheet_access_key;
				$headers[] = 'Content-Type: application/json';
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				
				$result = curl_exec($ch);
				if (curl_errno($ch)) {
					echo 'Error:' . curl_error($ch);
				}
				curl_close($ch);
				
				return $result;

				/* echo "<pre>";
				var_dump(json_decode($result, true));
				var_dump($appsheet_data);
				var_dump($appsheet_app_id);
				var_dump($appsheet_access_key);
				var_dump($appsheet_table_name);
				echo "</pre>"; */
			} else {

				// return error
				return array("error" => "No data specified.");
			}
		}

		/*
		 * 
		 * Google Docs API
		 * https://developers.google.com/docs/api/reference/rest
		 * 
		 * @param string $gdocs_document_id
		 * 
		 * @return string table index
		 * 
		 */
		public function googleDocsGet($gdocs_document_id){

			// this returns the start index of the updates table of the report

			// 
			if($gdocs_document_id){

				// 
				$result = $this->googleDocsCurl($gdocs_document_id, "get", "");

				// 
				$content_start_index = "";

				if(!isset($result["error"])){

					// the first table is the correct one
					$table_key = 1;

					// loop through the document and find the table
					foreach($result['body']['content'] as $key => $value){

						// find the first table
						if(isset($value["table"]) && $table_key == 1){

							// table start index
							$table_start_index = $value["table"]["tableRows"][1]["startIndex"];
							$table_end_index = $value["table"]["tableRows"][1]["endIndex"];

							// get the table cells of the first table
							$table_cells = $value["table"]["tableRows"][1]["tableCells"];

							// get the start index of the needed table 
							$content_start_index = $table_cells[0]["content"][0]["startIndex"];
							
							// first table key loop
							$table_key++;
						}
					}
				}

				// return the start index
				return $content_start_index;
				// return $result;
			} else {

				// return error
				return array("error" => "No data specified.");
			}
		}

		/*
		 * 
		 * Google Docs Update the file
		 * 
		 * @param string $gdocs_document_id
		 * @param array  $gdocs_data
		 * 
		 * @return array
		 * 
		 */
		public function googleDocsUpdate($gdocs_document_id, $gdocs_data, $gdocs_start_index){

			// 
			if($gdocs_document_id && $gdocs_data && $gdocs_start_index){

				// data array
				$gdocs = array(
					"requests" => array(
						$gdocs_data
						/* array(
							"insertText" => array(
								// "text" => $gdocs_data . "asdasdas \n\n",
								"text" => $gdocs_data,
								"location" => array(
									"index" => $gdocs_start_index
								)
							)
						) */
					)
				);

				return $this->googleDocsCurl($gdocs_document_id, "update", $gdocs);
			} else {

				// return error
				return array("error" => "No data specified.");
			}
		}
		
		/*
		 * 
		 * Google Docs CURL
		 * 
		 * @param string $gdocs_document_id
		 * @param string $gdocs_type : "get" or "update"
		 * @param array  $gdocs_data
		 * 
		 * @return array
		 * 
		 */
		private function googleDocsCurl($gdocs_document_id, $gdocs_type, $gdocs_data){

			if($gdocs_document_id && $gdocs_type){

				// get access token
				$access_token = $this->get_tokens("access");

				// url
				$url = "https://docs.googleapis.com/v1/documents/".$gdocs_document_id;
				$url = $gdocs_type == "update" ? $url.":batchUpdate" : $url;

				// curl
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
				curl_setopt($ch, CURLOPT_ENCODING, 'gzip, deflate');

				if($gdocs_type == "get"){
					curl_setopt($ch, CURLOPT_CUSTOMREQUEST, 'GET');
				} else {
					curl_setopt($ch, CURLOPT_POST, 1);

					if($gdocs_data){
						curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($gdocs_data));
					}
				}

				// curl headers
				$headers = array();
				$headers[] = 'Authorization: Bearer ' . $access_token;
				$headers[] = 'Accept: application/json';
				$headers[] = 'Content-Type: application/json'; 
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				

				// curl results
				$result = curl_exec($ch);
				$result = json_decode($result, true);

				// return
				return $result;

				// 
				curl_close($ch);
			} else {

				// return error
				return array("error" => "No data specified.");
			}
		}
	}
// }

// get csv
function csv_to_multidimension_array($filename='', $delimiter=','){
    if(!file_exists($filename) || !is_readable($filename)) {
        return false;
    }

    $header = NULL;
    $data = array();

    if (($handle = fopen($filename, 'r')) !== false) {
        while (($row = fgetcsv($handle, 1000, $delimiter)) !== false ) {
            $data[] = $row;
        }
        fclose($handle);
    }
    return $data;
}

// create directory
/* function create_directory($path){

	$root_dir   = $_SERVER['DOCUMENT_ROOT'];
	$report_dir = $root_dir."/"."reports/";
	$site_dir   = $report_dir.$path;

	if (!is_dir($site_dir) && $path) {

		wp_mkdir_p( $site_dir );
		writeht("seoi.co.uk", $site_dir);
	}

	return $site_dir;
} */

// copy file to directory
function copyToReports($filename){

	$root_dir  = $_SERVER['DOCUMENT_ROOT'];
	$directory = $root_dir."/"."reports/";

	// check if directory exists
	if (!is_dir($directory)) {

		// create directory
		wp_mkdir_p( $directory );
		writeht("seoi.io", $directory);
	}

	$filename = wp_unique_filename( $report_dir, $filename );

	return $directory;
}

/*
 * VIEW AS CUSTOMER
 * - Let the admin/manager view the site as a customer
 * 
 * @return html | boolean
 * 
 */
add_action('custom_notifications', 'viewAsCustomer');
function viewAsCustomer(){

	// GET THE CUSTOMER ID
	$customer_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';

	// CHECK IF CUSTOMER ID IS SET
	if(!$customer_id && !isset($_GET['view'])){
		return false;
	}

	// GET THE CURRENT USER ID (MANAGER ID)
	$user_id = get_current_user_id();
	// GET USER ROLE
	$user_role = get_the_author_meta('roles', $user_id)[0];
	// GET CUSTOMER USER DATA BY ID
	$customer_data = $customer_id ? get_user_by('id', $customer_id) : '';
	// GET CUSTOMER FIRST NAME
	$customer_first_name = $customer_data ? $customer_data->first_name : '';
	// GET THE VIEW AS
	$view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
	// GET THE ASSIGNED CUSTOMERS
	$assigned_customers = get_the_author_meta("_assigned_customers", $user_id);
	$assigned_customers = $assigned_customers ?? [];
	// CHECK IF THE CUSTOMER ID IS IN THE ASSIGNED CUSTOMERS
	$if_customer = in_array($customer_id, $assigned_customers);
	
	// VALIDATE IF THE USER IS A MANAGER AND THE CUSTOMER ID IS IN THE ASSIGNED CUSTOMERS
	if(!$if_customer || $user_role != 'account_manager' || $view_as != 'user'){
		return false;
	}

	$content = '';

	// SHOW THE WARNING
	echo $content .= 	'<div class="alert alert-primary fade show rounded-0 mb-3" role="alert">
							<strong>Warning!</strong> You\'re currently viewing the site as '.$customer_first_name.'. <a href="'.get_site_url().'/seo-manager/?view=cancel">Click here</a> to cancel and reset this view.
						</div>';

	// SET THE SESSION
	WC()->session->set('view_as', $view_as);
	WC()->session->set('view_as_cid', $customer_id);
}

/*
 * VIEW AS CUSTOMER CANCEL
 * 
 * @return html | boolean
 * 
 */
add_action('custom_notifications_before_content', 'viewAsCustomerCancel');
function viewAsCustomerCancel(){

	// GET THE VIEW AS
	$view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';

	// VALIDATE IF THE VIEW AS IS CANCEL
	if($view_as != 'cancel'){
		return false;
	}

	// REMOVE THE SESSION
	WC()->session->set('view_as', null);
	WC()->session->set('view_as_cid', null);
}

/*
 * GOOGLE POLICY NOTIFICATION
 * 
 */

add_action('custom_notifications', 'googlePolicyNotification');
function googlePolicyNotification(){
	// simple bootstrap alert with close button
	?>
	<div id="customAlert" class="alert alert-warning alert-dismissible fade show rounded-0 mb-3" role="alert" style="display: none;">
		This app complies with Google's API Services User Data Policy, ensuring your privacy; review the policy <a href="https://developers.google.com/terms/api-services-user-data-policy" target="_blank">here</a>. <button type="button" class="close" data-dismiss="alert" aria-label="Close"><span aria-hidden="true">&times;</span></button>
	</div>
	<?php
}
