<div class="accordion mb-3" id="accordionTodo">
    <?php 
    foreach($todo_list as $key => $todo){
        // strip slashes
        $internal_note_key = 'internal_notes_'.$key;
        $internal_notes = isset($todo["Internal Notes"]) ? $todo["Internal Notes"] : "";
        $internal_note_content = isset($_POST[$internal_note_key]) ? $_POST[$internal_note_key] : $internal_notes;
        $internal_note_content = stripslashes($internal_note_content);
        $internal_note_settings  = array(
            'editor_height' => 100,
            'visual'       => true,
            'quicktags'    => false,
            'teeny'        => false,
            'media_buttons'=> false,
            'tinymce' => array(
                'toolbar1' => 'link',
            ),
        );
        

        // include in report
        // $listkey = $key;
        $iir_key = 'include_in_report_'.$key;
        $include_in_report = isset($todo["Include in Report"]) ? $todo["Include in Report"] : "";
        $include_in_report = isset($_POST[$iir_key]) ? $_POST[$iir_key] : $include_in_report;
        $include_in_report = $include_in_report == "on" ? "checked" : "";

        // dd($additional_todo_key);
    ?>
        <div class="card rounded-0 bg-white <?php echo $include_in_report ? "included" : ""; ?>">
            <div class="card-header p-0" id="heading<?php echo $key; ?>">
                <div class="mb-0">
                    <button class="btn btn-link btn-block text-left p-0 collapsed text-decoration-none rounded-0 shadow-none border-0 p-3 text fw-medium bg-white position-relative"  style="color: black;" type="button" data-toggle="collapse" data-target="#collapse<?php echo $key; ?>" aria-expanded="false" aria-controls="collapse<?php echo $key; ?>">
                        <?php echo isset($todo["To Do"]) ? $todo["To Do"] : ''; ?>

                        <?php if($include_in_report == "checked" || $internal_note_content){ ?>
                            <div class="small-text position-absolute text-uppercase d-inline-flex align-items-center" style="right: 15px;top: 50%;transform: translateY(-50%);color: #4c9d5a;">
                                <!-- <div> -->
                                <?php if($include_in_report == "checked"){ ?>
                                    <svg class="tcb-icon mr-1" style="color: #4c9d5a;font-size: 14px;" fill="currentColor" viewBox="0 0 24 24" data-id="icon-check-circle-outlined" data-name=""><path d="M12 2C6.5 2 2 6.5 2 12S6.5 22 12 22 22 17.5 22 12 17.5 2 12 2M12 20C7.59 20 4 16.41 4 12S7.59 4 12 4 20 7.59 20 12 16.41 20 12 20M16.59 7.58L10 14.17L7.41 11.59L6 13L10 17L18 9L16.59 7.58Z"></path></svg> In Report
                                <?php } ?>
                                <!-- </div> -->

                                <?php if($internal_note_content){ ?>
                                    <svg class="tcb-icon ml-2" title="Internal Notes" style="color: #333;height: 20px;width: 20px;" viewBox="0 0 24 24" data-id="icon-comment-processing-outlined" data-name=""><path d="M9,22A1,1 0 0,1 8,21V18H4A2,2 0 0,1 2,16V4C2,2.89 2.9,2 4,2H20A2,2 0 0,1 22,4V16A2,2 0 0,1 20,18H13.9L10.2,21.71C10,21.9 9.75,22 9.5,22V22H9M10,16V19.08L13.08,16H20V4H4V16H10M17,11H15V9H17V11M13,11H11V9H13V11M9,11H7V9H9V11Z"></path></svg>
                                <?php } ?>
                            </div>
                        <?php } ?>
                    </button>
                </div>
            </div>

            <div id="collapse<?php echo $key; ?>" class="collapse" aria-labelledby="heading<?php echo $key; ?>" data-parent="#accordionTodo">
                <div class="card-body">
                    <form action="" method="POST">
                        <div class="row">
                            <div class="col-12">
                                <?php echo apply_filters("the_content", $todo["Info"]); ?>
                                <?php if($gdrive_id && $validateUser){ ?>
                                    <div class='d-block text mt-3'>Report Link</div>
                                    <div class="dropzone border d-flex align-items-center justify-content-center px-3 py-5 mb-3" data-customer-email="<?php echo $customer_email; ?>" data-drive-id="<?php echo $gdrive_id; ?>" data-selected-month="<?php echo $selected_month; ?>" style="border-width: 2px !important;border-style: dashed !important;cursor: pointer;">
                                        <div class="text">Drag and Drop files to upload into Google Drive <?php echo $selected_month ? "(".$selected_month.")" : ""; ?></div>
                                        <input type="file" id="" style="display: none" />
                                    </div>
                                <?php } ?>
                                <input class="mb-3 w-100 rounded-0 d-none" type="text" name="report_link" placeholder="Insert report link here" style="height: 40px;" value="<?php echo isset($todo["Report Link"]) ? $todo["Report Link"] : ''; ?>">
                                
                                
                                <?php
                                    // DISPLAY REPORT LINKS
                                    // STRING TO ARRAY
                                    $todo_report_link = isset($todo["Report Link"]) ? $todo["Report Link"] : '';
                                    $report_links = explode(",", $todo_report_link);
                                    if($gdrive_id && $report_links){
                                        echo "<div class='m-0 p-0 report-links' style=''>";
                                        foreach($report_links as $rkey => $rl){
                                            if($rl){
                                                // EXTRACT THE GOOGLE DRIVE ID
                                                // Define a regular expression pattern to match the file ID
                                                $pattern = '/\/file\/d\/([A-Za-z0-9_-]+)\//';
                                                $linkid = preg_match($pattern, $rl, $matches) ? $matches[1] : false;
                                                // dd($linkid);
                                                ?>
                                                    <div class='m-0 mb-2 p-0 d-flex align-items-center'>
                                                        <a href="" data-drive-id="<?php echo $linkid; ?>" data-key="<?php echo $rkey; ?>" class="report-link text-white mr-2 text-decoration-none rounded-circle d-flex align-items-center justify-content-center position-relative" style="font-size: 16px;line-height: 11px;width: 15px;height: 15px;background: #fca60a;top:1px;">&times;</a>
                                                        <a href="<?php echo $rl; ?>" target='_blank' class='d-inline-block text lh-1'><?php echo $rl; ?></a>
                                                    </div>
                                                <?php
                                            }
                                        }
                                        echo "<div class='mt-3'><input type='text' class='w-100 mb-2 rounded-0' style='height:40px;'><a href='' class='add-report-link small-text btn-orange px-3 rounded-0'>ADD A LINK</a></div>";
                                        echo "</div>";
                                    }
                                ?>

                                <?php if(!$gdrive_id && $validateUser){ ?>
                                    <p class="text">Generate a Google Drive folder to activate the drag and drop function of this todo list.</p>
                                    <a href="#generateDriveFolder" class="btn-orange rounded-0 small-text lh-1 py-2 px-3">GENERATE FOLDER</a>
                                <?php } ?>
                                <?php
                                    echo "<div class='mt-4 d-block text'>Report Comments</div>";
                                    // key 
                                    $editor_id = 'todo_comment_'.$key;
                                    $content   = isset($todo["Comments"]) ? $todo["Comments"] : "";
                                    if(isset($_POST[$editor_id])){
                                        $content = $_POST[$editor_id];
                                    }
                                    // strip slashes
                                    $content = stripslashes($content);
                                    $settings  = array(
                                        'editor_height' => 100,
                                        'visual'       => true,
                                        'quicktags'    => false,
                                        'teeny'        => false,
                                        'media_buttons'=> false,
                                        'tinymce' => array(
                                            // include tags
                                            'toolbar1' => 'formatselect, link',
                                            // 'toolbar1' => 'bold, italic, underline,|,fontsizeselect',
                                            // 'toolbar2' => false
                                        ),
                                    );
                                    wp_editor($content, $editor_id, $settings); 
                                ?>
                                <input type="hidden" name="editor_id" value="<?php echo $editor_id; ?>">
                                <input type="hidden" name="save_type" value="save">
                                <input type="hidden" name="entry_id" value="<?php echo $entry_id; ?>">
                                <input type="hidden" name="todo" value="<?php echo $todo["To Do"]; ?>">
                                <input type="hidden" name="todo_info" value="<?php echo $todo["Info"]; ?>">
                                <input type="hidden" name="additional_todo_key" value="<?php echo $additional_todo_key; ?>">
                            </div>
                            <div class="col-12">
                                <hr class="" style="margin: 30px 0; background-color: rgba(0,0,0,0.05);">
                                <div class='d-block text lh-1 mb-2'>Internal Notes</div>
                                <?php echo wp_editor($internal_note_content, $internal_note_key, $internal_note_settings); ?>
                            </div>
                            <div class="col-12 mt-4 d-flex align-items-center">
                                <input data-save-type="save" class="checkbox-include-report" type="checkbox" <?php echo $include_in_report; ?> id="include_in_report_<?php echo $key; ?>" name="include_in_report_<?php echo $key; ?>" style="position: absolute;height: 0;width: 0;">
                                <label class="d-inline-flex align-items-center justify-content-center mb-0 mr-2 btn-orange lh-1 small-text w-100 text-uppercase text-center text-white rounded-0 border-0 <?php echo $include_in_report == "checked" ? "bg-danger" : "";?>" style="cursor:pointer;padding:12px 10px; max-width: 210px;" for="include_in_report_<?php echo $key; ?>"><svg class="tcb-icon text-white mr-2" style="font-size: 16px;" fill="currentColor" viewBox="0 0 24 24" data-id="icon-content-save-outlined" data-name=""><path d="M17 3H5C3.89 3 3 3.9 3 5V19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V7L17 3M19 19H5V5H16.17L19 7.83V19M12 12C10.34 12 9 13.34 9 15S10.34 18 12 18 15 16.66 15 15 13.66 12 12 12M6 6H15V10H6V6Z"></path></svg><?php echo $include_in_report == "checked" ? "Remove From Report" : "Include in report";?></label>

                                <a data-save-type="save" class="update-todo d-inline-flex align-items-center justify-content-center mr-2 btn-orange lh-1 small-text w-100 text-uppercase text-center text-dark rounded-0 border-0 bg-light" style="color: black !important; padding:12px 10px; max-width: 210px;" href="#0"><svg class="tcb-icon text-dark mr-2" style="font-size: 16px;" fill="currentColor" viewBox="0 0 24 24" data-id="icon-calendar-text-outlined" data-name=""><path d="M19,4H18V2H16V4H8V2H6V4H5A2,2 0 0,0 3,6V20A2,2 0 0,0 5,22H19A2,2 0 0,0 21,20V6A2,2 0 0,0 19,4M19,20H5V10H19V20M5,8V6H19V8H5M7,12H17V14H7V12M7,16H14V18H7V16Z"></path></svg> Save The Notes</a>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
<?php } ?>
</div>
<style>
    .modal-backdrop.fade.show {
        display: none;
    }
    #includeInReportModal{
        background: rgba(0, 0, 0, 0.5);
    }
</style>
<div class="modal fade" id="includeInReportModal" data-backdrop="static" data-keyboard="false" tabindex="-1" aria-labelledby="includeInReportModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content shadow">
            <div class="modal-body text-center">
                <button type="button" class="close font-weight-light" data-dismiss="modal" aria-label="Close">&times;</button>
                <svg class="tcb-icon mb-3" viewBox="0 0 24 24" data-id="icon-chat-alert-outlined" data-name="" style="font-size: 53px;color: #8fbb94;"><path d="M12 3C6.5 3 2 6.58 2 11C2.05 13.15 3.06 15.17 4.75 16.5C4.75 17.1 4.33 18.67 2 21C4.37 20.89 6.64 20 8.47 18.5C9.61 18.83 10.81 19 12 19C17.5 19 22 15.42 22 11S17.5 3 12 3M12 17C7.58 17 4 14.31 4 11S7.58 5 12 5 20 7.69 20 11 16.42 17 12 17M11 13V15H13V13H11M11 11H13V7H11V11Z"></path></svg>
                <h4>Include this todo item to the generated report?</h4>
                <!-- <p class="mb-0">Please view it <a target="_blank" href="<?php //echo $gdrive_link; ?>">here</a></p> -->
                <div class="pt-3">
                    <a href="" class="include-yes btn-orange text-uppercase text px-4 rounded-0">Yes</a>
                    <a href="" class="include-no btn-orange-outline text-uppercase text px-4 rounded-0" data-dismiss="modal" aria-label="Close">No</a>
                </div>
            </div>
        </div>
    </div>
</div>