<?php if($strategyData['keyword_data']){ ?>
    <h4 class="font-weight-bold mt-4">Content optimisation Results</h4>
    <div class="border bg-white p-4 mb-4">
        <p class="text">Look at the top 3 results, see what their content offers visitors, and try to improve your content.</p>
        <p class="text">Your word count: <span class="font-weight-bold"><?php echo $own_data['word_count']; ?></span>
        <br>Average word count: <span class="font-weight-bold"><?php echo $keyword_compare['word_count']; ?></span></p>
        <p class="text">Content is Key for rankings. Good quality, helpful content can outrank bad content with 1000 more backlinks.</p>
        <p class="text">Create optimised and helpful content for visitors. Answer the questions they may have when searching for the keyword you are targeting.</p>

        <h6 class="font-weight-bold mt-4">Images</h6>
        <p class="text">Your images count: <span class="font-weight-bold"><?php echo $own_data['img']; ?></span></p>
        <p class="text">Average images count: <span class="font-weight-bold"><?php echo $keyword_compare['img']; ?></span></p>
        <p class="text">Adding original, optimised images to your content and video clips will make your content stand out to search engines and keep visitors engaged with your content.</p>

        <h6 class="font-weight-bold mt-4">Paragraph and headings</h6>
        <p class="text">Your paragraph count <span class="font-weight-bold"><?php //echo $own_data['img']; ?></span></p>
        <p class="text">Your heading count <span class="font-weight-bold"><?php //echo $own_data['img']; ?></span></p>
        <p class="text">Average paragraph count <span class="font-weight-bold"><?php echo $keyword_compare['p']; ?></span></p>
        <p class="text">Average heading count <span class="font-weight-bold"><?php echo $keyword_compare['headings']; ?></span></p>
        <p class="text">Break up your content into paragraphs and headings. This helps search engines understand your content and rank for more keywords and phrases. It also helps users digest your content and keep them engaged.</p>

        <!-- <h6 class="font-weight-bold mt-4">Images</h6> -->
        <!-- <p class="text">Your images count <span class="font-weight-bold"></span></p> -->
        <!-- <p class="text">Average images count <span class="font-weight-bold"></span></p> -->
        <!-- <p class="text mb-0">Adding original, optimised images to your content and video clips will make your content stand out to search engines and keep visitors engaged with your content.</p> -->
    </div>
                        
    <h4 class="font-weight-bold mt-4">Content Marketing &amp; Optimisation</h4>
    <div class="container-fluid px-0 mb-3">
        <div class="row">
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot.png" alt="Site Speed Optimisation">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Site Speed Optimisation</h6>
                                    <p class="text mb-0 pb-0">Optimise your site load speed. We can optimised images by reducing file size and other unnecessary files to improve your site’s load speed. Test your site speed here: <a href="https://pagespeed.web.dev/" target="_blank">https://pagespeed.web.dev/</a></p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" class="img-fluid" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot-1.png" alt="Content Creation and Optimisation">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <h6 class="font-weight-bold">Content Creation and Optimisation</h6>
                                <p class="text mb-0 pb-0">Created helpful content that is optimised for the chosen keywords and optimised to convert visitors. Good content can have a massive effect on your rankings and conversions. See the results of your strategy to give you a idea of content the top results have and try and improve on these pages with good helpful content that makes you stand out.</p>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href="<?php echo get_site_url(); ?>/content-writing-service/"><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <h4 class="font-weight-bold mt-4">Support Content Marketing</h4>
    <div class="border bg-white p-4 mb-4">
        <p class="text">Create supporting content and blog posts answering people's questions about the web page you are trying to rank and link the content or blog post back to that page. </p>
        <p class="text mb-0">Creating good content that answers the question people may have about the subject lets search engines know you are a good source of information, and the content will also drive targeted traffic to your content.</p>
    </div>
    <div class="container-fluid px-0 mb-3">
        <div class="row">
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot-2.png" alt="Supporting Content Marketing">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Supporting Content Marketing</h6>
                                    <p class="text mb-0 pb-0">Created a new supporting blog post linking to the main sales page.Creating a new blog post that answers people’s questions about your product and services shows search engines that you are a good source of information on the topic. Building authority with the search engines and increasing your rankings. These posts will also drive targeted traffic to your site and sales pages.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href="<?php echo get_site_url(); ?>/blog-writing-service/"><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot4-1.png" alt="Social media Marketing">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Social media Marketing</h6>
                                    <p class="text mb-0 pb-0">Create eye catching content that your target audience will be interested in and post regularly on your social networks. Building authority online and connecting with new targeted audiences.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <h4 class="font-weight-bold mt-4">Backlinks Results</h4>
    <div class="border bg-white p-4 mb-4">
        <p class="text">Your backlinks count <span class="font-weight-bold"><?php echo $own_data['backlinks']; ?></span></p>
        <p class="text">Average backlinks <span class="font-weight-bold"><?php echo $keyword_compare['backlinks']; ?></span></p>
        <p class="text mb-0">Backlinks are the main signal used by search engines for rankings. Build natural backlinks to your site and content. It is essential that you build a natural backlink and anchor text portfolio with a good mix of domain authority sites and a good mix of anchor text with natural and branded, making up most of your anchor texts and keyword and partial keywords sparingly and from the higher domain authority sites.</p>
    </div>
    <div class="container-fluid px-0 mb-3">
        <div class="row">
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot3.png" alt="Blogger Outreach">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Blogger Outreach</h6>
                                    <p class="text mb-0 pb-0">Reached out to relevant high-domain authority blogs and secured guest posts with powerful links to your site and content. Links from high authority blogs are a powerful way to build authority with the search engines and boost your rankings.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href="<?php echo get_site_url(); ?>/blogger-outreach-service/"><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot4.png" alt="Authority Mini Sites">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Authority Mini Sites</h6>
                                    <p class="text mb-0 pb-0">Create relevant helpful mini blog sites on high-domain Authority blogging platforms to build multiple backlinks with random anchor texts. These help build a natural backlink and anchor text profile. </p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot1.png" alt="Rich Media Citations">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Rich Media Citations</h6>
                                    <p class="text mb-0 pb-0">Created media content, including a company video clip and audio files and distribute them on high-domain authority media sites, including backlinks to your site and content.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <h4 class="font-weight-bold mt-4">Local SEO and Backlinks</h4>
    <div class="container-fluid px-0 mb-3">
        <div class="row">
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot-3.png" alt="Local Citation Building">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Local Citation Building</h6>
                                    <p class="text mb-0 pb-0">Created high-quality citations. Consistent and up-to-date citations are one of local SEO’s most important ranking factors. They build trust with the search engines that you are a well-established trading business.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href="<?php echo get_site_url(); ?>/local-seo-citations/"><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot5.png" alt="Local Link Building">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">Local Link Building</h6>
                                    <p class="text mb-0 pb-0">Local link building is a powerful way to build authority with the search engine and rank for your local keywords. Created local mini-sites with relevant local information linking to your site, GMB page, and top citations. Links from locally relevant content tell the search engine you are part of the local community and build trust.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-12 col-lg-6 mb-3">
                <div class="bg-white border h-100">
                    <div class="row no-gutters h-100">
                        <div class="col-12 col-lg-4 position-relative overflow-hidden">
                            <picture>
                                <img style="object-fit:cover;left:0;top:0;" class="img-fluid position-absolute h-100 w-100" src="<?php echo get_site_url(); ?>/wp-content/uploads/2023/06/Hotpot3-1.png" alt="GMB Optimisation">
                            </picture>
                        </div>
                        <div class="col-12 col-lg-8">
                            <div class="p-4 h-100 d-flex flex-column justify-content-between">
                                <div>
                                    <h6 class="font-weight-bold">GMB Optimisation</h6>
                                    <p class="text mb-0 pb-0">Optimised your Google My Business page for your top keywords. To take full advantage of your GMB page, it is essential to be active, collect recommendations, answer messages, and upload optimised images to your profile.</p>
                                </div>
                                <div>
                                    <a class="d-inline-block btn-orange rounded-0 text-center mt-4 small-text text-uppercase py-1 px-4" href=""><svg class="tcb-icon text-white" style="font-size: 16px;" viewBox="0 0 24 24" data-id="icon-add_shopping_cart-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M11 9h2V6h3V4h-3V1h-2v3H8v2h3v3zm-4 9c-1.1 0-1.99.9-1.99 2S5.9 22 7 22s2-.9 2-2-.9-2-2-2zm10 0c-1.1 0-1.99.9-1.99 2s.89 2 1.99 2 2-.9 2-2-.9-2-2-2zm-8.9-5h7.45c.75 0 1.41-.41 1.75-1.03l3.86-7.01L19.41 4l-3.86 7H8.53L4.27 2H1v2h2l3.6 7.59-1.35 2.44C4.52 15.37 5.48 17 7 17h12v-2H7l1.1-2z"></path></svg> Checkout Now</a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>