<table class="table bg-white m-0">
    <tbody>
        <?php
            foreach($mainTodos as $todo){
                // GET ENTRY ID
                $entry_id = $todo['entry_id'];
                // GET ENTRY
                $entry = GFAPI::get_entry( $entry_id );
                // GET THE TODO LIST DATA
                $additional_todos = rgar($entry, '19');
                // REPORT SENT
                $report_sent = gform_get_meta($entry_id, 'report_sent');
                // KEYWORDS
                $keyword1 = rgar($entry, '8');
                $keyword2 = rgar($entry, '3');
                $keyword3 = rgar($entry, '9');
                $keywordHtml = $keyword1 ? "<span class='lh-2 d-inline-block'>".$keyword1."</span><br>" : "";
                $keywordHtml .= $keyword2 ? "<span class='lh-2 d-inline-block'>".$keyword2."</span><br>" : "";
                $keywordHtml .= $keyword3 ? "<span class='lh-2 d-inline-block'>".$keyword3."</span>" : "";
                // PAGE URL
                $pageUrl = rgar($entry, '1') ? rgar($entry, '1') : "-";
                // STATUS
                $status = rgar($entry, '13') == "" ? "Ongoing" : rgar($entry, '13');
                // STATUS CLASS
                $status_class = $status == 'Completed' ? 'alert-success' : 'alert-primary';
                // DUE DATE
                $due_date = rgar($entry, '15');
                $due_date = $due_date == "" ? "-" : $due_date;
                // CLOSED DATE
                $closed_date = rgar($entry, '16');
                $closed_date = $closed_date == "" ? "-" : $closed_date;
                // REPORT SENT HTML
                $reportSentHtml = "<span style='color: red;' title='Report not sent'><svg fill='currentColor' class='tcb-icon' viewBox='0 0 512 512' data-id='icon-exclamation-circle-solid' data-name=''><path d='M504 256c0 136.997-111.043 248-248 248S8 392.997 8 256C8 119.083 119.043 8 256 8s248 111.083 248 248zm-248 50c-25.405 0-46 20.595-46 46s20.595 46 46 46 46-20.595 46-46-20.595-46-46-46zm-43.673-165.346l7.418 136c.347 6.364 5.609 11.346 11.982 11.346h48.546c6.373 0 11.635-4.982 11.982-11.346l7.418-136c.375-6.874-5.098-12.654-11.982-12.654h-63.383c-6.884 0-12.356 5.78-11.981 12.654z'></path></svg></span>";

                // BUILD THE TABLE
                echo "<tr data-entry-id='".$entry_id."'>";
                    echo "<td class='small-text'>";
                        if($user_role == "account_manager" || $view_as == "user"){
                            echo "<a href='' class='remove-todo text-decoration-none mr-2 d-inline-block align-middle' style='font-size: 26px;' data-customer-id='".$customer_id."' data-entry-id='".$entry_id."'>&times;</a>";
                        }
                        echo "<div class='alert ".$status_class." m-0 mr-3 p-0 d-inline-block small-text p-2 lh-1' role='alert'>".$status."</div>";
                        echo $report_sent != true ? $reportSentHtml : "";
                    echo "</td>";
                    echo "<td class='small-text'>".date('F j, Y, g:i a', strtotime($todo['date_created']))."</td>";
                    echo "<td class='small-text'>".$due_date."</td>";
                    echo "<td class='small-text'>".$closed_date."</td>";
                    echo "<td class='small-text'>".$keywordHtml."</td>";
                    echo "<td class='small-text lh-2'>".$pageUrl."</td>";
                    echo "<td><form action='/seo-manager/todos/list/?eid=".$entry_id."' method='POST'><input type='hidden' name='entry_id' value='".$entry_id."'><button type='submit' class='rounded-0 text py-2 px-3 btn-orange-outline lh-1'>View Todo #".$entry_id."</button></form></td>";
                echo "</tr>";

                // CHECK IF THERE ARE ADDITIONAL TODOS
                if($additional_todos){
                    // DECODE THE TODO LIST DATA
                    $additional_todos = json_decode($additional_todos, true);
                    // LOOP THROUGH ADDITIONAL TODOS
                    foreach($additional_todos as $key => $at){
                        $entry_id = $entry_id."-".($key+1); // ADDITIONAL TODO ENTRY ID
                        $status = isset($at["status"]) ? $at["status"] : $at["Status"]; // ADDITIONAL TODO STATUS
                        $report_sent = isset($at["report_sent"]) ? $at["report_sent"] : false; // ADDITIONAL TODO REPORT SENT
                        $status_class = $status == 'Completed' ? 'alert-success' : 'alert-primary';
                        $alignment_style = $user_role == "account_manager" || $view_as == 'user' ? 'padding-left: 35px;' : '';
                        echo "<tr data-entry-id='".$entry_id."'>";
                            echo "<td class='small-text' style='".$alignment_style."'>";
                                echo "<div class='alert ".$status_class." m-0 mr-3 p-0 d-inline-block small-text p-2 lh-1' role='alert'>".$status."</div>";
                                echo $report_sent != true ? $reportSentHtml : "";
                            echo "</td>";
                            echo "<td class='small-text'>".date('F j, Y, g:i a', strtotime($todo['date_created']))."</td>";
                            echo "<td class='small-text'>".$due_date."</td>";
                            echo "<td class='small-text'>".$closed_date."</td>";
                            echo "<td class='small-text'>".$keywordHtml."</td>";
                            echo "<td class='small-text lh-2'>".$pageUrl."</td>";
                            echo "<td><form action='/seo-manager/todos/list/?eid=".$entry_id."' method='POST'><input type='hidden' name='entry_id' value='".$entry_id."'><button type='submit' class='rounded-0 text py-2 px-3 btn-orange-outline lh-1'>View Todo #".$entry_id."</button></form></td>";
                        echo "</tr>";
                    } 
                }
            }
        ?>
    </tbody>
</table>