<?php
/*
	seo-manager/report-history/
	-- all reports uploaded to the customer account is viewable here.
*/
add_shortcode( 'report-history', 'reportHistory' );
function reportHistory() {
	ob_start();

	// get user data
	// $user_id  = get_current_user_id();
	// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
	$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
	// IF EMPTY, GET THE CURRENT USER ID
	$user_id = $user_id ? $user_id : get_current_user_id();
	$user     = get_user_by("ID", $user_id);
	$userRole = $user->roles[0];

	// get user meta data
	$google_drive_id = get_user_meta($user_id, 'google_drive_id', true);
	$google = new NEW_SEOI_GOOGLE();
	$oauth  = $google->oauth_link();

	// generate access token
	if (isset($_GET['code'])) {
		$google->generate_tokens($_GET['code']);
	}

	// get the items inside the google drive folder
	$test = $google->googleDriveListFolders($google_drive_id);

	// if the folders returned is an error the token may have expired
	if ($test["error"]) {

		// get the access and refresh tokens
		$refresh_token = $google->get_tokens("refresh");

		// generate new access token using the refresh token
		$tokens = $google->generate_new_tokens($refresh_token);

		// get the items inside the google drive folder
		$test = $google->googleDriveListFolders($google_drive_id);
	}
	?>
		<div class="bg-white p-3 mb-3 border-top-5 border-orange">
			<div class="text fw-medium">Report History</div>
		</div>
	<?php

	// if the file list is not an error
	if(!$test["error"]){

		// get the list of files
		_loadFiles($test);
	} else {
		// echo "No files found";
		echo '<div class="alert alert-danger rounded-0" role="alert">No files found.</div>';
	}

	return ob_get_clean();
}

function _loadFiles($folders){

	if($folders["files"]){
	?>
		<table class="table bg-white">
			<thead>
				<tr>
					<th class="fw-regular text">Folder Name</th>
					<th class="fw-regular text">Link</th>
				</tr>
			</thead>
			<tbody>
				<?php
				foreach ($folders["files"] as $key => $folder) {

					if($folder){

						// get mime type
						$mime = $folder["mimeType"];

						if($mime == "application/vnd.google-apps.folder"){
						?>
							<tr>
								<td class="text"><?php echo str_replace("_", " ", $folder["name"]); ?></td>
								<td class="text"><a href="https://drive.google.com/drive/folders/<?php echo $folder["id"]; ?>" target="_blank">View Folder</a></td>
							</tr>
						<?php
						}
					}
				} ?>
			</tbody>
		</table>
	<?php
	}
}