<?php

/*
 * Pass the entry id of form 19 to this function to get the report
 * 
 */

// arrows used for the pdf
$up_arrow = "data:image/png;base64,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";
$down_arrow = "data:image/png;base64,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";



// get entry
$entry = GFAPI::get_entry( $latest_entry );

// entry data
$order_id   = rgar($entry, '1');
$start_date = rgar($entry, '6');
$end_date   = rgar($entry, '7');

// dates
$start_date      = date("Y-m-d", strtotime($start_date));
$end_date        = date("Y-m-d", strtotime($end_date));
$prev_start_date = date("Y-m-d", strtotime("-1 month", strtotime($start_date)));
$prev_end_date   = date("Y-m-d", strtotime("-1 month", strtotime($end_date)));

// order data
$order       = wc_get_order($order_id);

echo "<pre>";
var_dump($entry);
echo "</pre>";


if($order){
    $order_items = $order->get_items(); // get all order items

    // initilize the google class
    $google = new NEW_SEOI_GOOGLE();

    // loop through order items
    foreach ($order_items as $key => $item) {

        // get the clean (without https and slashes) website url
        $original_url = $item->get_meta('Website URL', true);
        $website_url  = parse_url($original_url);
        $website_url  = $website_url["host"] ? $website_url["host"] : $website_url["path"];

        // validate website url
        // google search console api requires the site url specified in the site list
        $website = $google->validate_website($website_url);

        // live keywords
        $rowCount    = 1000;
        $startRow    = 0;
        $allKeywords = array();

        // check if the website is valid
        if ($website) {

            // get current month keywords
            do{

                // 
                $siteData = $google->generate_site_data(
                    "", // access token
                    $website, 
                    $start_date,
                    $end_date,
                    $rowCount,
                    "",
                    $startRow
                );

                // 
                if($siteData["rows"]){
                    $allKeywords = array_merge($allKeywords, $siteData["rows"]);
                }

                // update start row
                $startRow = count($allKeywords);

            } while (count($allKeywords) < $rowCount && count($siteData["rows"]) >= $rowCount);

            // get the data
            // $current_data = $allKeywords;
            // set the default data to the variables
            $top_moved_keywords = $allKeywords;

            $test = false;
            if($test){
            ?>

                <!-- TOP MOVED KEYWORDS -->
                <?php
                    $top_moved = array();
                    foreach ($top_moved_keywords as $key => $value) {

                        $past_position = "-";

                        foreach ($prev_data as $key => $pv) {

                            if ($value["keys"][0] == $pv["keys"][0]) {

                                // past position
                                $past_position = round($pv["position"], 2);

                                // get the difference
                                $diff = $past_position - $value["position"];
                                $diff = round($diff, 2);

                                // insert value into array by diff
                                if($diff >= 1){
                                    $top_moved[$diff] = $value;
                                }
                            }
                        }
                    }

                    // arrange array by key
                    krsort($top_moved);
                ?>
                <table class="table bg-white mt-3">
                    <thead>
                        <tr>
                            <th class="text fw-medium" colspan="5">Top Moved Keywords</th>
                        </tr>
                        <tr>
                            <th class="text fw-medium">Keyword</th>
                            <th class="text fw-medium">Clicks</th>
                            <th class="text fw-medium">Impressions</th>
                            <th class="text fw-medium">Previous Position</th>
                            <th class="text fw-medium">Position</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                            foreach ($top_moved as $key => $value) {

                                $past_position = "-";

                                foreach ($prev_data as $key => $pv) {
                                    if ($value["keys"][0] == $pv["keys"][0]) {
                                        $past_position = round($pv["position"], 2);
                                    }
                                }
                        ?>
                                <tr>
                                    <td class="text"><?php echo $value["keys"][0]; ?></td>
                                    <td class="text"><?php echo $value["clicks"]; ?></td>
                                    <td class="text"><?php echo $value["impressions"]; ?></td>
                                    <td class="text"><?php echo $past_position; ?></td>
                                    <td class="text"><?php 
                                        echo round($value["position"], 2);

                                        if ($past_position != "-" && $value["position"] > $past_position) {
                                            echo "<img src='".$down_arrow."'>";
                                        } elseif ($past_position != "-" && $value["position"] < $past_position) {
                                            echo "<img src='".$up_arrow."'>";
                                        }
                                    ?></td>
                                </tr>
                        <?php } ?>
                    </tbody>
                </table>
            <?php
            }
        } // !website
    }
}