<?php
/*
	seo-manager/seo-learning/
	-- assigned orders to the account manager
*/
add_shortcode( 'seo-learning', '_seo_learning' );
function _seo_learning() {
	ob_start();
?>
	<!-- <div class="dashboard-general-information">
		<div class="welcome-information">
			<h2 class="dashboard-title">SEO Learning</h2>
		</div>
	</div> -->
	<div class="bg-white p-3 mb-3 border-top-5 border-orange">
		<div class="text fw-medium">SEO Learning</div>
	</div>
<?php

	$learning_hub_categories = get_terms( "learning_hub_categories", array(
        "hide_empty" => false,
        "parent"     => 0
    ) );

	/* echo "<pre>";
    var_dump($learning_hub_categories);
	echo "</pre>"; */
?>
	<div class="dashboard-packages">
		<?php
			$count = 1;
			foreach ($learning_hub_categories as $key => $category):
				// var_dump($category);
				$articles = new WP_Query( array(
			        // "post_type"      => "learning_hub",
			        "post_type"      => "post",
			        "posts_per_page" => -1,
			        "post_status"    => "publish",
					// CATEGORY
						"category_name" => $category->slug,
					
			        /* "tax_query"      => array(
			            array(
			                // "taxonomy" => "learning_hub_categories",
			                "taxonomy" => "category",
			                "field"    => "id",
			                "terms"    => array( $category->term_id )
			            )
			        ) */
			    ) );

			    // if ($articles) {
			    	if ($count == 1 || $count == 2) {
				    	$count_class = "";
			    	} else {
				    	$count_class = "mt-3";
			    	}
		?>
					<div class="package-item <?php echo $count_class; ?>">
						<h3><?php echo $category->name; ?></h3>
						<table>
							<!-- <thead>
								<tr>
									<th>test</th>
									<th></th>
								</tr>
							</thead> -->
							<tbody>
								<?php if ($articles->have_posts()): ?>
									<?php while ($articles->have_posts()): $articles->the_post(); ?>
										<tr>
											<td class="product-name"><div class="img" style="background-image: url(<?php echo get_the_post_thumbnail_url( get_the_ID(), "thumbnail" ); ?>);"></div><?php echo get_the_title(); ?></td>
											<td class="product-actions">
												<a href="<?php echo get_the_permalink(); ?>">Learn More</a>
												<a class="d-none" href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>">Order Now</a>
											</td>
										</tr>
									<?php endwhile ?>
								<?php else: ?>
									<tr>
										<td>No Posts Found.</td>
										<td></td>
									</tr>
								<?php endif ?>
							</tbody>
						</table>
					</div>
			<?php $count++; //} ?>
		<?php endforeach ?>
	</div>
<?php
	return ob_get_clean();
}