<?php
// create a shortcode for the ssl checker
add_shortcode( 'seo-tools-ssl-checker', 'seoToolsSslChecker' );
function seoToolsSslChecker( $atts ) {
    
    ob_start();

    /* 
        Root Domain = root_domain 
    */
?>
    <div class="bg-white p-3 mb-3 border-top-5 border-orange">
        <div class="text fw-medium">SSL Certificate Checker</div>
    </div>
    <table class="table bg-white">
        <tbody>
            <tr>
                <td>
                    <form action="" method="POST">
                        <div class="text fw-medium">INPUT YOUR URL</div>
                        <input type="text" name="url" value="" class="mt-3 rounded-0 lh-1 w-100" placeholder="https://yourdomain.com/" required>
                        <button type="submit" class="mt-2 rounded-0 btn-orange py-2 px-3 text lh-1 w-100" style="height: 41px;">Submit</button>
                    </form>
                </td>
            </tr>
        </tbody>
    </table>
<?php
    if($_POST["url"]){
        // $cr = new Content_Readability();
        // $readability_data = $cr->check_readability($_POST["url"]);

        // remove http:// or https://
        $domain = preg_replace("/^https?:\/\//", "", $_POST["url"]);

        // remove trailing slash
        $domain = rtrim($domain, "/");

        $ssl_check = fsockopen("ssl://" . $domain, 443, $errno, $errstr, 30);

        if ($ssl_check) {
            $content =  "The domain $domain has a valid SSL certificate.";
            fclose($ssl_check);
        } else {
            $content = "The domain $domain does not have a valid SSL certificate.";
        }
        
?>
    <table class="table bg-white">
        <thead>
            <tr>
                <th class="text fw-medium">Results</th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="text"><span>URL:</span> <strong><?php echo $_POST["url"]; ?></strong></td>
            </tr>
            <tr>    
                <td class="text"><?php echo $content; ?></td>
            </tr>
        </tbody>
    </table>
<?php
    }
    return ob_get_clean();
}