<?php
defined( 'ABSPATH' ) || exit;

/*
 *
 * Single product custom forms that we will connect
 * to the cart order form
 *
 * [productOrderForm]
 *
 * SEO Management Service    -- 2027
 * Local SEO Services        -- 2055
 * National SEO Service      -- 2066
 * International SEO Service -- 2076
 * eCommerce SEO Services    -- 2081
 * Blog Management           -- 2123
 *
 * Blogger Outreach Service  -- 2090
 * Guest Post Service        -- 2105
 * On-Page SEO Services      -- 2117
 * Content Writing Service   -- 2129
 * Blog Writing Service      -- 2134
 *
 */
add_shortcode( 'productOrderForm', '_productOrderForm' );
function _productOrderForm() {
    ob_start();

    // get the page id
    $page_id = get_queried_object_id();

    // services with new code and layout
    $new_layout = array(2129, 2134, 2055, 2066);

    if(current_user_can("administrator")){
        $new_layout = array(2129, 2134, 2055, 2076, 2081);
    }

    // var_dump(get_the_ID());

    if(!in_array($page_id, $new_layout)){
?>
        <div id="product-order-form" data-form-id="<?php echo get_the_ID(); ?>" data-form-title="<?php echo get_the_title(); ?>">
            <div class="wrap">
                <?php //if ( get_the_title() == "Content Writing Services" || get_the_title() == "Blog Writing Service" ) { ?>
                <?php if ( get_the_ID() == 2129 || get_the_ID() == 2134 ) { ?>
                    <div class="left">
                        <div class="item">
                            <h4>1. How many page?</h4>
                            <div class="cstm-range" data-type="page-count" data-start="1" data-max="100" data-min="1" data-step="1" data-pips="5"></div>
                        </div>
                        <div class="item">
                            <h4>2. How many words?</h4>
                            <div class="cstm-range" data-type="word-count" data-start="500" data-max="2000" data-min="500" data-step="250" data-pips="7"></div>
                        </div>
                    </div>
                    <div class="right">
                        <div class="calculations">
                            <ul>
                                <li class="calculation-title"><?php the_title(); ?></li>
                                <li class="calculation-page-count" data-type="page-count">Page count: <strong>1</strong></li>
                                <li class="calculation-word-count" data-type="word-count">Word count: <strong>500</strong></li>
                                <li class="calculation-total">Total: <strong>£60</strong></li>
                                <li class="calculation-button"><a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="single-product-order-button">Order Now</a></li>
                            </ul>
                        </div>
                    </div>
                <?php //} elseif ( get_the_title() == "On-Page SEO Service" ) { ?>
                <?php } elseif ( get_the_ID() == 2117 ) { ?>
                    <div class="left">
                        <div class="item">
                            <h4>How many pages would you like optimised?</h4>
                            <div class="cstm-range" data-type="page-count" data-start="1" data-max="100" data-min="1" data-step="1" data-pips="5"></div>
                        </div>
                        <div class="item">
                            <ul class="item-choices">
                                <li data-type="content"><a href="">Add content to your pages</a></li>
                                <li data-type="technical"><a href="">Add onsite & technical seo</a></li>
                                <li data-type="content-technical"><a href="">Add content, onsite seo and technical seo to all pages</a></li>
                            </ul>
                        </div>
                        <div class="item item-hidden hidden" data-type="content">
                            <h4>How many words?</h4>
                            <p>Add content to your pages. Pages with a higher word count, rank better than pages with low word counts.</p>
                            <div class="cstm-range" data-type="word-count" data-start="500" data-max="2000" data-min="500" data-step="250" data-pips="7"></div>
                        </div>
                        <div class="item item-hidden hidden" data-type="technical">
                            <h4>Onsite & Technical SEO</h4>
                            <p>Technical SEO covers your whole site. Helping to speed up load times and making it easier for the search engines to find your content.</p>
                        </div>
                    </div>
                    <div class="right">
                        <div class="calculations">
                            <ul>
                                <li class="calculation-title"><?php the_title(); ?></li>
                                <li class="calculation-page-count" data-type="page-count">Page count: <strong>1</strong></li>
                                <li class="calculation-word-count hidden" data-type="word-count">Word count: <strong>500</strong></li>
                                <li class="calculation-total">Total: <strong>£50</strong></li>
                                <li class="calculation-button"><a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="single-product-order-button">Order Now</a></li>
                            </ul>
                        </div>
                    </div>
                <?php //} elseif ( get_the_title() == "Blog Management" ) { ?>
                <?php } elseif ( get_the_ID() == 2123 ) { ?>
                    <div class="left">
                        <div class="item">
                            <h4>1. How many posts?</h4>
                            <div class="cstm-range" data-type="post-count" data-start="1" data-max="100" data-min="1" data-step="1" data-pips="5"></div>
                        </div>
                        <div class="item">
                            <h4>2. How many words?</h4>
                            <div class="cstm-range" data-type="word-count" data-start="500" data-max="2000" data-min="500" data-step="250" data-pips="7"></div>
                        </div>
                    </div>
                    <div class="right">
                        <div class="calculations">
                            <ul>
                                <li class="calculation-title"><?php the_title(); ?></li>
                                <li class="calculation-post-count" data-type="post-count">Post count: <strong>1</strong></li>
                                <li class="calculation-word-count" data-type="word-count">Word count: <strong>500</strong></li>
                                <li class="calculation-total">Total: <strong>£50</strong></li>
                                <li class="calculation-button"><a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="single-product-order-button">Order Now</a></li>
                            </ul>
                        </div>
                    </div>
                <?php //} elseif ( get_the_title() == "Managed SEO" || get_the_title() == "SEO Management Service" || get_the_title() == "Local SEO Services" || get_the_title() == "National SEO Service" || get_the_title() == "International SEO Service" || get_the_title() == "eCommerce SEO Services" ) { ?>
                <?php } elseif ( get_the_ID() == 2027 || get_the_ID() == 2055 || get_the_ID() == 2066 || get_the_ID() == 2076 || get_the_ID() == 2081 ) { ?>
                    <div class="left">
                        <div class="item">
                            <h4>1. Choose your budget</h4>
                            <div class="cstm-range" data-type="budget" data-start="500" data-max="50000" data-min="500" data-step="250" data-pips="7"></div>
                        </div>
                    </div>
                    <div class="right">
                        <div class="calculations">
                            <ul>
                                <li class="calculation-title"><?php the_title(); ?></li>
                                <li class="calculation-budget" data-type="budget">Budget: <strong>500</strong></li>
                                <li class="calculation-total">Total: <strong>£500</strong></li>
                                <li class="calculation-button"><a href="<?php echo get_site_url(); ?>/cart?order=<?php echo get_the_title(); ?>&pid=<?php echo get_the_ID(); ?>" class="single-product-order-button">Order Now</a></li>
                            </ul>
                        </div>
                    </div>
                <?php } ?>
            </div>
        </div>
    <?php } else { ?>
        <form id="new-product-order-form" action="<?php echo wc_get_cart_url(); ?>" method="POST">
            <input type="hidden" name="page_id" value="<?php echo $page_id; ?>">
            <div class="wrap">
                <div class="left d-none">
                    <?php
                        // 2055 == Local SEO Services 
                        // 2066 == National SEO Services 
                        // 2076 == International SEO Services 
                        // 2081 == eCommerce SEO Services 
                        if($page_id == 2055 || $page_id == 2066 || $page_id == 2076 || $page_id == 2081){
                    ?>
                        <fieldset class="item">
                            <legend>1. Choose your budget</legend>
                            <input type="number" name="budget_count" max="99999" value="500" step="100">
                        </fieldset>
                    <?php } else { ?>
                        <fieldset class="item">
                            <legend>1. How many pages?</legend>
                            <input type="number" name="page_count" min="1" max="100" value="1">
                        </fieldset>
                        <fieldset class="item d-none">
                            <legend>2. How many words?</legend>
                            <input type="number" name="word_count" min="1" max="2000" value="350">
                        </fieldset>
                    <?php } ?>
                </div>
                <div class="right w-100">
                    <div class="calculations">
                        <ul>
                            <li class="calculation-title"><?php the_title(); ?></li>
                            <?php
                                // total
                                $total = "$60"; // default

                                // 2055 == Local SEO Services
                                // 2066 == National SEO Services
                                // 2076 == International SEO Services
                                // 2081 == Ecommerce SEO Services
                                if($page_id == 2055 || $page_id == 2066 || $page_id == 2076 || $page_id == 2081){ 

                                    // default value for this service
                                    $total = "£500";
                                } else {
                            ?>
                                <li class="calculation-page-count" data-type="page-count">Page count: <strong>1</strong></li>
                                <li class="calculation-word-count" data-type="word-count">Word count: <strong>350</strong></li>
                            <?php } ?>
                            <li class="calculation-total">Total: <strong><?php echo $total; ?></strong></li>
                            <li><button type="submit" style="max-width: 200px;">Order Now</button></li>
                        </ul>
                    </div>
                </div>
            </div>
        </form>
    <?php } ?>
<?php
    return ob_get_clean();
}
/* **************************** */
/* **************************** */