<?php
defined( 'ABSPATH' ) || exit;
/*
 *
 * Admin Backend User Dashboard
 * - Select an account manger
 *
 *
 */
// LEARNING SEO CUSTOM PROFILE META FIELDS
add_action( 'show_user_profile', '_addCustomUserFields' );
add_action( 'edit_user_profile', '_addCustomUserFields' );
function _addCustomUserFields( $user ) {
    // 
    $userRole = $user->roles[0]; // get user role

    if ( $userRole == "account_manager" ) { // if the user is an account manager
        $assignedOrders = get_the_author_meta( "_assigned_orders", $user->ID);
?>
        <h3><?php _e('Assigned Orders', 'your_textdomain'); ?></h3>
        <?php if ( $assignedOrders ){ ?>
            <table class="form-table">
                <?php foreach ( $assignedOrders as $key => $ao ){ ?>
                    <tr>
                        <th>Item ID:</th>
                        <td><?php echo $key; ?></td>
                    </tr>
                <?php } ?>
            </table>
        <?php } else { ?>
            <p>No assigned orders.</p>
        <?php } ?>
<?php
    } else { // if the user is a customer
    	// ACCOUNT MANAGER
    	// get all account manager users
    	$accountManagers = get_users( array(
            'role'    => 'account_manager',
            'orderby' => 'user_nicename',
            'order'   => 'ASC'
        ));

        // get the current account manager if there is one
        $customerAccountManager = get_the_author_meta( "_assigned_account_manager", $user->ID );


        // user assigned websites
        $userWebsites = get_the_author_meta( "_user_websites", $user->ID );
?>
	<div style="margin-bottom: 30px;">
		<h3><?php _e('Assigned Account Manager', 'your_textdomain'); ?></h3>
		<?php if ( $accountManagers ){ ?>
			<select name="assigned_account_manager" id="">
				<option>Not Assigned</option>
				<?php foreach ( $accountManagers as $key => $am ){ ?>
					<option value="<?php echo $am->user_email; ?>" <?php echo $customerAccountManager == $am->user_email ? "selected" : ""; ?>><?php echo $am->first_name; ?> <?php echo $am->last_name; ?> - <?php echo $am->user_email; ?></option>
				<?php } ?>
			</select>
		<?php } else { ?>
			<p>No assigned orders.</p>
		<?php } ?>
	</div>


    <!-- user websites -->
    <?php if ( !empty( $userWebsites ) ){ ?>
        <div style="margin-bottom: 30px;">
            <h3><?php _e('Websites', 'your_textdomain'); ?></h3>
            <table class="form-table">
                <?php foreach($userWebsites as $key => $website){ ?>
                    <tr>
                        <td>
                            <table>
                                <tr>
                                    <td>Website <?php echo $key + 1; ?>:</td>
                                    <td><?php echo $website; ?></td>
                                </tr>
                            </table>
                        </td>
                    </tr>
                <?php } ?>
            </table>
        </div>
    <?php } ?>
<?php
        // SEO LEARNING
        $lbTerms = get_terms( "learning_hub_categories", array(
            "hide_empty" => false,
            "parent"     => 0
        ) );
?>
        <h3 style="display: none;"><?php _e('SEO Learning Articles', 'your_textdomain'); ?></h3>
        
        <table class="form-table" style="display: none;">
            <?php if ( $lbTerms ){ ?>
                <?php
                    foreach ( $lbTerms as $key => $parentTerm ){
                        $learningArticles = new WP_Query( array(
                            "post_type"      => "learning_hub",
                            "posts_per_page" => -1,
                            "post_status"    => "publish",
                            "tax_query"      => array(
                                array(
                                    "taxonomy" => "learning_hub_categories",
                                    "field"    => "id",
                                    "terms"    => array( $parentTerm->term_id )
                                )
                            )
                        ) );
                ?>
                        <tr>
                            <th><?php echo $parentTerm->name; ?></th>
                            <td>
                                <table>
                                    <?php if ( $learningArticles->have_posts() ){ ?>
                                        <?php 
                                            while ( $learningArticles->have_posts() ) { $learningArticles->the_post();
                                                $slug       = basename( get_permalink( get_the_ID() ) );
                                                $uniqueName = $slug . "_" . $user->ID;
                                                $value      = get_the_author_meta( $uniqueName, $user->ID);
                                        ?>
                                            <tr>
                                                <td><input <?php if ($value == 'done' ) { ?>checked="checked"<?php }?> type="checkbox" name="<?php echo $uniqueName; ?>" id="<?php echo $uniqueName; ?>" value="done" class="regular-text" /></td>
                                                <td><label for="<?php echo $uniqueName; ?>"><?php echo get_the_title(); ?></label></td>
                                            </tr>
                                        <?php } wp_reset_postdata(); ?>
                                    <?php } ?>
                                </table>
                            </td>
                        </tr>
                <?php } ?>
            <?php } ?>
        </table>
<?php
    } // end if account manager
}

add_action( 'personal_options_update', '_saveCustomUserFields' );
add_action( 'edit_user_profile_update', '_saveCustomUserFields' );
function _saveCustomUserFields( $user_id ) {
    if ( !current_user_can( 'edit_user', $user_id ) )
        return FALSE;

    // get new account manager by email
    $accountManager = get_user_by( "email", $_POST["assigned_account_manager"] );

	// check if the account manager has a value
    if ( $accountManager ) {

    	// get the assigned customers of the account manager
	    $assignedCustomers = get_the_author_meta( "_assigned_customers", $accountManager->ID );

	    // check if the assigned customers array exists
	    if ( !$assignedCustomers ) {
	    	$assignedCustomers = array();
	    }

	    // check if the user id is already in the array of assigned customers
	    if ( !in_array( $user_id, $assignedCustomers ) ) {
	    	
	    	// insert into array if not
	    	$assignedCustomers[] = $user_id;

	    	// update account manager
		    update_user_meta( $accountManager->ID, "_assigned_customers", $assignedCustomers );
	    }
    } else {
    	// if the current account manager is blank / error
    	// remove the account manager from this customer
    	
    	// get the current account manager
    	$currentAccountManager = get_the_author_meta( "_assigned_account_manager", $user_id );

    	// get the account manager user object
    	$accountManager = get_user_by( "email", $currentAccountManager );

    	// get the assigned customers of the account manager
	    $assignedCustomers = get_the_author_meta( "_assigned_customers", $accountManager->ID );

	    // check if the assigned customers array exists
	    if ( !$assignedCustomers ) {
	    	$assignedCustomers = array();
	    }

    	// remove the customers account on the account managers account
    	if ( ( $key = array_search( $user_id, $assignedCustomers ) ) !== false) {
		    unset( $assignedCustomers[$key] );
		}

		// update account manager
		update_user_meta( $accountManager->ID, "_assigned_customers", $assignedCustomers );
    }

    // update customer account manager
    update_user_meta( $user_id, "_assigned_account_manager", $_POST["assigned_account_manager"] );


    // list all the learning hub post and check if the data exist in $_POST
    $learningArticles = new WP_Query( array(
        "post_type"      => "learning_hub",
        "posts_per_page" => -1,
        "post_status"    => "publish"
    ) );
    if ( $learningArticles->have_posts() ) {
        while ( $learningArticles->have_posts() ) { $learningArticles->the_post();
            $slug       = basename( get_permalink( get_the_ID() ) );
            $uniqueName = $slug . "_" . $user_id;
            update_user_meta( $user_id, $uniqueName, $_POST[$uniqueName] );
        } wp_reset_postdata();
    }
}