<?php
// GET THE CUSTOMER ID FOR THE VIEW AS FEATURE
$user_id = isset($_GET['cid']) ? $_GET['cid'] : WC()->session->get('view_as_cid') ?? '';
// IF EMPTY, GET THE CURRENT USER ID
$user_id = $user_id ? $user_id : get_current_user_id();
// GET THE USER OBJECT
$user = get_user_by("ID", $user_id);
// GET THE USER ROLE
$user_role = $user->roles[0];
// GET PAGE SLUG
$page_slug = strtok($_SERVER["REQUEST_URI"], '?');
// GET THE VIEW AS TO CHECK IF THE USER IS VIEWING AS A CUSTOMER
$view_as = isset($_GET['view']) ? $_GET['view'] : WC()->session->get('view_as') ?? '';
?>

<div class="dashboard-sidebar">
    <!-- <div class="ds-inner"> -->
        <div class="dashboard-menu-toggle">&times;</div>
        <div class="site-logo">
            <a href="<?php echo get_site_url(); ?>/seo-manager/"><img src="<?php echo get_site_url(); ?>/wp-content/uploads/2021/03/seoilogo-3.png" alt="SEOi"></a>
        </div>
        <ul class="sidebar-menu">
            <li class="<?php echo $page_slug == '/seo-manager/' ? "is-active" : ""; ?>"><a href="<?php echo site_url(); ?>/seo-manager/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 640 512" data-id="icon-laptop-code-solid" data-name=""><path d="M255.03 261.65c6.25 6.25 16.38 6.25 22.63 0l11.31-11.31c6.25-6.25 6.25-16.38 0-22.63L253.25 192l35.71-35.72c6.25-6.25 6.25-16.38 0-22.63l-11.31-11.31c-6.25-6.25-16.38-6.25-22.63 0l-58.34 58.34c-6.25 6.25-6.25 16.38 0 22.63l58.35 58.34zm96.01-11.3l11.31 11.31c6.25 6.25 16.38 6.25 22.63 0l58.34-58.34c6.25-6.25 6.25-16.38 0-22.63l-58.34-58.34c-6.25-6.25-16.38-6.25-22.63 0l-11.31 11.31c-6.25 6.25-6.25 16.38 0 22.63L386.75 192l-35.71 35.72c-6.25 6.25-6.25 16.38 0 22.63zM624 416H381.54c-.74 19.81-14.71 32-32.74 32H288c-18.69 0-33.02-17.47-32.77-32H16c-8.8 0-16 7.2-16 16v16c0 35.2 28.8 64 64 64h512c35.2 0 64-28.8 64-64v-16c0-8.8-7.2-16-16-16zM576 48c0-26.4-21.6-48-48-48H112C85.6 0 64 21.6 64 48v336h512V48zm-64 272H128V64h384v256z"></path></svg></span><span class="text">Overview</span></a></li>
    
            <?php if ($user_role != "account_manager" && $user_role != "administrator") { ?>
                <?php
                    if($view_as != 'user'){
                        // order link class
                        $order_class = "";
                        if ($page_slug == '/seo-manager/orders/' || strpos($page_slug, 'view-order') !== false) {
                            $order_class = "is-active";
                        }
                ?>
                        <li class="<?php echo $order_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/orders/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-order-bool-descending-variant-solid" data-name=""><path d="M4 3C2.89 3 2 3.89 2 5V9C2 10.11 2.89 11 4 11H8C9.11 11 10 10.11 10 9V5C10 3.89 9.11 3 8 3M8.2 4.5L9.26 5.55L5.27 9.5L2.74 6.95L3.81 5.9L5.28 7.39M4 13C2.89 13 2 13.89 2 15V19C2 20.11 2.89 21 4 21H8C9.11 21 10 20.11 10 19V15C10 13.89 9.11 13 8 13M4 15H8V19H4M12 5H22V7H12M12 19V17H22V19M12 11H22V13H12Z"></path></svg></span><span class="text">Your Orders</span></a></li>
                <?php } ?>
    
                <?php
                    // order link class
                    $seo_rankings_class = "";
                    if ($page_slug == '/seo-manager/rankings/') {
                        $seo_rankings_class = "is-active";
                    }
                ?>
                <li class="<?php echo $seo_rankings_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/rankings/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-chevron-triple-up-solid" data-name=""><path d="M16.59,9.42L12,4.83L7.41,9.42L6,8L12,2L18,8L16.59,9.42M16.59,15.42L12,10.83L7.41,15.42L6,14L12,8L18,14L16.59,15.42M16.59,21.42L12,16.83L7.41,21.42L6,20L12,14L18,20L16.59,21.42Z"></path></svg></span><span class="text">Rank Tracker</span></a></li>
                
                <?php
                    if($view_as != 'user'){
                        // seo strategy class
                        $seo_strategy_class = "";
                        if ($page_slug == '/seo-manager/seo-strategy/') {
                            $seo_strategy_class = "is-active";
                        }
                ?>
                        <li class="<?php echo $seo_strategy_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li>
                <?php } ?>
    
                <?php
                    // todos
                    $todos_class = "";
                    if ($page_slug == '/seo-manager/todos/' || $page_slug == '/seo-manager/todos/list/') {
                        $todos_class = "is-active";
                    }
                ?>
                <li class="<?php echo $todos_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/todos/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-format_list_bulleted-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M7 5h14v2H7z"></path><circle cx="4" cy="6" r="1.5"></circle><path d="M7 11h14v2H7zm0 6h14v2H7zm-3 2.5c.82 0 1.5-.68 1.5-1.5s-.67-1.5-1.5-1.5-1.5.68-1.5 1.5.68 1.5 1.5 1.5z"></path><circle cx="4" cy="12" r="1.5"></circle></svg></span><span class="text">Todos</span></a></li>
    
    
                <?php
                if($view_as != 'user'){
                    // order link class
                    $seo_learning_class = "";
                    if ($page_slug == '/seo-manager/seo-learning/') {
                        $seo_learning_class = "is-active";
                    }
                ?>
                    <li class="<?php echo $seo_learning_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-learning/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-info-circle-solid" data-name=""><path d="M256 8C119.043 8 8 119.083 8 256c0 136.997 111.043 248 248 248s248-111.003 248-248C504 119.083 392.957 8 256 8zm0 110c23.196 0 42 18.804 42 42s-18.804 42-42 42-42-18.804-42-42 18.804-42 42-42zm56 254c0 6.627-5.373 12-12 12h-88c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h12v-64h-12c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h64c6.627 0 12 5.373 12 12v100h12c6.627 0 12 5.373 12 12v24z"></path></svg></span><span class="text">SEO Learning</span></a></li>
                <?php } ?>
                <?php
                    // report history class
                    $report_history_class = "";
                    if ($page_slug == '/seo-manager/report-history/') {
                        $report_history_class = "is-active";
                    }
                ?>
                <li class="<?php echo $report_history_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/report-history/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-file-chart-outlined" data-name=""><path d="M14 2H6C4.9 2 4 2.9 4 4V20C4 21.1 4.9 22 6 22H18C19.1 22 20 21.1 20 20V8L14 2M18 20H6V4H13V9H18V20M9 13V19H7V13H9M15 15V19H17V15H15M11 11V19H13V11H11Z"></path></svg></span><span class="text">Report History</span></a></li>
    
                <?php
                    // seo strategy class
                    $seo_strategy_class = "";
                    if ($page_slug == '/seo-manager/seo-strategy/') {
                        $seo_strategy_class = "is-active";
                    }
                ?>
                <!-- <li class="<?php //echo $seo_strategy_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li> -->
    
                <?php
                    if($view_as != 'user'){
                        // payment link class
                        $payment_class = "";
                        if ($page_slug == '/seo-manager/payment-methods/' || $page_slug == '/seo-manager/add-payment-method/') {
                            $payment_class = "is-active";
                        }
                ?>
                        <li class="<?php echo $payment_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/payment-methods/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 640 512" data-id="icon-money-check-solid" data-name=""><path d="M0 448c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V128H0v320zm448-208c0-8.84 7.16-16 16-16h96c8.84 0 16 7.16 16 16v32c0 8.84-7.16 16-16 16h-96c-8.84 0-16-7.16-16-16v-32zm0 120c0-4.42 3.58-8 8-8h112c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H456c-4.42 0-8-3.58-8-8v-16zM64 264c0-4.42 3.58-8 8-8h304c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8v-16zm0 96c0-4.42 3.58-8 8-8h176c4.42 0 8 3.58 8 8v16c0 4.42-3.58 8-8 8H72c-4.42 0-8-3.58-8-8v-16zM624 32H16C7.16 32 0 39.16 0 48v48h640V48c0-8.84-7.16-16-16-16z"></path></svg></span><span class="text">Payment</span></a></li>
                <?php } ?>
            <?php } else if($user_role == "account_manager") { ?>
    
                <?php
                    // customer-information link class
                    $assigned_orders_class = "";
                    if ($page_slug == '/seo-manager/client-information/' || strpos($page_slug, 'client-information') !== false) {
                        $assigned_orders_class = "is-active";
                    }
                ?>
                <li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/client-information/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-cog-solid" data-name=""><path d="M10 4A4 4 0 0 0 6 8A4 4 0 0 0 10 12A4 4 0 0 0 14 8A4 4 0 0 0 10 4M17 12C16.87 12 16.76 12.09 16.74 12.21L16.55 13.53C16.25 13.66 15.96 13.82 15.7 14L14.46 13.5C14.35 13.5 14.22 13.5 14.15 13.63L13.15 15.36C13.09 15.47 13.11 15.6 13.21 15.68L14.27 16.5C14.25 16.67 14.24 16.83 14.24 17C14.24 17.17 14.25 17.33 14.27 17.5L13.21 18.32C13.12 18.4 13.09 18.53 13.15 18.64L14.15 20.37C14.21 20.5 14.34 20.5 14.46 20.5L15.7 20C15.96 20.18 16.24 20.35 16.55 20.47L16.74 21.79C16.76 21.91 16.86 22 17 22H19C19.11 22 19.22 21.91 19.24 21.79L19.43 20.47C19.73 20.34 20 20.18 20.27 20L21.5 20.5C21.63 20.5 21.76 20.5 21.83 20.37L22.83 18.64C22.89 18.53 22.86 18.4 22.77 18.32L21.7 17.5C21.72 17.33 21.74 17.17 21.74 17C21.74 16.83 21.73 16.67 21.7 16.5L22.76 15.68C22.85 15.6 22.88 15.47 22.82 15.36L21.82 13.63C21.76 13.5 21.63 13.5 21.5 13.5L20.27 14C20 13.82 19.73 13.65 19.42 13.53L19.23 12.21C19.22 12.09 19.11 12 19 12H17M10 14C5.58 14 2 15.79 2 18V20H11.68A7 7 0 0 1 11 17A7 7 0 0 1 11.64 14.09C11.11 14.03 10.56 14 10 14M18 15.5C18.83 15.5 19.5 16.17 19.5 17C19.5 17.83 18.83 18.5 18 18.5C17.16 18.5 16.5 17.83 16.5 17C16.5 16.17 17.17 15.5 18 15.5Z"></path></svg></span><span class="text">Clients</span></a></li>
    
                <?php /*
                    // assigned orders link class
                    $assigned_orders_class = "";
                    if ($page_slug == '/seo-manager/assigned-orders/' || strpos($page_slug, 'view-order') !== false) {
                        $assigned_orders_class = "is-active";
                    }
                ?>
                <li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/assigned-orders/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-order-bool-descending-variant-solid" data-name=""><path d="M4 3C2.89 3 2 3.89 2 5V9C2 10.11 2.89 11 4 11H8C9.11 11 10 10.11 10 9V5C10 3.89 9.11 3 8 3M8.2 4.5L9.26 5.55L5.27 9.5L2.74 6.95L3.81 5.9L5.28 7.39M4 13C2.89 13 2 13.89 2 15V19C2 20.11 2.89 21 4 21H8C9.11 21 10 20.11 10 19V15C10 13.89 9.11 13 8 13M4 15H8V19H4M12 5H22V7H12M12 19V17H22V19M12 11H22V13H12Z"></path></svg></span><span class="text">Assigned Orders</span></a></li>
                <?php */ ?>
    
                <?php
                    // seo strategy class
                    $seo_strategy_class = "";
                    if ($page_slug == '/seo-manager/seo-strategy/') {
                        $seo_strategy_class = "is-active";
                    }
                ?>
                <li class="<?php echo $seo_strategy_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/seo-strategy/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-strategy-solid" data-name=""><path d="M6.91 5.5L9.21 7.79L7.79 9.21L5.5 6.91L3.21 9.21L1.79 7.79L4.09 5.5L1.79 3.21L3.21 1.79L5.5 4.09L7.79 1.79L9.21 3.21M22.21 16.21L20.79 14.79L18.5 17.09L16.21 14.79L14.79 16.21L17.09 18.5L14.79 20.79L16.21 22.21L18.5 19.91L20.79 22.21L22.21 20.79L19.91 18.5M20.4 6.83L17.18 11L15.6 9.73L16.77 8.23A9.08 9.08 0 0 0 10.11 13.85A4.5 4.5 0 1 1 7.5 13A4 4 0 0 1 8.28 13.08A11.27 11.27 0 0 1 16.43 6.26L15 5.18L16.27 3.6M10 17.5A2.5 2.5 0 1 0 7.5 20A2.5 2.5 0 0 0 10 17.5Z"></path></svg></span><span class="text">SEO Strategy</span></a></li>
    
                <?php
                    // todos
                    $todos_class = "";
                    if ($page_slug == '/seo-manager/todos/' || $page_slug == '/seo-manager/todos/list/') {
                        $todos_class = "is-active";
                    }
                ?>
                <li class="<?php echo $todos_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/todos/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-format_list_bulleted-duotone" data-name=""><path fill="none" d="M0 0h24v24H0V0z"></path><path d="M7 5h14v2H7z"></path><circle cx="4" cy="6" r="1.5"></circle><path d="M7 11h14v2H7zm0 6h14v2H7zm-3 2.5c.82 0 1.5-.68 1.5-1.5s-.67-1.5-1.5-1.5-1.5.68-1.5 1.5.68 1.5 1.5 1.5z"></path><circle cx="4" cy="12" r="1.5"></circle></svg></span><span class="text">Todos</span></a></li>
    
                <?php
                    // tools
                    $tools_class = "";
                    if ($page_slug == '/seo-manager/tools/' || $page_slug == '/seo-manager/tools/backlink-checker/' || $page_slug == '/seo-manager/tools/domain-authority-checker/' || $page_slug == '/seo-manager/tools/wordcount/' || $page_slug == '/seo-manager/tools/anchor-count/') {
                        $tools_class = "is-active active";
                    }
                ?>
                <li class="<?php echo $tools_class; ?> menu-item-has-children"><a href=""><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-tools-solid" data-name=""><path d="M21.71 20.29L20.29 21.71A1 1 0 0 1 18.88 21.71L7 9.85A3.81 3.81 0 0 1 6 10A4 4 0 0 1 2.22 4.7L4.76 7.24L5.29 6.71L6.71 5.29L7.24 4.76L4.7 2.22A4 4 0 0 1 10 6A3.81 3.81 0 0 1 9.85 7L21.71 18.88A1 1 0 0 1 21.71 20.29M2.29 18.88A1 1 0 0 0 2.29 20.29L3.71 21.71A1 1 0 0 0 5.12 21.71L10.59 16.25L7.76 13.42M20 2L16 4V6L13.83 8.17L15.83 10.17L18 8H20L22 4Z"></path></svg></span><span class="text">Tools</span></a>
                    
                    <ul class="sub-menu">
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/backlink-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-variant-solid" data-name=""><path d="M10.59,13.41C11,13.8 11,14.44 10.59,14.83C10.2,15.22 9.56,15.22 9.17,14.83C7.22,12.88 7.22,9.71 9.17,7.76V7.76L12.71,4.22C14.66,2.27 17.83,2.27 19.78,4.22C21.73,6.17 21.73,9.34 19.78,11.29L18.29,12.78C18.3,11.96 18.17,11.14 17.89,10.36L18.36,9.88C19.54,8.71 19.54,6.81 18.36,5.64C17.19,4.46 15.29,4.46 14.12,5.64L10.59,9.17C9.41,10.34 9.41,12.24 10.59,13.41M13.41,9.17C13.8,8.78 14.44,8.78 14.83,9.17C16.78,11.12 16.78,14.29 14.83,16.24V16.24L11.29,19.78C9.34,21.73 6.17,21.73 4.22,19.78C2.27,17.83 2.27,14.66 4.22,12.71L5.71,11.22C5.7,12.04 5.83,12.86 6.11,13.65L5.64,14.12C4.46,15.29 4.46,17.19 5.64,18.36C6.81,19.54 8.71,19.54 9.88,18.36L13.41,14.83C14.59,13.66 14.59,11.76 13.41,10.59C13,10.2 13,9.56 13.41,9.17Z"></path></svg></span><span class="text">Backlink Checker</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/domain-authority-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-search-web-solid" data-name=""><path d="M15.5,14L20.5,19L19,20.5L14,15.5V14.71L13.73,14.43C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.43,13.73L14.71,14H15.5M9.5,4.5L8.95,4.53C8.71,5.05 8.34,5.93 8.07,7H10.93C10.66,5.93 10.29,5.05 10.05,4.53C9.87,4.5 9.69,4.5 9.5,4.5M13.83,7C13.24,5.97 12.29,5.17 11.15,4.78C11.39,5.31 11.7,6.08 11.93,7H13.83M5.17,7H7.07C7.3,6.08 7.61,5.31 7.85,4.78C6.71,5.17 5.76,5.97 5.17,7M4.5,9.5C4.5,10 4.58,10.53 4.73,11H6.87L6.75,9.5L6.87,8H4.73C4.58,8.47 4.5,9 4.5,9.5M14.27,11C14.42,10.53 14.5,10 14.5,9.5C14.5,9 14.42,8.47 14.27,8H12.13C12.21,8.5 12.25,9 12.25,9.5C12.25,10 12.21,10.5 12.13,11H14.27M7.87,8L7.75,9.5L7.87,11H11.13C11.21,10.5 11.25,10 11.25,9.5C11.25,9 11.21,8.5 11.13,8H7.87M9.5,14.5C9.68,14.5 9.86,14.5 10.03,14.47C10.28,13.95 10.66,13.07 10.93,12H8.07C8.34,13.07 8.72,13.95 8.97,14.47L9.5,14.5M13.83,12H11.93C11.7,12.92 11.39,13.69 11.15,14.22C12.29,13.83 13.24,13.03 13.83,12M5.17,12C5.76,13.03 6.71,13.83 7.85,14.22C7.61,13.69 7.3,12.92 7.07,12H5.17Z"></path></svg></span><span class="text">Domain Authority Checker</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/wordcount/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-text-box-outlined" data-name=""><path d="M5,3C3.89,3 3,3.89 3,5V19C3,20.11 3.89,21 5,21H19C20.11,21 21,20.11 21,19V5C21,3.89 20.11,3 19,3H5M5,5H19V19H5V5M7,7V9H17V7H7M7,11V13H17V11H7M7,15V17H14V15H7Z"></path></svg></span><span class="text">Word Count</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/anchor-count/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Anchor Count</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/content-readability/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Content Readability</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/ssl-certificate-checker/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">SSL Checker</span></a></li>
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/keyword-density/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Keyword Density</span></a></li>
                        <!-- <li><a href="<?php //echo site_url(); ?>/seo-manager/tools/keyword-extraction/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Keyword Extraction</span></a></li> -->
                        <li><a href="<?php echo site_url(); ?>/seo-manager/tools/conversion-rate-calculator/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-link-plus-solid" data-name=""><path d="M7,7H11V9H7A3,3 0 0,0 4,12A3,3 0 0,0 7,15H11V17H7A5,5 0 0,1 2,12A5,5 0 0,1 7,7M17,7A5,5 0 0,1 22,12H20A3,3 0 0,0 17,9H13V7H17M8,11H16V13H8V11M17,12H19V15H22V17H19V20H17V17H14V15H17V12Z"></path></svg></span><span class="text">Conversion Rate Calculator</span></a></li>
                    </ul>
                </li>
            <?php } else if($user_role == "administrator") { ?>
                <?php
                    // seo strategy class
                    $seo_managers_view_class = "";
                    if ($page_slug == '/seo-manager/managers/' || $page_slug == '/seo-manager/managers/manager/') {
                        $seo_managers_view_class = "is-active";
                    }
                ?>
                <li class="<?php echo $seo_managers_view_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/managers/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-group-solid" data-name=""><path d="M12,5.5A3.5,3.5 0 0,1 15.5,9A3.5,3.5 0 0,1 12,12.5A3.5,3.5 0 0,1 8.5,9A3.5,3.5 0 0,1 12,5.5M5,8C5.56,8 6.08,8.15 6.53,8.42C6.38,9.85 6.8,11.27 7.66,12.38C7.16,13.34 6.16,14 5,14A3,3 0 0,1 2,11A3,3 0 0,1 5,8M19,8A3,3 0 0,1 22,11A3,3 0 0,1 19,14C17.84,14 16.84,13.34 16.34,12.38C17.2,11.27 17.62,9.85 17.47,8.42C17.92,8.15 18.44,8 19,8M5.5,18.25C5.5,16.18 8.41,14.5 12,14.5C15.59,14.5 18.5,16.18 18.5,18.25V20H5.5V18.25M0,20V18.5C0,17.11 1.89,15.94 4.45,15.6C3.86,16.28 3.5,17.22 3.5,18.25V20H0M24,20H20.5V18.25C20.5,17.22 20.14,16.28 19.55,15.6C22.11,15.94 24,17.11 24,18.5V20Z"></path></svg></span><span class="text">SEO Managers</span></a></li>	
    
                <?php
                    // customer-information link class
                    $assigned_orders_class = "";
                    if ($page_slug == '/seo-manager/client-information/' || strpos($page_slug, 'client-information') !== false) {
                        $assigned_orders_class = "is-active";
                    }
                ?>
                <li class="<?php echo $assigned_orders_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/client-information/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-cog-solid" data-name=""><path d="M10 4A4 4 0 0 0 6 8A4 4 0 0 0 10 12A4 4 0 0 0 14 8A4 4 0 0 0 10 4M17 12C16.87 12 16.76 12.09 16.74 12.21L16.55 13.53C16.25 13.66 15.96 13.82 15.7 14L14.46 13.5C14.35 13.5 14.22 13.5 14.15 13.63L13.15 15.36C13.09 15.47 13.11 15.6 13.21 15.68L14.27 16.5C14.25 16.67 14.24 16.83 14.24 17C14.24 17.17 14.25 17.33 14.27 17.5L13.21 18.32C13.12 18.4 13.09 18.53 13.15 18.64L14.15 20.37C14.21 20.5 14.34 20.5 14.46 20.5L15.7 20C15.96 20.18 16.24 20.35 16.55 20.47L16.74 21.79C16.76 21.91 16.86 22 17 22H19C19.11 22 19.22 21.91 19.24 21.79L19.43 20.47C19.73 20.34 20 20.18 20.27 20L21.5 20.5C21.63 20.5 21.76 20.5 21.83 20.37L22.83 18.64C22.89 18.53 22.86 18.4 22.77 18.32L21.7 17.5C21.72 17.33 21.74 17.17 21.74 17C21.74 16.83 21.73 16.67 21.7 16.5L22.76 15.68C22.85 15.6 22.88 15.47 22.82 15.36L21.82 13.63C21.76 13.5 21.63 13.5 21.5 13.5L20.27 14C20 13.82 19.73 13.65 19.42 13.53L19.23 12.21C19.22 12.09 19.11 12 19 12H17M10 14C5.58 14 2 15.79 2 18V20H11.68A7 7 0 0 1 11 17A7 7 0 0 1 11.64 14.09C11.11 14.03 10.56 14 10 14M18 15.5C18.83 15.5 19.5 16.17 19.5 17C19.5 17.83 18.83 18.5 18 18.5C17.16 18.5 16.5 17.83 16.5 17C16.5 16.17 17.17 15.5 18 15.5Z"></path></svg></span><span class="text">Clients</span></a></li>
            <?php } ?>
        </ul>
        <ul class="sidebar-menu bottom border-top">
            <?php
            if($view_as != 'user'){
                // edit account link class
                $edit_account_class = "";
                if ($page_slug == '/seo-manager/edit-account/') {
                    $edit_account_class = "is-active";
                }
    
                if ($user_role != "account_manager" && $user_role != "administrator") {
            ?>
                    <li class="<?php echo $edit_account_class; ?>"><a href="<?php echo site_url(); ?>/seo-manager/edit-account/"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-map-marker-outlined" data-name=""><path d="M12,6.5A2.5,2.5 0 0,1 14.5,9A2.5,2.5 0 0,1 12,11.5A2.5,2.5 0 0,1 9.5,9A2.5,2.5 0 0,1 12,6.5M12,2A7,7 0 0,1 19,9C19,14.25 12,22 12,22C12,22 5,14.25 5,9A7,7 0 0,1 12,2M12,4A5,5 0 0,0 7,9C7,10 7,12 12,18.71C17,12 17,10 17,9A5,5 0 0,0 12,4Z"></path></svg></span><span class="text">Account Details</span></a></li>
                <?php } ?>
            <?php } ?>
    
            <!-- <li><a href=""><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 24 24" data-id="icon-account-circle-outlined" data-name=""><path d="M12,2A10,10 0 0,0 2,12A10,10 0 0,0 12,22A10,10 0 0,0 22,12A10,10 0 0,0 12,2M7.07,18.28C7.5,17.38 10.12,16.5 12,16.5C13.88,16.5 16.5,17.38 16.93,18.28C15.57,19.36 13.86,20 12,20C10.14,20 8.43,19.36 7.07,18.28M18.36,16.83C16.93,15.09 13.46,14.5 12,14.5C10.54,14.5 7.07,15.09 5.64,16.83C4.62,15.5 4,13.82 4,12C4,7.59 7.59,4 12,4C16.41,4 20,7.59 20,12C20,13.82 19.38,15.5 18.36,16.83M12,6C10.06,6 8.5,7.56 8.5,9.5C8.5,11.44 10.06,13 12,13C13.94,13 15.5,11.44 15.5,9.5C15.5,7.56 13.94,6 12,6M12,11A1.5,1.5 0 0,1 10.5,9.5A1.5,1.5 0 0,1 12,8A1.5,1.5 0 0,1 13.5,9.5A1.5,1.5 0 0,1 12,11Z"></path></svg></span><span class="text">Addresses</span></a></li> -->
    
            <li><a href="<?php echo wp_logout_url( get_site_url().'/seo-manager/' ); ?>"><span class="svg-wrap"><svg class="tcb-icon" viewBox="0 0 512 512" data-id="icon-power-off-solid" data-name=""><path d="M400 54.1c63 45 104 118.6 104 201.9 0 136.8-110.8 247.7-247.5 248C120 504.3 8.2 393 8 256.4 7.9 173.1 48.9 99.3 111.8 54.2c11.7-8.3 28-4.8 35 7.7L162.6 90c5.9 10.5 3.1 23.8-6.6 31-41.5 30.8-68 79.6-68 134.9-.1 92.3 74.5 168.1 168 168.1 91.6 0 168.6-74.2 168-169.1-.3-51.8-24.7-101.8-68.1-134-9.7-7.2-12.4-20.5-6.5-30.9l15.8-28.1c7-12.4 23.2-16.1 34.8-7.8zM296 264V24c0-13.3-10.7-24-24-24h-32c-13.3 0-24 10.7-24 24v240c0 13.3 10.7 24 24 24h32c13.3 0 24-10.7 24-24z"></path></svg></span><span class="text">Logout</span></a></li>
        </ul>
    <!-- </div> -->
</div>