<?php
/**
 * View Order
 *
 * Shows the details of a particular order on the account page.
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/view-order.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.0.0
 */

defined( 'ABSPATH' ) || exit;

$notes = $order->get_customer_order_notes();

// 
$item_id = "";

// use the user id of the customer order
// $user_id = $order->get_user_id(); // 123 amgas / 124 safehouse
$user_id = $order->get_user_id(); // 123 amgas / 124 safehouse

// get all order items 
$order_items = $order->get_items();

// get order item product id and use the said name to check if its a managed service
$page_product_id = "";

// get product id inside the order
foreach ($order_items as $key => $item) {
	// product id is the woocommerce product id
	// $product_id = $item->get_variation_id() ? $item->get_variation_id() : $item->get_product_id();

	// get the product id by page
	$page_object = get_page_by_title($item->get_name());
	$page_product_id = $page_object->ID;

	// item id is a combination of the woocommerce product id and order id
	// this should be unique
	$item_id = $page_product_id . "_" . $order_id;

	// get the clean (without https and slashes) website url
	// this is used for the gform 1
	$soriginal_url = $item->get_meta('Website URL', true);
	$soriginal_website = preg_replace('/^(http(s)?:\/\/)/', '', $soriginal_url);
}

// get customer subscriptions
$customer_subscriptions = get_posts( array(
    'numberposts' => -1,
    'meta_key'    => '_customer_user',
    'meta_value'  => $user_id, // Or $user_id or get_current_user_id()
    'post_type'   => 'shop_subscription', // WC orders post type
    'post_status' => 'wc-active' // Only orders with status "completed"
) );

// validate that this order is a child subscription orer
$validate_order = false;
$parent_order = "";

// loop through all customer subscriptions
if ($customer_subscriptions) {
	foreach ($customer_subscriptions as $key => $customer_subscription) {
		$subscription = new WC_Subscription($customer_subscription->ID);
		$subscription_parent_order = $subscription->get_parent_id();
		$subscription_order_ids = $subscription->get_related_orders();

		// check if this order is an active child subscription && if order is not the parent subscription
		if (in_array($order_id, $subscription_order_ids) && end($subscription_order_ids) != $order_id) {
			$validate_order = true;
		}

		// 
		$parent_order = $subscription_parent_order;
	}
}

// data of the user that ordered
$user            = get_user_by("ID", $user_id);
$user_email      = $user->user_email;
// $user_role       = $user->roles[0];
$user_first_name = $user->first_name;
$user_last_name  = $user->last_name;
$customer = new WC_Customer($user_id);
$customer_phone = $customer->get_billing_phone();

// user data for current user
// different from order user because the manager can view and edit
$current_user_id   = get_current_user_id();
$current_user      = get_user_by("ID", $current_user_id);
$current_user_role = $current_user->roles[0];
?>
<ul class="vo-tab-header">
	<li class="active" data-tab="order-details">Order Details</li>
	<?php if (in_array($page_product_id, MANAGED_SERVICES) && !$validate_order && $order->get_status() != 'cancelled' && $current_user_role == "administrator" || $current_user_role == "account_manager") { ?>
		<li class="d-none" data-tab="order-reports">Reports</li>
		<li class="d-none" data-tab="site-information">Keyword Report</li>
	<?php } ?>
</ul>

<!-- -->
<div class="vo-tab-content active" data-tab="order-details">
	<?php if ($current_user_role == "administrator" || $current_user_role == "account_manager") { ?>
			<div class="client-information-box mb-3">
				<table class="assigned-orders-table">
					<thead>
						<tr>
							<th colspan="3"><strong>Customer Details</strong></th>
						</tr>
						<tr>
							<th>Name</th>
							<th>Email</th>
							<th>Mobile</th>
						</tr>
					</thead>
					<tbody>
						<tr>
							<td><?php echo $user_first_name; ?> <?php echo $user_last_name; ?></td>
							<td><?php echo $user_email; ?></td>
							<td><?php echo $customer_phone; ?></td>
						</tr>
					</tbody>
				</table>
			</div>
	<?php } ?>
	<p>
	<?php
	printf(
		/* translators: 1: order number 2: order date 3: order status */
		esc_html__( 'Order #%1$s was placed on %2$s and is currently %3$s.', 'woocommerce' ),
		'<mark class="order-number">' . $order->get_order_number() . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		'<mark class="order-date">' . wc_format_datetime( $order->get_date_created() ) . '</mark>', // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
		'<mark class="order-status">' . wc_get_order_status_name( $order->get_status() ) . '</mark>' // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
	);
	?>
	</p>

	<?php if ( $notes ) : ?>
		<h2><?php esc_html_e( 'Order updates', 'woocommerce' ); ?></h2>
		<ol class="woocommerce-OrderUpdates commentlist notes">
			<?php foreach ( $notes as $note ) : ?>
			<li class="woocommerce-OrderUpdate comment note">
				<div class="woocommerce-OrderUpdate-inner comment_container">
					<div class="woocommerce-OrderUpdate-text comment-text">
						<p class="woocommerce-OrderUpdate-meta meta"><?php echo date_i18n( esc_html__( 'l jS \o\f F Y, h:ia', 'woocommerce' ), strtotime( $note->comment_date ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?></p>
						<div class="woocommerce-OrderUpdate-description description">
							<?php echo wpautop( wptexturize( $note->comment_content ) ); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped ?>
						</div>
						<div class="clear"></div>
					</div>
					<div class="clear"></div>
				</div>
			</li>
			<?php endforeach; ?>
		</ol>
	<?php endif; ?>

	<?php do_action( 'woocommerce_view_order', $order_id ); ?>
</div>